// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.serde

import aws.sdk.kotlin.services.qconnect.model.AiPromptApiFormat
import aws.sdk.kotlin.services.qconnect.model.AiPromptTemplateConfiguration
import aws.sdk.kotlin.services.qconnect.model.AiPromptTemplateType
import aws.sdk.kotlin.services.qconnect.model.AiPromptType
import aws.sdk.kotlin.services.qconnect.model.CreateAiPromptRequest
import aws.sdk.kotlin.services.qconnect.model.VisibilityStatus
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateAIPromptOperationSerializer: HttpSerializer.NonStreaming<CreateAiPromptRequest> {
    override fun serialize(context: ExecutionContext, input: CreateAiPromptRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.assistantId) { "assistantId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("assistants"))
                add(PercentEncoding.SmithyLabel.encode(input.assistantId))
                add(PercentEncoding.Path.encode("aiprompts"))
            }
        }

        val payload = serializeCreateAIPromptOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateAIPromptOperationBody(context: ExecutionContext, input: CreateAiPromptRequest): ByteArray {
    val serializer = JsonSerializer()
    val APIFORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("apiFormat"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val MODELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("modelId"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TEMPLATECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("templateConfiguration"))
    val TEMPLATETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("templateType"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("type"))
    val VISIBILITYSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("visibilityStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APIFORMAT_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(MODELID_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TEMPLATECONFIGURATION_DESCRIPTOR)
        field(TEMPLATETYPE_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
        field(VISIBILITYSTATUS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.apiFormat?.let { field(APIFORMAT_DESCRIPTOR, it.value) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.modelId?.let { field(MODELID_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.templateConfiguration?.let { field(TEMPLATECONFIGURATION_DESCRIPTOR, it, ::serializeAiPromptTemplateConfigurationDocument) }
        input.templateType?.let { field(TEMPLATETYPE_DESCRIPTOR, it.value) }
        input.type?.let { field(TYPE_DESCRIPTOR, it.value) }
        input.visibilityStatus?.let { field(VISIBILITYSTATUS_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
