// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.serde

import aws.sdk.kotlin.services.qconnect.model.AiGuardrailContentPolicyConfig
import aws.sdk.kotlin.services.qconnect.model.AiGuardrailContextualGroundingPolicyConfig
import aws.sdk.kotlin.services.qconnect.model.AiGuardrailSensitiveInformationPolicyConfig
import aws.sdk.kotlin.services.qconnect.model.AiGuardrailTopicPolicyConfig
import aws.sdk.kotlin.services.qconnect.model.AiGuardrailWordPolicyConfig
import aws.sdk.kotlin.services.qconnect.model.CreateAiGuardrailRequest
import aws.sdk.kotlin.services.qconnect.model.VisibilityStatus
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateAIGuardrailOperationSerializer: HttpSerializer.NonStreaming<CreateAiGuardrailRequest> {
    override fun serialize(context: ExecutionContext, input: CreateAiGuardrailRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.assistantId) { "assistantId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("assistants"))
                add(PercentEncoding.SmithyLabel.encode(input.assistantId))
                add(PercentEncoding.Path.encode("aiguardrails"))
            }
        }

        val payload = serializeCreateAIGuardrailOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateAIGuardrailOperationBody(context: ExecutionContext, input: CreateAiGuardrailRequest): ByteArray {
    val serializer = JsonSerializer()
    val BLOCKEDINPUTMESSAGING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("blockedInputMessaging"))
    val BLOCKEDOUTPUTSMESSAGING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("blockedOutputsMessaging"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val CONTENTPOLICYCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("contentPolicyConfig"))
    val CONTEXTUALGROUNDINGPOLICYCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("contextualGroundingPolicyConfig"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val SENSITIVEINFORMATIONPOLICYCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("sensitiveInformationPolicyConfig"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TOPICPOLICYCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("topicPolicyConfig"))
    val VISIBILITYSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("visibilityStatus"))
    val WORDPOLICYCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("wordPolicyConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BLOCKEDINPUTMESSAGING_DESCRIPTOR)
        field(BLOCKEDOUTPUTSMESSAGING_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(CONTENTPOLICYCONFIG_DESCRIPTOR)
        field(CONTEXTUALGROUNDINGPOLICYCONFIG_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(SENSITIVEINFORMATIONPOLICYCONFIG_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TOPICPOLICYCONFIG_DESCRIPTOR)
        field(VISIBILITYSTATUS_DESCRIPTOR)
        field(WORDPOLICYCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.blockedInputMessaging?.let { field(BLOCKEDINPUTMESSAGING_DESCRIPTOR, it) }
        input.blockedOutputsMessaging?.let { field(BLOCKEDOUTPUTSMESSAGING_DESCRIPTOR, it) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.contentPolicyConfig?.let { field(CONTENTPOLICYCONFIG_DESCRIPTOR, it, ::serializeAiGuardrailContentPolicyConfigDocument) }
        input.contextualGroundingPolicyConfig?.let { field(CONTEXTUALGROUNDINGPOLICYCONFIG_DESCRIPTOR, it, ::serializeAiGuardrailContextualGroundingPolicyConfigDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.sensitiveInformationPolicyConfig?.let { field(SENSITIVEINFORMATIONPOLICYCONFIG_DESCRIPTOR, it, ::serializeAiGuardrailSensitiveInformationPolicyConfigDocument) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.topicPolicyConfig?.let { field(TOPICPOLICYCONFIG_DESCRIPTOR, it, ::serializeAiGuardrailTopicPolicyConfigDocument) }
        input.visibilityStatus?.let { field(VISIBILITYSTATUS_DESCRIPTOR, it.value) }
        input.wordPolicyConfig?.let { field(WORDPOLICYCONFIG_DESCRIPTOR, it, ::serializeAiGuardrailWordPolicyConfigDocument) }
    }
    return serializer.toByteArray()
}
