// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateContentRequest private constructor(builder: Builder) {
    /**
     * The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    public val contentId: kotlin.String = requireNotNull(builder.contentId) { "A non-null value must be provided for contentId" }
    /**
     * The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base. Can be either the ID or the ARN
     */
    public val knowledgeBaseId: kotlin.String = requireNotNull(builder.knowledgeBaseId) { "A non-null value must be provided for knowledgeBaseId" }
    /**
     * A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Amazon Q in Connect, you can store an external version identifier as metadata to utilize for determining drift.
     */
    public val metadata: Map<String, String>? = builder.metadata
    /**
     * The URI for the article. If the knowledge base has a templateUri, setting this argument overrides it for this piece of content. To remove an existing `overrideLinkOurUri`, exclude this argument and set `removeOverrideLinkOutUri` to true.
     */
    public val overrideLinkOutUri: kotlin.String? = builder.overrideLinkOutUri
    /**
     * Unset the existing `overrideLinkOutUri` if it exists.
     */
    public val removeOverrideLinkOutUri: kotlin.Boolean? = builder.removeOverrideLinkOutUri
    /**
     * The `revisionId` of the content resource to update, taken from an earlier call to `GetContent`, `GetContentSummary`, `SearchContent`, or `ListContents`. If included, this argument acts as an optimistic lock to ensure content was not modified since it was last read. If it has been modified, this API throws a `PreconditionFailedException`.
     */
    public val revisionId: kotlin.String? = builder.revisionId
    /**
     * The title of the content.
     */
    public val title: kotlin.String? = builder.title
    /**
     * A pointer to the uploaded asset. This value is returned by [StartContentUpload](https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_StartContentUpload.html).
     */
    public val uploadId: kotlin.String? = builder.uploadId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.UpdateContentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateContentRequest(")
        append("contentId=$contentId,")
        append("knowledgeBaseId=$knowledgeBaseId,")
        append("metadata=$metadata,")
        append("overrideLinkOutUri=$overrideLinkOutUri,")
        append("removeOverrideLinkOutUri=$removeOverrideLinkOutUri,")
        append("revisionId=$revisionId,")
        append("title=$title,")
        append("uploadId=$uploadId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contentId.hashCode()
        result = 31 * result + (knowledgeBaseId.hashCode())
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (overrideLinkOutUri?.hashCode() ?: 0)
        result = 31 * result + (removeOverrideLinkOutUri?.hashCode() ?: 0)
        result = 31 * result + (revisionId?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (uploadId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateContentRequest

        if (contentId != other.contentId) return false
        if (knowledgeBaseId != other.knowledgeBaseId) return false
        if (metadata != other.metadata) return false
        if (overrideLinkOutUri != other.overrideLinkOutUri) return false
        if (removeOverrideLinkOutUri != other.removeOverrideLinkOutUri) return false
        if (revisionId != other.revisionId) return false
        if (title != other.title) return false
        if (uploadId != other.uploadId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.UpdateContentRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.
         */
        public var contentId: kotlin.String? = null
        /**
         * The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base. Can be either the ID or the ARN
         */
        public var knowledgeBaseId: kotlin.String? = null
        /**
         * A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Amazon Q in Connect, you can store an external version identifier as metadata to utilize for determining drift.
         */
        public var metadata: Map<String, String>? = null
        /**
         * The URI for the article. If the knowledge base has a templateUri, setting this argument overrides it for this piece of content. To remove an existing `overrideLinkOurUri`, exclude this argument and set `removeOverrideLinkOutUri` to true.
         */
        public var overrideLinkOutUri: kotlin.String? = null
        /**
         * Unset the existing `overrideLinkOutUri` if it exists.
         */
        public var removeOverrideLinkOutUri: kotlin.Boolean? = null
        /**
         * The `revisionId` of the content resource to update, taken from an earlier call to `GetContent`, `GetContentSummary`, `SearchContent`, or `ListContents`. If included, this argument acts as an optimistic lock to ensure content was not modified since it was last read. If it has been modified, this API throws a `PreconditionFailedException`.
         */
        public var revisionId: kotlin.String? = null
        /**
         * The title of the content.
         */
        public var title: kotlin.String? = null
        /**
         * A pointer to the uploaded asset. This value is returned by [StartContentUpload](https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_StartContentUpload.html).
         */
        public var uploadId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.UpdateContentRequest) : this() {
            this.contentId = x.contentId
            this.knowledgeBaseId = x.knowledgeBaseId
            this.metadata = x.metadata
            this.overrideLinkOutUri = x.overrideLinkOutUri
            this.removeOverrideLinkOutUri = x.removeOverrideLinkOutUri
            this.revisionId = x.revisionId
            this.title = x.title
            this.uploadId = x.uploadId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.UpdateContentRequest = UpdateContentRequest(this)

        internal fun correctErrors(): Builder {
            if (contentId == null) contentId = ""
            if (knowledgeBaseId == null) knowledgeBaseId = ""
            return this
        }
    }
}
