// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the session.
 */
public class SessionData private constructor(builder: Builder) {
    /**
     * The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used by Amazon Q in Connect for this Session.
     */
    public val aiAgentConfiguration: Map<AiAgentType, AiAgentConfigurationData>? = builder.aiAgentConfiguration
    /**
     * The description of the session.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The configuration information for the session integration.
     */
    public val integrationConfiguration: aws.sdk.kotlin.services.qconnect.model.SessionIntegrationConfiguration? = builder.integrationConfiguration
    /**
     * The name of the session.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The origin of the Session to be listed. `SYSTEM` for a default Session created by Amazon Q in Connect or `CUSTOMER` for a Session created by calling [CreateSession](https://docs.aws.amazon.com/connect/latest/APIReference/API_amazon-q-connect_CreateSession.html) API.
     */
    public val origin: aws.sdk.kotlin.services.qconnect.model.Origin? = builder.origin
    /**
     * The Amazon Resource Name (ARN) of the session.
     */
    public val sessionArn: kotlin.String = requireNotNull(builder.sessionArn) { "A non-null value must be provided for sessionArn" }
    /**
     * The identifier of the session.
     */
    public val sessionId: kotlin.String = requireNotNull(builder.sessionId) { "A non-null value must be provided for sessionId" }
    /**
     * An object that can be used to specify Tag conditions.
     */
    public val tagFilter: aws.sdk.kotlin.services.qconnect.model.TagFilter? = builder.tagFilter
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.SessionData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SessionData(")
        append("aiAgentConfiguration=$aiAgentConfiguration,")
        append("description=$description,")
        append("integrationConfiguration=$integrationConfiguration,")
        append("name=$name,")
        append("origin=$origin,")
        append("sessionArn=$sessionArn,")
        append("sessionId=$sessionId,")
        append("tagFilter=$tagFilter,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aiAgentConfiguration?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (integrationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (origin?.hashCode() ?: 0)
        result = 31 * result + (sessionArn.hashCode())
        result = 31 * result + (sessionId.hashCode())
        result = 31 * result + (tagFilter?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SessionData

        if (aiAgentConfiguration != other.aiAgentConfiguration) return false
        if (description != other.description) return false
        if (integrationConfiguration != other.integrationConfiguration) return false
        if (name != other.name) return false
        if (origin != other.origin) return false
        if (sessionArn != other.sessionArn) return false
        if (sessionId != other.sessionId) return false
        if (tagFilter != other.tagFilter) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.SessionData = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used by Amazon Q in Connect for this Session.
         */
        public var aiAgentConfiguration: Map<AiAgentType, AiAgentConfigurationData>? = null
        /**
         * The description of the session.
         */
        public var description: kotlin.String? = null
        /**
         * The configuration information for the session integration.
         */
        public var integrationConfiguration: aws.sdk.kotlin.services.qconnect.model.SessionIntegrationConfiguration? = null
        /**
         * The name of the session.
         */
        public var name: kotlin.String? = null
        /**
         * The origin of the Session to be listed. `SYSTEM` for a default Session created by Amazon Q in Connect or `CUSTOMER` for a Session created by calling [CreateSession](https://docs.aws.amazon.com/connect/latest/APIReference/API_amazon-q-connect_CreateSession.html) API.
         */
        public var origin: aws.sdk.kotlin.services.qconnect.model.Origin? = null
        /**
         * The Amazon Resource Name (ARN) of the session.
         */
        public var sessionArn: kotlin.String? = null
        /**
         * The identifier of the session.
         */
        public var sessionId: kotlin.String? = null
        /**
         * An object that can be used to specify Tag conditions.
         */
        public var tagFilter: aws.sdk.kotlin.services.qconnect.model.TagFilter? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.SessionData) : this() {
            this.aiAgentConfiguration = x.aiAgentConfiguration
            this.description = x.description
            this.integrationConfiguration = x.integrationConfiguration
            this.name = x.name
            this.origin = x.origin
            this.sessionArn = x.sessionArn
            this.sessionId = x.sessionId
            this.tagFilter = x.tagFilter
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.SessionData = SessionData(this)

        /**
         * construct an [aws.sdk.kotlin.services.qconnect.model.SessionIntegrationConfiguration] inside the given [block]
         */
        public fun integrationConfiguration(block: aws.sdk.kotlin.services.qconnect.model.SessionIntegrationConfiguration.Builder.() -> kotlin.Unit) {
            this.integrationConfiguration = aws.sdk.kotlin.services.qconnect.model.SessionIntegrationConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (sessionArn == null) sessionArn = ""
            if (sessionId == null) sessionId = ""
            return this
        }
    }
}
