// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class SearchQuickResponsesRequest private constructor(builder: Builder) {
    /**
     * The [user-defined Amazon Connect contact attributes](https://docs.aws.amazon.com/connect/latest/adminguide/connect-attrib-list.html#user-defined-attributes) to be resolved when search results are returned.
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * The identifier of the knowledge base. This should be a QUICK_RESPONSES type knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    public val knowledgeBaseId: kotlin.String? = builder.knowledgeBaseId
    /**
     * The maximum number of results to return per page.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The search expression for querying the quick response.
     */
    public val searchExpression: aws.sdk.kotlin.services.qconnect.model.QuickResponseSearchExpression? = builder.searchExpression

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.SearchQuickResponsesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchQuickResponsesRequest(")
        append("attributes=*** Sensitive Data Redacted ***,")
        append("knowledgeBaseId=$knowledgeBaseId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("searchExpression=$searchExpression")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (knowledgeBaseId?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (searchExpression?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchQuickResponsesRequest

        if (attributes != other.attributes) return false
        if (knowledgeBaseId != other.knowledgeBaseId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (searchExpression != other.searchExpression) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.SearchQuickResponsesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The [user-defined Amazon Connect contact attributes](https://docs.aws.amazon.com/connect/latest/adminguide/connect-attrib-list.html#user-defined-attributes) to be resolved when search results are returned.
         */
        public var attributes: Map<String, String>? = null
        /**
         * The identifier of the knowledge base. This should be a QUICK_RESPONSES type knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
         */
        public var knowledgeBaseId: kotlin.String? = null
        /**
         * The maximum number of results to return per page.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The search expression for querying the quick response.
         */
        public var searchExpression: aws.sdk.kotlin.services.qconnect.model.QuickResponseSearchExpression? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.SearchQuickResponsesRequest) : this() {
            this.attributes = x.attributes
            this.knowledgeBaseId = x.knowledgeBaseId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.searchExpression = x.searchExpression
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.SearchQuickResponsesRequest = SearchQuickResponsesRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.qconnect.model.QuickResponseSearchExpression] inside the given [block]
         */
        public fun searchExpression(block: aws.sdk.kotlin.services.qconnect.model.QuickResponseSearchExpression.Builder.() -> kotlin.Unit) {
            this.searchExpression = aws.sdk.kotlin.services.qconnect.model.QuickResponseSearchExpression.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
