// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A recommendation trigger provides context on the event that produced the referenced recommendations. Recommendations are only referenced in `recommendationIds` by a single RecommendationTrigger.
 */
public class RecommendationTrigger private constructor(builder: Builder) {
    /**
     * A union type containing information related to the trigger.
     */
    public val data: aws.sdk.kotlin.services.qconnect.model.RecommendationTriggerData? = builder.data
    /**
     * The identifier of the recommendation trigger.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The identifiers of the recommendations.
     */
    public val recommendationIds: List<String> = requireNotNull(builder.recommendationIds) { "A non-null value must be provided for recommendationIds" }
    /**
     * The source of the recommendation trigger.
     * + ISSUE_DETECTION: The corresponding recommendations were triggered by a Contact Lens issue.
     * + RULE_EVALUATION: The corresponding recommendations were triggered by a Contact Lens rule.
     */
    public val source: aws.sdk.kotlin.services.qconnect.model.RecommendationSourceType = requireNotNull(builder.source) { "A non-null value must be provided for source" }
    /**
     * The type of recommendation trigger.
     */
    public val type: aws.sdk.kotlin.services.qconnect.model.RecommendationTriggerType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.RecommendationTrigger = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecommendationTrigger(")
        append("data=$data,")
        append("id=$id,")
        append("recommendationIds=$recommendationIds,")
        append("source=$source,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = data?.hashCode() ?: 0
        result = 31 * result + (id.hashCode())
        result = 31 * result + (recommendationIds.hashCode())
        result = 31 * result + (source.hashCode())
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecommendationTrigger

        if (data != other.data) return false
        if (id != other.id) return false
        if (recommendationIds != other.recommendationIds) return false
        if (source != other.source) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.RecommendationTrigger = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A union type containing information related to the trigger.
         */
        public var data: aws.sdk.kotlin.services.qconnect.model.RecommendationTriggerData? = null
        /**
         * The identifier of the recommendation trigger.
         */
        public var id: kotlin.String? = null
        /**
         * The identifiers of the recommendations.
         */
        public var recommendationIds: List<String>? = null
        /**
         * The source of the recommendation trigger.
         * + ISSUE_DETECTION: The corresponding recommendations were triggered by a Contact Lens issue.
         * + RULE_EVALUATION: The corresponding recommendations were triggered by a Contact Lens rule.
         */
        public var source: aws.sdk.kotlin.services.qconnect.model.RecommendationSourceType? = null
        /**
         * The type of recommendation trigger.
         */
        public var type: aws.sdk.kotlin.services.qconnect.model.RecommendationTriggerType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.RecommendationTrigger) : this() {
            this.data = x.data
            this.id = x.id
            this.recommendationIds = x.recommendationIds
            this.source = x.source
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.RecommendationTrigger = RecommendationTrigger(this)

        internal fun correctErrors(): Builder {
            if (id == null) id = ""
            if (recommendationIds == null) recommendationIds = emptyList()
            if (source == null) source = RecommendationSourceType.SdkUnknown("no value provided")
            if (type == null) type = RecommendationTriggerType.SdkUnknown("no value provided")
            return this
        }
    }
}
