// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The summary information about the quick response.
 */
public class QuickResponseSummary private constructor(builder: Builder) {
    /**
     * The Amazon Connect contact channels this quick response applies to. The supported contact channel types include `Chat`.
     */
    public val channels: List<String>? = builder.channels
    /**
     * The media type of the quick response content.
     * + Use `application/x.quickresponse;format=plain` for quick response written in plain text.
     * + Use `application/x.quickresponse;format=markdown` for quick response written in richtext.
     */
    public val contentType: kotlin.String = requireNotNull(builder.contentType) { "A non-null value must be provided for contentType" }
    /**
     * The timestamp when the quick response was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdTime) { "A non-null value must be provided for createdTime" }
    /**
     * The description of the quick response.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Whether the quick response is active.
     */
    public val isActive: kotlin.Boolean? = builder.isActive
    /**
     * The Amazon Resource Name (ARN) of the knowledge base.
     */
    public val knowledgeBaseArn: kotlin.String = requireNotNull(builder.knowledgeBaseArn) { "A non-null value must be provided for knowledgeBaseArn" }
    /**
     * The identifier of the knowledge base.
     */
    public val knowledgeBaseId: kotlin.String = requireNotNull(builder.knowledgeBaseId) { "A non-null value must be provided for knowledgeBaseId" }
    /**
     * The Amazon Resource Name (ARN) of the user who last updated the quick response data.
     */
    public val lastModifiedBy: kotlin.String? = builder.lastModifiedBy
    /**
     * The timestamp when the quick response summary was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastModifiedTime) { "A non-null value must be provided for lastModifiedTime" }
    /**
     * The name of the quick response.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The Amazon Resource Name (ARN) of the quick response.
     */
    public val quickResponseArn: kotlin.String = requireNotNull(builder.quickResponseArn) { "A non-null value must be provided for quickResponseArn" }
    /**
     * The identifier of the quick response.
     */
    public val quickResponseId: kotlin.String = requireNotNull(builder.quickResponseId) { "A non-null value must be provided for quickResponseId" }
    /**
     * The resource status of the quick response.
     */
    public val status: aws.sdk.kotlin.services.qconnect.model.QuickResponseStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.QuickResponseSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QuickResponseSummary(")
        append("channels=*** Sensitive Data Redacted ***,")
        append("contentType=$contentType,")
        append("createdTime=$createdTime,")
        append("description=$description,")
        append("isActive=$isActive,")
        append("knowledgeBaseArn=$knowledgeBaseArn,")
        append("knowledgeBaseId=$knowledgeBaseId,")
        append("lastModifiedBy=$lastModifiedBy,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("name=$name,")
        append("quickResponseArn=$quickResponseArn,")
        append("quickResponseId=$quickResponseId,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = channels?.hashCode() ?: 0
        result = 31 * result + (contentType.hashCode())
        result = 31 * result + (createdTime.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (isActive?.hashCode() ?: 0)
        result = 31 * result + (knowledgeBaseArn.hashCode())
        result = 31 * result + (knowledgeBaseId.hashCode())
        result = 31 * result + (lastModifiedBy?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (quickResponseArn.hashCode())
        result = 31 * result + (quickResponseId.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QuickResponseSummary

        if (channels != other.channels) return false
        if (contentType != other.contentType) return false
        if (createdTime != other.createdTime) return false
        if (description != other.description) return false
        if (isActive != other.isActive) return false
        if (knowledgeBaseArn != other.knowledgeBaseArn) return false
        if (knowledgeBaseId != other.knowledgeBaseId) return false
        if (lastModifiedBy != other.lastModifiedBy) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (name != other.name) return false
        if (quickResponseArn != other.quickResponseArn) return false
        if (quickResponseId != other.quickResponseId) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.QuickResponseSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Connect contact channels this quick response applies to. The supported contact channel types include `Chat`.
         */
        public var channels: List<String>? = null
        /**
         * The media type of the quick response content.
         * + Use `application/x.quickresponse;format=plain` for quick response written in plain text.
         * + Use `application/x.quickresponse;format=markdown` for quick response written in richtext.
         */
        public var contentType: kotlin.String? = null
        /**
         * The timestamp when the quick response was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the quick response.
         */
        public var description: kotlin.String? = null
        /**
         * Whether the quick response is active.
         */
        public var isActive: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the knowledge base.
         */
        public var knowledgeBaseArn: kotlin.String? = null
        /**
         * The identifier of the knowledge base.
         */
        public var knowledgeBaseId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the user who last updated the quick response data.
         */
        public var lastModifiedBy: kotlin.String? = null
        /**
         * The timestamp when the quick response summary was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the quick response.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the quick response.
         */
        public var quickResponseArn: kotlin.String? = null
        /**
         * The identifier of the quick response.
         */
        public var quickResponseId: kotlin.String? = null
        /**
         * The resource status of the quick response.
         */
        public var status: aws.sdk.kotlin.services.qconnect.model.QuickResponseStatus? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.QuickResponseSummary) : this() {
            this.channels = x.channels
            this.contentType = x.contentType
            this.createdTime = x.createdTime
            this.description = x.description
            this.isActive = x.isActive
            this.knowledgeBaseArn = x.knowledgeBaseArn
            this.knowledgeBaseId = x.knowledgeBaseId
            this.lastModifiedBy = x.lastModifiedBy
            this.lastModifiedTime = x.lastModifiedTime
            this.name = x.name
            this.quickResponseArn = x.quickResponseArn
            this.quickResponseId = x.quickResponseId
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.QuickResponseSummary = QuickResponseSummary(this)

        internal fun correctErrors(): Builder {
            if (contentType == null) contentType = ""
            if (createdTime == null) createdTime = Instant.fromEpochSeconds(0)
            if (knowledgeBaseArn == null) knowledgeBaseArn = ""
            if (knowledgeBaseId == null) knowledgeBaseId = ""
            if (lastModifiedTime == null) lastModifiedTime = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            if (quickResponseArn == null) quickResponseArn = ""
            if (quickResponseId == null) quickResponseId = ""
            if (status == null) status = QuickResponseStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
