// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The quick response fields to query quick responses by.
 *
 * The following is the list of supported field names.
 * + content
 * + name
 * + description
 * + shortcutKey
 */
public class QuickResponseQueryField private constructor(builder: Builder) {
    /**
     * Whether the query expects only exact matches on the attribute field values. The results of the query will only include exact matches if this parameter is set to false.
     */
    public val allowFuzziness: kotlin.Boolean? = builder.allowFuzziness
    /**
     * The name of the attribute to query the quick responses by.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The operator to use for matching attribute field values in the query.
     */
    public val operator: aws.sdk.kotlin.services.qconnect.model.QuickResponseQueryOperator = requireNotNull(builder.operator) { "A non-null value must be provided for operator" }
    /**
     * The importance of the attribute field when calculating query result relevancy scores. The value set for this parameter affects the ordering of search results.
     */
    public val priority: aws.sdk.kotlin.services.qconnect.model.Priority? = builder.priority
    /**
     * The values of the attribute to query the quick responses by.
     */
    public val values: List<String> = requireNotNull(builder.values) { "A non-null value must be provided for values" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.QuickResponseQueryField = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QuickResponseQueryField(")
        append("allowFuzziness=$allowFuzziness,")
        append("name=$name,")
        append("operator=$operator,")
        append("priority=$priority,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowFuzziness?.hashCode() ?: 0
        result = 31 * result + (name.hashCode())
        result = 31 * result + (operator.hashCode())
        result = 31 * result + (priority?.hashCode() ?: 0)
        result = 31 * result + (values.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QuickResponseQueryField

        if (allowFuzziness != other.allowFuzziness) return false
        if (name != other.name) return false
        if (operator != other.operator) return false
        if (priority != other.priority) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.QuickResponseQueryField = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Whether the query expects only exact matches on the attribute field values. The results of the query will only include exact matches if this parameter is set to false.
         */
        public var allowFuzziness: kotlin.Boolean? = null
        /**
         * The name of the attribute to query the quick responses by.
         */
        public var name: kotlin.String? = null
        /**
         * The operator to use for matching attribute field values in the query.
         */
        public var operator: aws.sdk.kotlin.services.qconnect.model.QuickResponseQueryOperator? = null
        /**
         * The importance of the attribute field when calculating query result relevancy scores. The value set for this parameter affects the ordering of search results.
         */
        public var priority: aws.sdk.kotlin.services.qconnect.model.Priority? = null
        /**
         * The values of the attribute to query the quick responses by.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.QuickResponseQueryField) : this() {
            this.allowFuzziness = x.allowFuzziness
            this.name = x.name
            this.operator = x.operator
            this.priority = x.priority
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.QuickResponseQueryField = QuickResponseQueryField(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (operator == null) operator = QuickResponseQueryOperator.SdkUnknown("no value provided")
            if (values == null) values = emptyList()
            return this
        }
    }
}
