// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class QueryAssistantRequest private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    public val assistantId: kotlin.String = requireNotNull(builder.assistantId) { "A non-null value must be provided for assistantId" }
    /**
     * The maximum number of results to return per page.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The search type to be used against the Knowledge Base for this request. The values can be `SEMANTIC` which uses vector embeddings or `HYBRID` which use vector embeddings and raw text.
     */
    public val overrideKnowledgeBaseSearchType: aws.sdk.kotlin.services.qconnect.model.KnowledgeBaseSearchType? = builder.overrideKnowledgeBaseSearchType
    /**
     * Information about how to query content.
     */
    public val queryCondition: List<QueryCondition>? = builder.queryCondition
    /**
     * Information about the query.
     */
    public val queryInputData: aws.sdk.kotlin.services.qconnect.model.QueryInputData? = builder.queryInputData
    /**
     * The text to search for.
     */
    public val queryText: kotlin.String? = builder.queryText
    /**
     * The identifier of the Amazon Q in Connect session. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    public val sessionId: kotlin.String? = builder.sessionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.QueryAssistantRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryAssistantRequest(")
        append("assistantId=$assistantId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("overrideKnowledgeBaseSearchType=$overrideKnowledgeBaseSearchType,")
        append("queryCondition=$queryCondition,")
        append("queryInputData=$queryInputData,")
        append("queryText=*** Sensitive Data Redacted ***,")
        append("sessionId=$sessionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assistantId.hashCode()
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (overrideKnowledgeBaseSearchType?.hashCode() ?: 0)
        result = 31 * result + (queryCondition?.hashCode() ?: 0)
        result = 31 * result + (queryInputData?.hashCode() ?: 0)
        result = 31 * result + (queryText?.hashCode() ?: 0)
        result = 31 * result + (sessionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryAssistantRequest

        if (assistantId != other.assistantId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (overrideKnowledgeBaseSearchType != other.overrideKnowledgeBaseSearchType) return false
        if (queryCondition != other.queryCondition) return false
        if (queryInputData != other.queryInputData) return false
        if (queryText != other.queryText) return false
        if (sessionId != other.sessionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.QueryAssistantRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
         */
        public var assistantId: kotlin.String? = null
        /**
         * The maximum number of results to return per page.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The search type to be used against the Knowledge Base for this request. The values can be `SEMANTIC` which uses vector embeddings or `HYBRID` which use vector embeddings and raw text.
         */
        public var overrideKnowledgeBaseSearchType: aws.sdk.kotlin.services.qconnect.model.KnowledgeBaseSearchType? = null
        /**
         * Information about how to query content.
         */
        public var queryCondition: List<QueryCondition>? = null
        /**
         * Information about the query.
         */
        public var queryInputData: aws.sdk.kotlin.services.qconnect.model.QueryInputData? = null
        /**
         * The text to search for.
         */
        public var queryText: kotlin.String? = null
        /**
         * The identifier of the Amazon Q in Connect session. Can be either the ID or the ARN. URLs cannot contain the ARN.
         */
        public var sessionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.QueryAssistantRequest) : this() {
            this.assistantId = x.assistantId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.overrideKnowledgeBaseSearchType = x.overrideKnowledgeBaseSearchType
            this.queryCondition = x.queryCondition
            this.queryInputData = x.queryInputData
            this.queryText = x.queryText
            this.sessionId = x.sessionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.QueryAssistantRequest = QueryAssistantRequest(this)

        internal fun correctErrors(): Builder {
            if (assistantId == null) assistantId = ""
            return this
        }
    }
}
