// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The summary of the message template.
 */
public class MessageTemplateSummary private constructor(builder: Builder) {
    /**
     * The version number of the message template version that is activated.
     */
    public val activeVersionNumber: kotlin.Long? = builder.activeVersionNumber
    /**
     * The channel subtype this message template applies to.
     */
    public val channelSubtype: aws.sdk.kotlin.services.qconnect.model.ChannelSubtype = requireNotNull(builder.channelSubtype) { "A non-null value must be provided for channelSubtype" }
    /**
     * The timestamp when the message template was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdTime) { "A non-null value must be provided for createdTime" }
    /**
     * The description of the message template.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name (ARN) of the knowledge base.
     */
    public val knowledgeBaseArn: kotlin.String = requireNotNull(builder.knowledgeBaseArn) { "A non-null value must be provided for knowledgeBaseArn" }
    /**
     * The identifier of the knowledge base.
     */
    public val knowledgeBaseId: kotlin.String = requireNotNull(builder.knowledgeBaseId) { "A non-null value must be provided for knowledgeBaseId" }
    /**
     * The Amazon Resource Name (ARN) of the user who last updated the message template data.
     */
    public val lastModifiedBy: kotlin.String = requireNotNull(builder.lastModifiedBy) { "A non-null value must be provided for lastModifiedBy" }
    /**
     * The timestamp when the message template data was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastModifiedTime) { "A non-null value must be provided for lastModifiedTime" }
    /**
     * The Amazon Resource Name (ARN) of the message template.
     */
    public val messageTemplateArn: kotlin.String = requireNotNull(builder.messageTemplateArn) { "A non-null value must be provided for messageTemplateArn" }
    /**
     * The identifier of the message template.
     */
    public val messageTemplateId: kotlin.String = requireNotNull(builder.messageTemplateId) { "A non-null value must be provided for messageTemplateId" }
    /**
     * The name of the message template.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.MessageTemplateSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MessageTemplateSummary(")
        append("activeVersionNumber=$activeVersionNumber,")
        append("channelSubtype=$channelSubtype,")
        append("createdTime=$createdTime,")
        append("description=$description,")
        append("knowledgeBaseArn=$knowledgeBaseArn,")
        append("knowledgeBaseId=$knowledgeBaseId,")
        append("lastModifiedBy=$lastModifiedBy,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("messageTemplateArn=$messageTemplateArn,")
        append("messageTemplateId=$messageTemplateId,")
        append("name=$name,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeVersionNumber?.hashCode() ?: 0
        result = 31 * result + (channelSubtype.hashCode())
        result = 31 * result + (createdTime.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (knowledgeBaseArn.hashCode())
        result = 31 * result + (knowledgeBaseId.hashCode())
        result = 31 * result + (lastModifiedBy.hashCode())
        result = 31 * result + (lastModifiedTime.hashCode())
        result = 31 * result + (messageTemplateArn.hashCode())
        result = 31 * result + (messageTemplateId.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MessageTemplateSummary

        if (activeVersionNumber != other.activeVersionNumber) return false
        if (channelSubtype != other.channelSubtype) return false
        if (createdTime != other.createdTime) return false
        if (description != other.description) return false
        if (knowledgeBaseArn != other.knowledgeBaseArn) return false
        if (knowledgeBaseId != other.knowledgeBaseId) return false
        if (lastModifiedBy != other.lastModifiedBy) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (messageTemplateArn != other.messageTemplateArn) return false
        if (messageTemplateId != other.messageTemplateId) return false
        if (name != other.name) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.MessageTemplateSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The version number of the message template version that is activated.
         */
        public var activeVersionNumber: kotlin.Long? = null
        /**
         * The channel subtype this message template applies to.
         */
        public var channelSubtype: aws.sdk.kotlin.services.qconnect.model.ChannelSubtype? = null
        /**
         * The timestamp when the message template was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the message template.
         */
        public var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the knowledge base.
         */
        public var knowledgeBaseArn: kotlin.String? = null
        /**
         * The identifier of the knowledge base.
         */
        public var knowledgeBaseId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the user who last updated the message template data.
         */
        public var lastModifiedBy: kotlin.String? = null
        /**
         * The timestamp when the message template data was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the message template.
         */
        public var messageTemplateArn: kotlin.String? = null
        /**
         * The identifier of the message template.
         */
        public var messageTemplateId: kotlin.String? = null
        /**
         * The name of the message template.
         */
        public var name: kotlin.String? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.MessageTemplateSummary) : this() {
            this.activeVersionNumber = x.activeVersionNumber
            this.channelSubtype = x.channelSubtype
            this.createdTime = x.createdTime
            this.description = x.description
            this.knowledgeBaseArn = x.knowledgeBaseArn
            this.knowledgeBaseId = x.knowledgeBaseId
            this.lastModifiedBy = x.lastModifiedBy
            this.lastModifiedTime = x.lastModifiedTime
            this.messageTemplateArn = x.messageTemplateArn
            this.messageTemplateId = x.messageTemplateId
            this.name = x.name
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.MessageTemplateSummary = MessageTemplateSummary(this)

        internal fun correctErrors(): Builder {
            if (channelSubtype == null) channelSubtype = ChannelSubtype.SdkUnknown("no value provided")
            if (createdTime == null) createdTime = Instant.fromEpochSeconds(0)
            if (knowledgeBaseArn == null) knowledgeBaseArn = ""
            if (knowledgeBaseId == null) knowledgeBaseId = ""
            if (lastModifiedBy == null) lastModifiedBy = ""
            if (lastModifiedTime == null) lastModifiedTime = Instant.fromEpochSeconds(0)
            if (messageTemplateArn == null) messageTemplateArn = ""
            if (messageTemplateId == null) messageTemplateId = ""
            if (name == null) name = ""
            return this
        }
    }
}
