// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The data of a message template.
 */
public class MessageTemplateData private constructor(builder: Builder) {
    /**
     * The types of attributes that the message template contains.
     */
    public val attributeTypes: List<MessageTemplateAttributeType>? = builder.attributeTypes
    /**
     * The channel subtype this message template applies to.
     */
    public val channelSubtype: aws.sdk.kotlin.services.qconnect.model.ChannelSubtype = requireNotNull(builder.channelSubtype) { "A non-null value must be provided for channelSubtype" }
    /**
     * The content of the message template.
     */
    public val content: aws.sdk.kotlin.services.qconnect.model.MessageTemplateContentProvider? = builder.content
    /**
     * The timestamp when the message template was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdTime) { "A non-null value must be provided for createdTime" }
    /**
     * An object that specifies the default values to use for variables in the message template. This object contains different categories of key-value pairs. Each key defines a variable or placeholder in the message template. The corresponding value defines the default value for that variable.
     */
    public val defaultAttributes: aws.sdk.kotlin.services.qconnect.model.MessageTemplateAttributes? = builder.defaultAttributes
    /**
     * The description of the message template.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The configuration information of the grouping of Amazon Q in Connect users.
     */
    public val groupingConfiguration: aws.sdk.kotlin.services.qconnect.model.GroupingConfiguration? = builder.groupingConfiguration
    /**
     * The Amazon Resource Name (ARN) of the knowledge base.
     */
    public val knowledgeBaseArn: kotlin.String = requireNotNull(builder.knowledgeBaseArn) { "A non-null value must be provided for knowledgeBaseArn" }
    /**
     * The identifier of the knowledge base.
     */
    public val knowledgeBaseId: kotlin.String = requireNotNull(builder.knowledgeBaseId) { "A non-null value must be provided for knowledgeBaseId" }
    /**
     * The language code value for the language in which the quick response is written. The supported language codes include `de_DE`, `en_US`, `es_ES`, `fr_FR`, `id_ID`, `it_IT`, `ja_JP`, `ko_KR`, `pt_BR`, `zh_CN`, `zh_TW`
     */
    public val language: kotlin.String? = builder.language
    /**
     * The Amazon Resource Name (ARN) of the user who last updated the message template data.
     */
    public val lastModifiedBy: kotlin.String = requireNotNull(builder.lastModifiedBy) { "A non-null value must be provided for lastModifiedBy" }
    /**
     * The timestamp when the message template data was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastModifiedTime) { "A non-null value must be provided for lastModifiedTime" }
    /**
     * The Amazon Resource Name (ARN) of the message template.
     */
    public val messageTemplateArn: kotlin.String = requireNotNull(builder.messageTemplateArn) { "A non-null value must be provided for messageTemplateArn" }
    /**
     * The checksum value of the message template content that is referenced by the `$LATEST` qualifier. It can be returned in `MessageTemplateData` or `ExtendedMessageTemplateData`. It’s calculated by content, language, `defaultAttributes` and `Attachments` of the message template.
     */
    public val messageTemplateContentSha256: kotlin.String = requireNotNull(builder.messageTemplateContentSha256) { "A non-null value must be provided for messageTemplateContentSha256" }
    /**
     * The identifier of the message template.
     */
    public val messageTemplateId: kotlin.String = requireNotNull(builder.messageTemplateId) { "A non-null value must be provided for messageTemplateId" }
    /**
     * The name of the message template.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.MessageTemplateData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MessageTemplateData(")
        append("attributeTypes=$attributeTypes,")
        append("channelSubtype=$channelSubtype,")
        append("content=$content,")
        append("createdTime=$createdTime,")
        append("defaultAttributes=$defaultAttributes,")
        append("description=$description,")
        append("groupingConfiguration=$groupingConfiguration,")
        append("knowledgeBaseArn=$knowledgeBaseArn,")
        append("knowledgeBaseId=$knowledgeBaseId,")
        append("language=$language,")
        append("lastModifiedBy=$lastModifiedBy,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("messageTemplateArn=$messageTemplateArn,")
        append("messageTemplateContentSha256=$messageTemplateContentSha256,")
        append("messageTemplateId=$messageTemplateId,")
        append("name=$name,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeTypes?.hashCode() ?: 0
        result = 31 * result + (channelSubtype.hashCode())
        result = 31 * result + (content?.hashCode() ?: 0)
        result = 31 * result + (createdTime.hashCode())
        result = 31 * result + (defaultAttributes?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (groupingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (knowledgeBaseArn.hashCode())
        result = 31 * result + (knowledgeBaseId.hashCode())
        result = 31 * result + (language?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedBy.hashCode())
        result = 31 * result + (lastModifiedTime.hashCode())
        result = 31 * result + (messageTemplateArn.hashCode())
        result = 31 * result + (messageTemplateContentSha256.hashCode())
        result = 31 * result + (messageTemplateId.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MessageTemplateData

        if (attributeTypes != other.attributeTypes) return false
        if (channelSubtype != other.channelSubtype) return false
        if (content != other.content) return false
        if (createdTime != other.createdTime) return false
        if (defaultAttributes != other.defaultAttributes) return false
        if (description != other.description) return false
        if (groupingConfiguration != other.groupingConfiguration) return false
        if (knowledgeBaseArn != other.knowledgeBaseArn) return false
        if (knowledgeBaseId != other.knowledgeBaseId) return false
        if (language != other.language) return false
        if (lastModifiedBy != other.lastModifiedBy) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (messageTemplateArn != other.messageTemplateArn) return false
        if (messageTemplateContentSha256 != other.messageTemplateContentSha256) return false
        if (messageTemplateId != other.messageTemplateId) return false
        if (name != other.name) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.MessageTemplateData = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The types of attributes that the message template contains.
         */
        public var attributeTypes: List<MessageTemplateAttributeType>? = null
        /**
         * The channel subtype this message template applies to.
         */
        public var channelSubtype: aws.sdk.kotlin.services.qconnect.model.ChannelSubtype? = null
        /**
         * The content of the message template.
         */
        public var content: aws.sdk.kotlin.services.qconnect.model.MessageTemplateContentProvider? = null
        /**
         * The timestamp when the message template was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An object that specifies the default values to use for variables in the message template. This object contains different categories of key-value pairs. Each key defines a variable or placeholder in the message template. The corresponding value defines the default value for that variable.
         */
        public var defaultAttributes: aws.sdk.kotlin.services.qconnect.model.MessageTemplateAttributes? = null
        /**
         * The description of the message template.
         */
        public var description: kotlin.String? = null
        /**
         * The configuration information of the grouping of Amazon Q in Connect users.
         */
        public var groupingConfiguration: aws.sdk.kotlin.services.qconnect.model.GroupingConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of the knowledge base.
         */
        public var knowledgeBaseArn: kotlin.String? = null
        /**
         * The identifier of the knowledge base.
         */
        public var knowledgeBaseId: kotlin.String? = null
        /**
         * The language code value for the language in which the quick response is written. The supported language codes include `de_DE`, `en_US`, `es_ES`, `fr_FR`, `id_ID`, `it_IT`, `ja_JP`, `ko_KR`, `pt_BR`, `zh_CN`, `zh_TW`
         */
        public var language: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the user who last updated the message template data.
         */
        public var lastModifiedBy: kotlin.String? = null
        /**
         * The timestamp when the message template data was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the message template.
         */
        public var messageTemplateArn: kotlin.String? = null
        /**
         * The checksum value of the message template content that is referenced by the `$LATEST` qualifier. It can be returned in `MessageTemplateData` or `ExtendedMessageTemplateData`. It’s calculated by content, language, `defaultAttributes` and `Attachments` of the message template.
         */
        public var messageTemplateContentSha256: kotlin.String? = null
        /**
         * The identifier of the message template.
         */
        public var messageTemplateId: kotlin.String? = null
        /**
         * The name of the message template.
         */
        public var name: kotlin.String? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.MessageTemplateData) : this() {
            this.attributeTypes = x.attributeTypes
            this.channelSubtype = x.channelSubtype
            this.content = x.content
            this.createdTime = x.createdTime
            this.defaultAttributes = x.defaultAttributes
            this.description = x.description
            this.groupingConfiguration = x.groupingConfiguration
            this.knowledgeBaseArn = x.knowledgeBaseArn
            this.knowledgeBaseId = x.knowledgeBaseId
            this.language = x.language
            this.lastModifiedBy = x.lastModifiedBy
            this.lastModifiedTime = x.lastModifiedTime
            this.messageTemplateArn = x.messageTemplateArn
            this.messageTemplateContentSha256 = x.messageTemplateContentSha256
            this.messageTemplateId = x.messageTemplateId
            this.name = x.name
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.MessageTemplateData = MessageTemplateData(this)

        /**
         * construct an [aws.sdk.kotlin.services.qconnect.model.MessageTemplateAttributes] inside the given [block]
         */
        public fun defaultAttributes(block: aws.sdk.kotlin.services.qconnect.model.MessageTemplateAttributes.Builder.() -> kotlin.Unit) {
            this.defaultAttributes = aws.sdk.kotlin.services.qconnect.model.MessageTemplateAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qconnect.model.GroupingConfiguration] inside the given [block]
         */
        public fun groupingConfiguration(block: aws.sdk.kotlin.services.qconnect.model.GroupingConfiguration.Builder.() -> kotlin.Unit) {
            this.groupingConfiguration = aws.sdk.kotlin.services.qconnect.model.GroupingConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (channelSubtype == null) channelSubtype = ChannelSubtype.SdkUnknown("no value provided")
            if (createdTime == null) createdTime = Instant.fromEpochSeconds(0)
            if (knowledgeBaseArn == null) knowledgeBaseArn = ""
            if (knowledgeBaseId == null) knowledgeBaseId = ""
            if (lastModifiedBy == null) lastModifiedBy = ""
            if (lastModifiedTime == null) lastModifiedTime = Instant.fromEpochSeconds(0)
            if (messageTemplateArn == null) messageTemplateArn = ""
            if (messageTemplateContentSha256 == null) messageTemplateContentSha256 = ""
            if (messageTemplateId == null) messageTemplateId = ""
            if (name == null) name = ""
            return this
        }
    }
}
