// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the message template attachment.
 */
public class MessageTemplateAttachment private constructor(builder: Builder) {
    /**
     * The identifier of the attachment file.
     */
    public val attachmentId: kotlin.String = requireNotNull(builder.attachmentId) { "A non-null value must be provided for attachmentId" }
    /**
     * The presentation information for the attachment file.
     */
    public val contentDisposition: aws.sdk.kotlin.services.qconnect.model.ContentDisposition = requireNotNull(builder.contentDisposition) { "A non-null value must be provided for contentDisposition" }
    /**
     * The name of the attachment file being uploaded. The name should include the file extension.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The timestamp when the attachment file was uploaded.
     */
    public val uploadedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.uploadedTime) { "A non-null value must be provided for uploadedTime" }
    /**
     * A pre-signed Amazon S3 URL that can be used to download the attachment file.
     */
    public val url: kotlin.String = requireNotNull(builder.url) { "A non-null value must be provided for url" }
    /**
     * The expiration time of the pre-signed Amazon S3 URL.
     */
    public val urlExpiry: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.urlExpiry) { "A non-null value must be provided for urlExpiry" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.MessageTemplateAttachment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MessageTemplateAttachment(")
        append("attachmentId=$attachmentId,")
        append("contentDisposition=$contentDisposition,")
        append("name=*** Sensitive Data Redacted ***,")
        append("uploadedTime=$uploadedTime,")
        append("url=*** Sensitive Data Redacted ***,")
        append("urlExpiry=$urlExpiry")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachmentId.hashCode()
        result = 31 * result + (contentDisposition.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (uploadedTime.hashCode())
        result = 31 * result + (url.hashCode())
        result = 31 * result + (urlExpiry.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MessageTemplateAttachment

        if (attachmentId != other.attachmentId) return false
        if (contentDisposition != other.contentDisposition) return false
        if (name != other.name) return false
        if (uploadedTime != other.uploadedTime) return false
        if (url != other.url) return false
        if (urlExpiry != other.urlExpiry) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.MessageTemplateAttachment = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the attachment file.
         */
        public var attachmentId: kotlin.String? = null
        /**
         * The presentation information for the attachment file.
         */
        public var contentDisposition: aws.sdk.kotlin.services.qconnect.model.ContentDisposition? = null
        /**
         * The name of the attachment file being uploaded. The name should include the file extension.
         */
        public var name: kotlin.String? = null
        /**
         * The timestamp when the attachment file was uploaded.
         */
        public var uploadedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A pre-signed Amazon S3 URL that can be used to download the attachment file.
         */
        public var url: kotlin.String? = null
        /**
         * The expiration time of the pre-signed Amazon S3 URL.
         */
        public var urlExpiry: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.MessageTemplateAttachment) : this() {
            this.attachmentId = x.attachmentId
            this.contentDisposition = x.contentDisposition
            this.name = x.name
            this.uploadedTime = x.uploadedTime
            this.url = x.url
            this.urlExpiry = x.urlExpiry
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.MessageTemplateAttachment = MessageTemplateAttachment(this)

        internal fun correctErrors(): Builder {
            if (attachmentId == null) attachmentId = ""
            if (contentDisposition == null) contentDisposition = ContentDisposition.SdkUnknown("no value provided")
            if (name == null) name = ""
            if (uploadedTime == null) uploadedTime = Instant.fromEpochSeconds(0)
            if (url == null) url = ""
            if (urlExpiry == null) urlExpiry = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
