// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Summary information about the knowledge base.
 */
public class KnowledgeBaseSummary private constructor(builder: Builder) {
    /**
     * The description of the knowledge base.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name (ARN) of the knowledge base.
     */
    public val knowledgeBaseArn: kotlin.String = requireNotNull(builder.knowledgeBaseArn) { "A non-null value must be provided for knowledgeBaseArn" }
    /**
     * The identifier of the knowledge base.
     */
    public val knowledgeBaseId: kotlin.String = requireNotNull(builder.knowledgeBaseId) { "A non-null value must be provided for knowledgeBaseId" }
    /**
     * The type of knowledge base.
     */
    public val knowledgeBaseType: aws.sdk.kotlin.services.qconnect.model.KnowledgeBaseType = requireNotNull(builder.knowledgeBaseType) { "A non-null value must be provided for knowledgeBaseType" }
    /**
     * The name of the knowledge base.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Information about how to render the content.
     */
    public val renderingConfiguration: aws.sdk.kotlin.services.qconnect.model.RenderingConfiguration? = builder.renderingConfiguration
    /**
     * The configuration information for the customer managed key used for encryption.
     *
     * This KMS key must have a policy that allows `kms:CreateGrant`, `kms:DescribeKey`, `kms:Decrypt`, and `kms:GenerateDataKey*` permissions to the IAM identity using the key to invoke Amazon Q in Connect.
     *
     * For more information about setting up a customer managed key for Amazon Q in Connect, see [Enable Amazon Q in Connect for your instance](https://docs.aws.amazon.com/connect/latest/adminguide/enable-q.html).
     */
    public val serverSideEncryptionConfiguration: aws.sdk.kotlin.services.qconnect.model.ServerSideEncryptionConfiguration? = builder.serverSideEncryptionConfiguration
    /**
     * Configuration information about the external data source.
     */
    public val sourceConfiguration: aws.sdk.kotlin.services.qconnect.model.SourceConfiguration? = builder.sourceConfiguration
    /**
     * The status of the knowledge base summary.
     */
    public val status: aws.sdk.kotlin.services.qconnect.model.KnowledgeBaseStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Contains details about how to ingest the documents in a data source.
     */
    public val vectorIngestionConfiguration: aws.sdk.kotlin.services.qconnect.model.VectorIngestionConfiguration? = builder.vectorIngestionConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.KnowledgeBaseSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KnowledgeBaseSummary(")
        append("description=$description,")
        append("knowledgeBaseArn=$knowledgeBaseArn,")
        append("knowledgeBaseId=$knowledgeBaseId,")
        append("knowledgeBaseType=$knowledgeBaseType,")
        append("name=$name,")
        append("renderingConfiguration=$renderingConfiguration,")
        append("serverSideEncryptionConfiguration=$serverSideEncryptionConfiguration,")
        append("sourceConfiguration=$sourceConfiguration,")
        append("status=$status,")
        append("tags=$tags,")
        append("vectorIngestionConfiguration=$vectorIngestionConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (knowledgeBaseArn.hashCode())
        result = 31 * result + (knowledgeBaseId.hashCode())
        result = 31 * result + (knowledgeBaseType.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (renderingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serverSideEncryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (sourceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vectorIngestionConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KnowledgeBaseSummary

        if (description != other.description) return false
        if (knowledgeBaseArn != other.knowledgeBaseArn) return false
        if (knowledgeBaseId != other.knowledgeBaseId) return false
        if (knowledgeBaseType != other.knowledgeBaseType) return false
        if (name != other.name) return false
        if (renderingConfiguration != other.renderingConfiguration) return false
        if (serverSideEncryptionConfiguration != other.serverSideEncryptionConfiguration) return false
        if (sourceConfiguration != other.sourceConfiguration) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (vectorIngestionConfiguration != other.vectorIngestionConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.KnowledgeBaseSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The description of the knowledge base.
         */
        public var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the knowledge base.
         */
        public var knowledgeBaseArn: kotlin.String? = null
        /**
         * The identifier of the knowledge base.
         */
        public var knowledgeBaseId: kotlin.String? = null
        /**
         * The type of knowledge base.
         */
        public var knowledgeBaseType: aws.sdk.kotlin.services.qconnect.model.KnowledgeBaseType? = null
        /**
         * The name of the knowledge base.
         */
        public var name: kotlin.String? = null
        /**
         * Information about how to render the content.
         */
        public var renderingConfiguration: aws.sdk.kotlin.services.qconnect.model.RenderingConfiguration? = null
        /**
         * The configuration information for the customer managed key used for encryption.
         *
         * This KMS key must have a policy that allows `kms:CreateGrant`, `kms:DescribeKey`, `kms:Decrypt`, and `kms:GenerateDataKey*` permissions to the IAM identity using the key to invoke Amazon Q in Connect.
         *
         * For more information about setting up a customer managed key for Amazon Q in Connect, see [Enable Amazon Q in Connect for your instance](https://docs.aws.amazon.com/connect/latest/adminguide/enable-q.html).
         */
        public var serverSideEncryptionConfiguration: aws.sdk.kotlin.services.qconnect.model.ServerSideEncryptionConfiguration? = null
        /**
         * Configuration information about the external data source.
         */
        public var sourceConfiguration: aws.sdk.kotlin.services.qconnect.model.SourceConfiguration? = null
        /**
         * The status of the knowledge base summary.
         */
        public var status: aws.sdk.kotlin.services.qconnect.model.KnowledgeBaseStatus? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * Contains details about how to ingest the documents in a data source.
         */
        public var vectorIngestionConfiguration: aws.sdk.kotlin.services.qconnect.model.VectorIngestionConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.KnowledgeBaseSummary) : this() {
            this.description = x.description
            this.knowledgeBaseArn = x.knowledgeBaseArn
            this.knowledgeBaseId = x.knowledgeBaseId
            this.knowledgeBaseType = x.knowledgeBaseType
            this.name = x.name
            this.renderingConfiguration = x.renderingConfiguration
            this.serverSideEncryptionConfiguration = x.serverSideEncryptionConfiguration
            this.sourceConfiguration = x.sourceConfiguration
            this.status = x.status
            this.tags = x.tags
            this.vectorIngestionConfiguration = x.vectorIngestionConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.KnowledgeBaseSummary = KnowledgeBaseSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.qconnect.model.RenderingConfiguration] inside the given [block]
         */
        public fun renderingConfiguration(block: aws.sdk.kotlin.services.qconnect.model.RenderingConfiguration.Builder.() -> kotlin.Unit) {
            this.renderingConfiguration = aws.sdk.kotlin.services.qconnect.model.RenderingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qconnect.model.ServerSideEncryptionConfiguration] inside the given [block]
         */
        public fun serverSideEncryptionConfiguration(block: aws.sdk.kotlin.services.qconnect.model.ServerSideEncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.serverSideEncryptionConfiguration = aws.sdk.kotlin.services.qconnect.model.ServerSideEncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qconnect.model.VectorIngestionConfiguration] inside the given [block]
         */
        public fun vectorIngestionConfiguration(block: aws.sdk.kotlin.services.qconnect.model.VectorIngestionConfiguration.Builder.() -> kotlin.Unit) {
            this.vectorIngestionConfiguration = aws.sdk.kotlin.services.qconnect.model.VectorIngestionConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (knowledgeBaseArn == null) knowledgeBaseArn = ""
            if (knowledgeBaseId == null) knowledgeBaseId = ""
            if (knowledgeBaseType == null) knowledgeBaseType = KnowledgeBaseType.SdkUnknown("no value provided")
            if (name == null) name = ""
            if (status == null) status = KnowledgeBaseStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
