// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the knowledge base.
 */
public class KnowledgeBaseData private constructor(builder: Builder) {
    /**
     * The description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * List of failure reasons on ingestion per file.
     */
    public val ingestionFailureReasons: List<String>? = builder.ingestionFailureReasons
    /**
     * Status of ingestion on data source.
     */
    public val ingestionStatus: aws.sdk.kotlin.services.qconnect.model.SyncStatus? = builder.ingestionStatus
    /**
     * The Amazon Resource Name (ARN) of the knowledge base.
     */
    public val knowledgeBaseArn: kotlin.String = requireNotNull(builder.knowledgeBaseArn) { "A non-null value must be provided for knowledgeBaseArn" }
    /**
     * The identifier of the knowledge base.
     */
    public val knowledgeBaseId: kotlin.String = requireNotNull(builder.knowledgeBaseId) { "A non-null value must be provided for knowledgeBaseId" }
    /**
     * The type of knowledge base.
     */
    public val knowledgeBaseType: aws.sdk.kotlin.services.qconnect.model.KnowledgeBaseType = requireNotNull(builder.knowledgeBaseType) { "A non-null value must be provided for knowledgeBaseType" }
    /**
     * An epoch timestamp indicating the most recent content modification inside the knowledge base. If no content exists in a knowledge base, this value is unset.
     */
    public val lastContentModificationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastContentModificationTime
    /**
     * The name of the knowledge base.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Information about how to render the content.
     */
    public val renderingConfiguration: aws.sdk.kotlin.services.qconnect.model.RenderingConfiguration? = builder.renderingConfiguration
    /**
     * The configuration information for the customer managed key used for encryption.
     *
     * This KMS key must have a policy that allows `kms:CreateGrant`, `kms:DescribeKey`, `kms:Decrypt`, and `kms:GenerateDataKey*` permissions to the IAM identity using the key to invoke Amazon Q in Connect.
     *
     * For more information about setting up a customer managed key for Amazon Q in Connect, see [Enable Amazon Q in Connect for your instance](https://docs.aws.amazon.com/connect/latest/adminguide/enable-q.html).
     */
    public val serverSideEncryptionConfiguration: aws.sdk.kotlin.services.qconnect.model.ServerSideEncryptionConfiguration? = builder.serverSideEncryptionConfiguration
    /**
     * Source configuration information about the knowledge base.
     */
    public val sourceConfiguration: aws.sdk.kotlin.services.qconnect.model.SourceConfiguration? = builder.sourceConfiguration
    /**
     * The status of the knowledge base.
     */
    public val status: aws.sdk.kotlin.services.qconnect.model.KnowledgeBaseStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Contains details about how to ingest the documents in a data source.
     */
    public val vectorIngestionConfiguration: aws.sdk.kotlin.services.qconnect.model.VectorIngestionConfiguration? = builder.vectorIngestionConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.KnowledgeBaseData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KnowledgeBaseData(")
        append("description=$description,")
        append("ingestionFailureReasons=$ingestionFailureReasons,")
        append("ingestionStatus=$ingestionStatus,")
        append("knowledgeBaseArn=$knowledgeBaseArn,")
        append("knowledgeBaseId=$knowledgeBaseId,")
        append("knowledgeBaseType=$knowledgeBaseType,")
        append("lastContentModificationTime=$lastContentModificationTime,")
        append("name=$name,")
        append("renderingConfiguration=$renderingConfiguration,")
        append("serverSideEncryptionConfiguration=$serverSideEncryptionConfiguration,")
        append("sourceConfiguration=$sourceConfiguration,")
        append("status=$status,")
        append("tags=$tags,")
        append("vectorIngestionConfiguration=$vectorIngestionConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (ingestionFailureReasons?.hashCode() ?: 0)
        result = 31 * result + (ingestionStatus?.hashCode() ?: 0)
        result = 31 * result + (knowledgeBaseArn.hashCode())
        result = 31 * result + (knowledgeBaseId.hashCode())
        result = 31 * result + (knowledgeBaseType.hashCode())
        result = 31 * result + (lastContentModificationTime?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (renderingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serverSideEncryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (sourceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vectorIngestionConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KnowledgeBaseData

        if (description != other.description) return false
        if (ingestionFailureReasons != other.ingestionFailureReasons) return false
        if (ingestionStatus != other.ingestionStatus) return false
        if (knowledgeBaseArn != other.knowledgeBaseArn) return false
        if (knowledgeBaseId != other.knowledgeBaseId) return false
        if (knowledgeBaseType != other.knowledgeBaseType) return false
        if (lastContentModificationTime != other.lastContentModificationTime) return false
        if (name != other.name) return false
        if (renderingConfiguration != other.renderingConfiguration) return false
        if (serverSideEncryptionConfiguration != other.serverSideEncryptionConfiguration) return false
        if (sourceConfiguration != other.sourceConfiguration) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (vectorIngestionConfiguration != other.vectorIngestionConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.KnowledgeBaseData = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The description.
         */
        public var description: kotlin.String? = null
        /**
         * List of failure reasons on ingestion per file.
         */
        public var ingestionFailureReasons: List<String>? = null
        /**
         * Status of ingestion on data source.
         */
        public var ingestionStatus: aws.sdk.kotlin.services.qconnect.model.SyncStatus? = null
        /**
         * The Amazon Resource Name (ARN) of the knowledge base.
         */
        public var knowledgeBaseArn: kotlin.String? = null
        /**
         * The identifier of the knowledge base.
         */
        public var knowledgeBaseId: kotlin.String? = null
        /**
         * The type of knowledge base.
         */
        public var knowledgeBaseType: aws.sdk.kotlin.services.qconnect.model.KnowledgeBaseType? = null
        /**
         * An epoch timestamp indicating the most recent content modification inside the knowledge base. If no content exists in a knowledge base, this value is unset.
         */
        public var lastContentModificationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the knowledge base.
         */
        public var name: kotlin.String? = null
        /**
         * Information about how to render the content.
         */
        public var renderingConfiguration: aws.sdk.kotlin.services.qconnect.model.RenderingConfiguration? = null
        /**
         * The configuration information for the customer managed key used for encryption.
         *
         * This KMS key must have a policy that allows `kms:CreateGrant`, `kms:DescribeKey`, `kms:Decrypt`, and `kms:GenerateDataKey*` permissions to the IAM identity using the key to invoke Amazon Q in Connect.
         *
         * For more information about setting up a customer managed key for Amazon Q in Connect, see [Enable Amazon Q in Connect for your instance](https://docs.aws.amazon.com/connect/latest/adminguide/enable-q.html).
         */
        public var serverSideEncryptionConfiguration: aws.sdk.kotlin.services.qconnect.model.ServerSideEncryptionConfiguration? = null
        /**
         * Source configuration information about the knowledge base.
         */
        public var sourceConfiguration: aws.sdk.kotlin.services.qconnect.model.SourceConfiguration? = null
        /**
         * The status of the knowledge base.
         */
        public var status: aws.sdk.kotlin.services.qconnect.model.KnowledgeBaseStatus? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * Contains details about how to ingest the documents in a data source.
         */
        public var vectorIngestionConfiguration: aws.sdk.kotlin.services.qconnect.model.VectorIngestionConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.KnowledgeBaseData) : this() {
            this.description = x.description
            this.ingestionFailureReasons = x.ingestionFailureReasons
            this.ingestionStatus = x.ingestionStatus
            this.knowledgeBaseArn = x.knowledgeBaseArn
            this.knowledgeBaseId = x.knowledgeBaseId
            this.knowledgeBaseType = x.knowledgeBaseType
            this.lastContentModificationTime = x.lastContentModificationTime
            this.name = x.name
            this.renderingConfiguration = x.renderingConfiguration
            this.serverSideEncryptionConfiguration = x.serverSideEncryptionConfiguration
            this.sourceConfiguration = x.sourceConfiguration
            this.status = x.status
            this.tags = x.tags
            this.vectorIngestionConfiguration = x.vectorIngestionConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.KnowledgeBaseData = KnowledgeBaseData(this)

        /**
         * construct an [aws.sdk.kotlin.services.qconnect.model.RenderingConfiguration] inside the given [block]
         */
        public fun renderingConfiguration(block: aws.sdk.kotlin.services.qconnect.model.RenderingConfiguration.Builder.() -> kotlin.Unit) {
            this.renderingConfiguration = aws.sdk.kotlin.services.qconnect.model.RenderingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qconnect.model.ServerSideEncryptionConfiguration] inside the given [block]
         */
        public fun serverSideEncryptionConfiguration(block: aws.sdk.kotlin.services.qconnect.model.ServerSideEncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.serverSideEncryptionConfiguration = aws.sdk.kotlin.services.qconnect.model.ServerSideEncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qconnect.model.VectorIngestionConfiguration] inside the given [block]
         */
        public fun vectorIngestionConfiguration(block: aws.sdk.kotlin.services.qconnect.model.VectorIngestionConfiguration.Builder.() -> kotlin.Unit) {
            this.vectorIngestionConfiguration = aws.sdk.kotlin.services.qconnect.model.VectorIngestionConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (knowledgeBaseArn == null) knowledgeBaseArn = ""
            if (knowledgeBaseId == null) knowledgeBaseId = ""
            if (knowledgeBaseType == null) knowledgeBaseType = KnowledgeBaseType.SdkUnknown("no value provided")
            if (name == null) name = ""
            if (status == null) status = KnowledgeBaseStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
