// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary information about the import job.
 */
public class ImportJobData private constructor(builder: Builder) {
    /**
     * The timestamp when the import job was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdTime) { "A non-null value must be provided for createdTime" }
    /**
     * The configuration information of the external data source.
     */
    public val externalSourceConfiguration: aws.sdk.kotlin.services.qconnect.model.ExternalSourceConfiguration? = builder.externalSourceConfiguration
    /**
     * The link to download the information of resource data that failed to be imported.
     */
    public val failedRecordReport: kotlin.String? = builder.failedRecordReport
    /**
     * The identifier of the import job.
     */
    public val importJobId: kotlin.String = requireNotNull(builder.importJobId) { "A non-null value must be provided for importJobId" }
    /**
     * The type of the import job.
     */
    public val importJobType: aws.sdk.kotlin.services.qconnect.model.ImportJobType = requireNotNull(builder.importJobType) { "A non-null value must be provided for importJobType" }
    /**
     * The Amazon Resource Name (ARN) of the knowledge base.
     */
    public val knowledgeBaseArn: kotlin.String = requireNotNull(builder.knowledgeBaseArn) { "A non-null value must be provided for knowledgeBaseArn" }
    /**
     * The identifier of the knowledge base.
     */
    public val knowledgeBaseId: kotlin.String = requireNotNull(builder.knowledgeBaseId) { "A non-null value must be provided for knowledgeBaseId" }
    /**
     * The timestamp when the import job data was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastModifiedTime) { "A non-null value must be provided for lastModifiedTime" }
    /**
     * The metadata fields of the imported Amazon Q in Connect resources.
     */
    public val metadata: Map<String, String>? = builder.metadata
    /**
     * The status of the import job.
     */
    public val status: aws.sdk.kotlin.services.qconnect.model.ImportJobStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * A pointer to the uploaded asset. This value is returned by [StartContentUpload](https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html).
     */
    public val uploadId: kotlin.String = requireNotNull(builder.uploadId) { "A non-null value must be provided for uploadId" }
    /**
     * The download link to the resource file that is uploaded to the import job.
     */
    public val url: kotlin.String = requireNotNull(builder.url) { "A non-null value must be provided for url" }
    /**
     * The expiration time of the URL as an epoch timestamp.
     */
    public val urlExpiry: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.urlExpiry) { "A non-null value must be provided for urlExpiry" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.ImportJobData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportJobData(")
        append("createdTime=$createdTime,")
        append("externalSourceConfiguration=$externalSourceConfiguration,")
        append("failedRecordReport=*** Sensitive Data Redacted ***,")
        append("importJobId=$importJobId,")
        append("importJobType=$importJobType,")
        append("knowledgeBaseArn=$knowledgeBaseArn,")
        append("knowledgeBaseId=$knowledgeBaseId,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("metadata=$metadata,")
        append("status=$status,")
        append("uploadId=$uploadId,")
        append("url=*** Sensitive Data Redacted ***,")
        append("urlExpiry=$urlExpiry")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdTime.hashCode()
        result = 31 * result + (externalSourceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (failedRecordReport?.hashCode() ?: 0)
        result = 31 * result + (importJobId.hashCode())
        result = 31 * result + (importJobType.hashCode())
        result = 31 * result + (knowledgeBaseArn.hashCode())
        result = 31 * result + (knowledgeBaseId.hashCode())
        result = 31 * result + (lastModifiedTime.hashCode())
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (uploadId.hashCode())
        result = 31 * result + (url.hashCode())
        result = 31 * result + (urlExpiry.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportJobData

        if (createdTime != other.createdTime) return false
        if (externalSourceConfiguration != other.externalSourceConfiguration) return false
        if (failedRecordReport != other.failedRecordReport) return false
        if (importJobId != other.importJobId) return false
        if (importJobType != other.importJobType) return false
        if (knowledgeBaseArn != other.knowledgeBaseArn) return false
        if (knowledgeBaseId != other.knowledgeBaseId) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (metadata != other.metadata) return false
        if (status != other.status) return false
        if (uploadId != other.uploadId) return false
        if (url != other.url) return false
        if (urlExpiry != other.urlExpiry) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.ImportJobData = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp when the import job was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The configuration information of the external data source.
         */
        public var externalSourceConfiguration: aws.sdk.kotlin.services.qconnect.model.ExternalSourceConfiguration? = null
        /**
         * The link to download the information of resource data that failed to be imported.
         */
        public var failedRecordReport: kotlin.String? = null
        /**
         * The identifier of the import job.
         */
        public var importJobId: kotlin.String? = null
        /**
         * The type of the import job.
         */
        public var importJobType: aws.sdk.kotlin.services.qconnect.model.ImportJobType? = null
        /**
         * The Amazon Resource Name (ARN) of the knowledge base.
         */
        public var knowledgeBaseArn: kotlin.String? = null
        /**
         * The identifier of the knowledge base.
         */
        public var knowledgeBaseId: kotlin.String? = null
        /**
         * The timestamp when the import job data was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The metadata fields of the imported Amazon Q in Connect resources.
         */
        public var metadata: Map<String, String>? = null
        /**
         * The status of the import job.
         */
        public var status: aws.sdk.kotlin.services.qconnect.model.ImportJobStatus? = null
        /**
         * A pointer to the uploaded asset. This value is returned by [StartContentUpload](https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html).
         */
        public var uploadId: kotlin.String? = null
        /**
         * The download link to the resource file that is uploaded to the import job.
         */
        public var url: kotlin.String? = null
        /**
         * The expiration time of the URL as an epoch timestamp.
         */
        public var urlExpiry: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.ImportJobData) : this() {
            this.createdTime = x.createdTime
            this.externalSourceConfiguration = x.externalSourceConfiguration
            this.failedRecordReport = x.failedRecordReport
            this.importJobId = x.importJobId
            this.importJobType = x.importJobType
            this.knowledgeBaseArn = x.knowledgeBaseArn
            this.knowledgeBaseId = x.knowledgeBaseId
            this.lastModifiedTime = x.lastModifiedTime
            this.metadata = x.metadata
            this.status = x.status
            this.uploadId = x.uploadId
            this.url = x.url
            this.urlExpiry = x.urlExpiry
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.ImportJobData = ImportJobData(this)

        /**
         * construct an [aws.sdk.kotlin.services.qconnect.model.ExternalSourceConfiguration] inside the given [block]
         */
        public fun externalSourceConfiguration(block: aws.sdk.kotlin.services.qconnect.model.ExternalSourceConfiguration.Builder.() -> kotlin.Unit) {
            this.externalSourceConfiguration = aws.sdk.kotlin.services.qconnect.model.ExternalSourceConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdTime == null) createdTime = Instant.fromEpochSeconds(0)
            if (importJobId == null) importJobId = ""
            if (importJobType == null) importJobType = ImportJobType.SdkUnknown("no value provided")
            if (knowledgeBaseArn == null) knowledgeBaseArn = ""
            if (knowledgeBaseId == null) knowledgeBaseId = ""
            if (lastModifiedTime == null) lastModifiedTime = Instant.fromEpochSeconds(0)
            if (status == null) status = ImportJobStatus.SdkUnknown("no value provided")
            if (uploadId == null) uploadId = ""
            if (url == null) url = ""
            if (urlExpiry == null) urlExpiry = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
