// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains filter strengths for harmful content. AI Guardrail's support the following content filters to detect and filter harmful user inputs and FM-generated outputs.
 * + **Hate**: Describes input prompts and model responses that discriminate, criticize, insult, denounce, or dehumanize a person or group on the basis of an identity (such as race, ethnicity, gender, religion, sexual orientation, ability, and national origin).
 * + **Insults**: Describes input prompts and model responses that includes demeaning, humiliating, mocking, insulting, or belittling language. This type of language is also labeled as bullying.
 * + **Sexual**: Describes input prompts and model responses that indicates sexual interest, activity, or arousal using direct or indirect references to body parts, physical traits, or sex.
 * + **Violence**: Describes input prompts and model responses that includes glorification of, or threats to inflict physical pain, hurt, or injury toward a person, group, or thing.
 *
 * Content filtering depends on the confidence classification of user inputs and FM responses across each of the four harmful categories. All input and output statements are classified into one of four confidence levels (NONE, LOW, MEDIUM, HIGH) for each harmful category. For example, if a statement is classified as *Hate* with HIGH confidence, the likelihood of the statement representing hateful content is high. A single statement can be classified across multiple categories with varying confidence levels. For example, a single statement can be classified as *Hate* with HIGH confidence, * Insults* with LOW confidence, *Sexual* with NONE confidence, and *Violence* with MEDIUM confidence.
 */
public class GuardrailContentFilterConfig private constructor(builder: Builder) {
    /**
     * The strength of the content filter to apply to prompts. As you increase the filter strength, the likelihood of filtering harmful content increases and the probability of seeing harmful content in your application reduces.
     */
    public val inputStrength: aws.sdk.kotlin.services.qconnect.model.GuardrailFilterStrength = requireNotNull(builder.inputStrength) { "A non-null value must be provided for inputStrength" }
    /**
     * The strength of the content filter to apply to model responses. As you increase the filter strength, the likelihood of filtering harmful content increases and the probability of seeing harmful content in your application reduces.
     */
    public val outputStrength: aws.sdk.kotlin.services.qconnect.model.GuardrailFilterStrength = requireNotNull(builder.outputStrength) { "A non-null value must be provided for outputStrength" }
    /**
     * The harmful category that the content filter is applied to.
     */
    public val type: aws.sdk.kotlin.services.qconnect.model.GuardrailContentFilterType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.GuardrailContentFilterConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GuardrailContentFilterConfig(")
        append("inputStrength=*** Sensitive Data Redacted ***,")
        append("outputStrength=*** Sensitive Data Redacted ***,")
        append("type=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = inputStrength.hashCode()
        result = 31 * result + (outputStrength.hashCode())
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GuardrailContentFilterConfig

        if (inputStrength != other.inputStrength) return false
        if (outputStrength != other.outputStrength) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.GuardrailContentFilterConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The strength of the content filter to apply to prompts. As you increase the filter strength, the likelihood of filtering harmful content increases and the probability of seeing harmful content in your application reduces.
         */
        public var inputStrength: aws.sdk.kotlin.services.qconnect.model.GuardrailFilterStrength? = null
        /**
         * The strength of the content filter to apply to model responses. As you increase the filter strength, the likelihood of filtering harmful content increases and the probability of seeing harmful content in your application reduces.
         */
        public var outputStrength: aws.sdk.kotlin.services.qconnect.model.GuardrailFilterStrength? = null
        /**
         * The harmful category that the content filter is applied to.
         */
        public var type: aws.sdk.kotlin.services.qconnect.model.GuardrailContentFilterType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.GuardrailContentFilterConfig) : this() {
            this.inputStrength = x.inputStrength
            this.outputStrength = x.outputStrength
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.GuardrailContentFilterConfig = GuardrailContentFilterConfig(this)

        internal fun correctErrors(): Builder {
            if (inputStrength == null) inputStrength = GuardrailFilterStrength.SdkUnknown("no value provided")
            if (outputStrength == null) outputStrength = GuardrailFilterStrength.SdkUnknown("no value provided")
            if (type == null) type = GuardrailContentFilterType.SdkUnknown("no value provided")
            return this
        }
    }
}
