// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration information of the grouping of Amazon Q in Connect users.
 */
public class GroupingConfiguration private constructor(builder: Builder) {
    /**
     * The criteria used for grouping Amazon Q in Connect users.
     *
     * The following is the list of supported criteria values.
     * + `RoutingProfileArn`: Grouping the users by their [Amazon Connect routing profile ARN](https://docs.aws.amazon.com/connect/latest/APIReference/API_RoutingProfile.html). User should have [SearchRoutingProfile](https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchRoutingProfiles.html) and [DescribeRoutingProfile](https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeRoutingProfile.html) permissions when setting criteria to this value.
     */
    public val criteria: kotlin.String? = builder.criteria
    /**
     * The list of values that define different groups of Amazon Q in Connect users.
     * + When setting `criteria` to `RoutingProfileArn`, you need to provide a list of ARNs of [Amazon Connect routing profiles](https://docs.aws.amazon.com/connect/latest/APIReference/API_RoutingProfile.html) as values of this parameter.
     */
    public val values: List<String>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.GroupingConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GroupingConfiguration(")
        append("criteria=*** Sensitive Data Redacted ***,")
        append("values=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = criteria?.hashCode() ?: 0
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GroupingConfiguration

        if (criteria != other.criteria) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.GroupingConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The criteria used for grouping Amazon Q in Connect users.
         *
         * The following is the list of supported criteria values.
         * + `RoutingProfileArn`: Grouping the users by their [Amazon Connect routing profile ARN](https://docs.aws.amazon.com/connect/latest/APIReference/API_RoutingProfile.html). User should have [SearchRoutingProfile](https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchRoutingProfiles.html) and [DescribeRoutingProfile](https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeRoutingProfile.html) permissions when setting criteria to this value.
         */
        public var criteria: kotlin.String? = null
        /**
         * The list of values that define different groups of Amazon Q in Connect users.
         * + When setting `criteria` to `RoutingProfileArn`, you need to provide a list of ARNs of [Amazon Connect routing profiles](https://docs.aws.amazon.com/connect/latest/APIReference/API_RoutingProfile.html) as values of this parameter.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.GroupingConfiguration) : this() {
            this.criteria = x.criteria
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.GroupingConfiguration = GroupingConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
