// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetRecommendationsRequest private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    public val assistantId: kotlin.String = requireNotNull(builder.assistantId) { "A non-null value must be provided for assistantId" }
    /**
     * The maximum number of results to return per page.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token for the next set of chunks. Use the value returned in the previous response in the next request to retrieve the next set of chunks.
     */
    public val nextChunkToken: kotlin.String? = builder.nextChunkToken
    /**
     * The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    public val sessionId: kotlin.String = requireNotNull(builder.sessionId) { "A non-null value must be provided for sessionId" }
    /**
     * The duration (in seconds) for which the call waits for a recommendation to be made available before returning. If a recommendation is available, the call returns sooner than `WaitTimeSeconds`. If no messages are available and the wait time expires, the call returns successfully with an empty list.
     */
    public val waitTimeSeconds: kotlin.Int = builder.waitTimeSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.GetRecommendationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetRecommendationsRequest(")
        append("assistantId=$assistantId,")
        append("maxResults=$maxResults,")
        append("nextChunkToken=$nextChunkToken,")
        append("sessionId=$sessionId,")
        append("waitTimeSeconds=$waitTimeSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assistantId.hashCode()
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextChunkToken?.hashCode() ?: 0)
        result = 31 * result + (sessionId.hashCode())
        result = 31 * result + (waitTimeSeconds)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetRecommendationsRequest

        if (assistantId != other.assistantId) return false
        if (maxResults != other.maxResults) return false
        if (nextChunkToken != other.nextChunkToken) return false
        if (sessionId != other.sessionId) return false
        if (waitTimeSeconds != other.waitTimeSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.GetRecommendationsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
         */
        public var assistantId: kotlin.String? = null
        /**
         * The maximum number of results to return per page.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token for the next set of chunks. Use the value returned in the previous response in the next request to retrieve the next set of chunks.
         */
        public var nextChunkToken: kotlin.String? = null
        /**
         * The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.
         */
        public var sessionId: kotlin.String? = null
        /**
         * The duration (in seconds) for which the call waits for a recommendation to be made available before returning. If a recommendation is available, the call returns sooner than `WaitTimeSeconds`. If no messages are available and the wait time expires, the call returns successfully with an empty list.
         */
        public var waitTimeSeconds: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.GetRecommendationsRequest) : this() {
            this.assistantId = x.assistantId
            this.maxResults = x.maxResults
            this.nextChunkToken = x.nextChunkToken
            this.sessionId = x.sessionId
            this.waitTimeSeconds = x.waitTimeSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.GetRecommendationsRequest = GetRecommendationsRequest(this)

        internal fun correctErrors(): Builder {
            if (assistantId == null) assistantId = ""
            if (sessionId == null) sessionId = ""
            return this
        }
    }
}
