// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateSessionRequest private constructor(builder: Builder) {
    /**
     * The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used by Amazon Q in Connect for this Session.
     */
    public val aiAgentConfiguration: Map<AiAgentType, AiAgentConfigurationData>? = builder.aiAgentConfiguration
    /**
     * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    public val assistantId: kotlin.String = requireNotNull(builder.assistantId) { "A non-null value must be provided for assistantId" }
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the session.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * An object that can be used to specify Tag conditions.
     */
    public val tagFilter: aws.sdk.kotlin.services.qconnect.model.TagFilter? = builder.tagFilter
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.CreateSessionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSessionRequest(")
        append("aiAgentConfiguration=$aiAgentConfiguration,")
        append("assistantId=$assistantId,")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("name=$name,")
        append("tagFilter=$tagFilter,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aiAgentConfiguration?.hashCode() ?: 0
        result = 31 * result + (assistantId.hashCode())
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (tagFilter?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSessionRequest

        if (aiAgentConfiguration != other.aiAgentConfiguration) return false
        if (assistantId != other.assistantId) return false
        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (tagFilter != other.tagFilter) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.CreateSessionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used by Amazon Q in Connect for this Session.
         */
        public var aiAgentConfiguration: Map<AiAgentType, AiAgentConfigurationData>? = null
        /**
         * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
         */
        public var assistantId: kotlin.String? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
         */
        public var clientToken: kotlin.String? = null
        /**
         * The description.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the session.
         */
        public var name: kotlin.String? = null
        /**
         * An object that can be used to specify Tag conditions.
         */
        public var tagFilter: aws.sdk.kotlin.services.qconnect.model.TagFilter? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.CreateSessionRequest) : this() {
            this.aiAgentConfiguration = x.aiAgentConfiguration
            this.assistantId = x.assistantId
            this.clientToken = x.clientToken
            this.description = x.description
            this.name = x.name
            this.tagFilter = x.tagFilter
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.CreateSessionRequest = CreateSessionRequest(this)

        internal fun correctErrors(): Builder {
            if (assistantId == null) assistantId = ""
            if (name == null) name = ""
            return this
        }
    }
}
