// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateQuickResponseRequest private constructor(builder: Builder) {
    /**
     * The Amazon Connect channels this quick response applies to.
     */
    public val channels: List<String>? = builder.channels
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The content of the quick response.
     */
    public val content: aws.sdk.kotlin.services.qconnect.model.QuickResponseDataProvider? = builder.content
    /**
     * The media type of the quick response content.
     * + Use `application/x.quickresponse;format=plain` for a quick response written in plain text.
     * + Use `application/x.quickresponse;format=markdown` for a quick response written in richtext.
     */
    public val contentType: kotlin.String? = builder.contentType
    /**
     * The description of the quick response.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The configuration information of the user groups that the quick response is accessible to.
     */
    public val groupingConfiguration: aws.sdk.kotlin.services.qconnect.model.GroupingConfiguration? = builder.groupingConfiguration
    /**
     * Whether the quick response is active.
     */
    public val isActive: kotlin.Boolean? = builder.isActive
    /**
     * The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    public val knowledgeBaseId: kotlin.String? = builder.knowledgeBaseId
    /**
     * The language code value for the language in which the quick response is written. The supported language codes include `de_DE`, `en_US`, `es_ES`, `fr_FR`, `id_ID`, `it_IT`, `ja_JP`, `ko_KR`, `pt_BR`, `zh_CN`, `zh_TW`
     */
    public val language: kotlin.String? = builder.language
    /**
     * The name of the quick response.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The shortcut key of the quick response. The value should be unique across the knowledge base.
     */
    public val shortcutKey: kotlin.String? = builder.shortcutKey
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.CreateQuickResponseRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateQuickResponseRequest(")
        append("channels=*** Sensitive Data Redacted ***,")
        append("clientToken=$clientToken,")
        append("content=$content,")
        append("contentType=$contentType,")
        append("description=$description,")
        append("groupingConfiguration=$groupingConfiguration,")
        append("isActive=$isActive,")
        append("knowledgeBaseId=$knowledgeBaseId,")
        append("language=$language,")
        append("name=$name,")
        append("shortcutKey=$shortcutKey,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = channels?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (content?.hashCode() ?: 0)
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (groupingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (isActive?.hashCode() ?: 0)
        result = 31 * result + (knowledgeBaseId?.hashCode() ?: 0)
        result = 31 * result + (language?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (shortcutKey?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateQuickResponseRequest

        if (channels != other.channels) return false
        if (clientToken != other.clientToken) return false
        if (content != other.content) return false
        if (contentType != other.contentType) return false
        if (description != other.description) return false
        if (groupingConfiguration != other.groupingConfiguration) return false
        if (isActive != other.isActive) return false
        if (knowledgeBaseId != other.knowledgeBaseId) return false
        if (language != other.language) return false
        if (name != other.name) return false
        if (shortcutKey != other.shortcutKey) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.CreateQuickResponseRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Connect channels this quick response applies to.
         */
        public var channels: List<String>? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
         */
        public var clientToken: kotlin.String? = null
        /**
         * The content of the quick response.
         */
        public var content: aws.sdk.kotlin.services.qconnect.model.QuickResponseDataProvider? = null
        /**
         * The media type of the quick response content.
         * + Use `application/x.quickresponse;format=plain` for a quick response written in plain text.
         * + Use `application/x.quickresponse;format=markdown` for a quick response written in richtext.
         */
        public var contentType: kotlin.String? = null
        /**
         * The description of the quick response.
         */
        public var description: kotlin.String? = null
        /**
         * The configuration information of the user groups that the quick response is accessible to.
         */
        public var groupingConfiguration: aws.sdk.kotlin.services.qconnect.model.GroupingConfiguration? = null
        /**
         * Whether the quick response is active.
         */
        public var isActive: kotlin.Boolean? = null
        /**
         * The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
         */
        public var knowledgeBaseId: kotlin.String? = null
        /**
         * The language code value for the language in which the quick response is written. The supported language codes include `de_DE`, `en_US`, `es_ES`, `fr_FR`, `id_ID`, `it_IT`, `ja_JP`, `ko_KR`, `pt_BR`, `zh_CN`, `zh_TW`
         */
        public var language: kotlin.String? = null
        /**
         * The name of the quick response.
         */
        public var name: kotlin.String? = null
        /**
         * The shortcut key of the quick response. The value should be unique across the knowledge base.
         */
        public var shortcutKey: kotlin.String? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.CreateQuickResponseRequest) : this() {
            this.channels = x.channels
            this.clientToken = x.clientToken
            this.content = x.content
            this.contentType = x.contentType
            this.description = x.description
            this.groupingConfiguration = x.groupingConfiguration
            this.isActive = x.isActive
            this.knowledgeBaseId = x.knowledgeBaseId
            this.language = x.language
            this.name = x.name
            this.shortcutKey = x.shortcutKey
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.CreateQuickResponseRequest = CreateQuickResponseRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.qconnect.model.GroupingConfiguration] inside the given [block]
         */
        public fun groupingConfiguration(block: aws.sdk.kotlin.services.qconnect.model.GroupingConfiguration.Builder.() -> kotlin.Unit) {
            this.groupingConfiguration = aws.sdk.kotlin.services.qconnect.model.GroupingConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
