// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateKnowledgeBaseRequest private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The type of knowledge base. Only CUSTOM knowledge bases allow you to upload your own content. EXTERNAL knowledge bases support integrations with third-party systems whose content is synchronized automatically.
     */
    public val knowledgeBaseType: aws.sdk.kotlin.services.qconnect.model.KnowledgeBaseType = requireNotNull(builder.knowledgeBaseType) { "A non-null value must be provided for knowledgeBaseType" }
    /**
     * The name of the knowledge base.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Information about how to render the content.
     */
    public val renderingConfiguration: aws.sdk.kotlin.services.qconnect.model.RenderingConfiguration? = builder.renderingConfiguration
    /**
     * The configuration information for the customer managed key used for encryption.
     *
     * This KMS key must have a policy that allows `kms:CreateGrant`, `kms:DescribeKey`, `kms:Decrypt`, and `kms:GenerateDataKey*` permissions to the IAM identity using the key to invoke Amazon Q in Connect.
     *
     * For more information about setting up a customer managed key for Amazon Q in Connect, see [Enable Amazon Q in Connect for your instance](https://docs.aws.amazon.com/connect/latest/adminguide/enable-q.html).
     */
    public val serverSideEncryptionConfiguration: aws.sdk.kotlin.services.qconnect.model.ServerSideEncryptionConfiguration? = builder.serverSideEncryptionConfiguration
    /**
     * The source of the knowledge base content. Only set this argument for EXTERNAL or Managed knowledge bases.
     */
    public val sourceConfiguration: aws.sdk.kotlin.services.qconnect.model.SourceConfiguration? = builder.sourceConfiguration
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Contains details about how to ingest the documents in a data source.
     */
    public val vectorIngestionConfiguration: aws.sdk.kotlin.services.qconnect.model.VectorIngestionConfiguration? = builder.vectorIngestionConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.CreateKnowledgeBaseRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateKnowledgeBaseRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("knowledgeBaseType=$knowledgeBaseType,")
        append("name=$name,")
        append("renderingConfiguration=$renderingConfiguration,")
        append("serverSideEncryptionConfiguration=$serverSideEncryptionConfiguration,")
        append("sourceConfiguration=$sourceConfiguration,")
        append("tags=$tags,")
        append("vectorIngestionConfiguration=$vectorIngestionConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (knowledgeBaseType.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (renderingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serverSideEncryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (sourceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vectorIngestionConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateKnowledgeBaseRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (knowledgeBaseType != other.knowledgeBaseType) return false
        if (name != other.name) return false
        if (renderingConfiguration != other.renderingConfiguration) return false
        if (serverSideEncryptionConfiguration != other.serverSideEncryptionConfiguration) return false
        if (sourceConfiguration != other.sourceConfiguration) return false
        if (tags != other.tags) return false
        if (vectorIngestionConfiguration != other.vectorIngestionConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.CreateKnowledgeBaseRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
         */
        public var clientToken: kotlin.String? = null
        /**
         * The description.
         */
        public var description: kotlin.String? = null
        /**
         * The type of knowledge base. Only CUSTOM knowledge bases allow you to upload your own content. EXTERNAL knowledge bases support integrations with third-party systems whose content is synchronized automatically.
         */
        public var knowledgeBaseType: aws.sdk.kotlin.services.qconnect.model.KnowledgeBaseType? = null
        /**
         * The name of the knowledge base.
         */
        public var name: kotlin.String? = null
        /**
         * Information about how to render the content.
         */
        public var renderingConfiguration: aws.sdk.kotlin.services.qconnect.model.RenderingConfiguration? = null
        /**
         * The configuration information for the customer managed key used for encryption.
         *
         * This KMS key must have a policy that allows `kms:CreateGrant`, `kms:DescribeKey`, `kms:Decrypt`, and `kms:GenerateDataKey*` permissions to the IAM identity using the key to invoke Amazon Q in Connect.
         *
         * For more information about setting up a customer managed key for Amazon Q in Connect, see [Enable Amazon Q in Connect for your instance](https://docs.aws.amazon.com/connect/latest/adminguide/enable-q.html).
         */
        public var serverSideEncryptionConfiguration: aws.sdk.kotlin.services.qconnect.model.ServerSideEncryptionConfiguration? = null
        /**
         * The source of the knowledge base content. Only set this argument for EXTERNAL or Managed knowledge bases.
         */
        public var sourceConfiguration: aws.sdk.kotlin.services.qconnect.model.SourceConfiguration? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * Contains details about how to ingest the documents in a data source.
         */
        public var vectorIngestionConfiguration: aws.sdk.kotlin.services.qconnect.model.VectorIngestionConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.CreateKnowledgeBaseRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.knowledgeBaseType = x.knowledgeBaseType
            this.name = x.name
            this.renderingConfiguration = x.renderingConfiguration
            this.serverSideEncryptionConfiguration = x.serverSideEncryptionConfiguration
            this.sourceConfiguration = x.sourceConfiguration
            this.tags = x.tags
            this.vectorIngestionConfiguration = x.vectorIngestionConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.CreateKnowledgeBaseRequest = CreateKnowledgeBaseRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.qconnect.model.RenderingConfiguration] inside the given [block]
         */
        public fun renderingConfiguration(block: aws.sdk.kotlin.services.qconnect.model.RenderingConfiguration.Builder.() -> kotlin.Unit) {
            this.renderingConfiguration = aws.sdk.kotlin.services.qconnect.model.RenderingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qconnect.model.ServerSideEncryptionConfiguration] inside the given [block]
         */
        public fun serverSideEncryptionConfiguration(block: aws.sdk.kotlin.services.qconnect.model.ServerSideEncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.serverSideEncryptionConfiguration = aws.sdk.kotlin.services.qconnect.model.ServerSideEncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qconnect.model.VectorIngestionConfiguration] inside the given [block]
         */
        public fun vectorIngestionConfiguration(block: aws.sdk.kotlin.services.qconnect.model.VectorIngestionConfiguration.Builder.() -> kotlin.Unit) {
            this.vectorIngestionConfiguration = aws.sdk.kotlin.services.qconnect.model.VectorIngestionConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (knowledgeBaseType == null) knowledgeBaseType = KnowledgeBaseType.SdkUnknown("no value provided")
            if (name == null) name = ""
            return this
        }
    }
}
