// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateContentRequest private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    public val knowledgeBaseId: kotlin.String = requireNotNull(builder.knowledgeBaseId) { "A non-null value must be provided for knowledgeBaseId" }
    /**
     * A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Amazon Q in Connect, you can store an external version identifier as metadata to utilize for determining drift.
     */
    public val metadata: Map<String, String>? = builder.metadata
    /**
     * The name of the content. Each piece of content in a knowledge base must have a unique name. You can retrieve a piece of content using only its knowledge base and its name with the [SearchContent](https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_SearchContent.html) API.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The URI you want to use for the article. If the knowledge base has a templateUri, setting this argument overrides it for this piece of content.
     */
    public val overrideLinkOutUri: kotlin.String? = builder.overrideLinkOutUri
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The title of the content. If not set, the title is equal to the name.
     */
    public val title: kotlin.String? = builder.title
    /**
     * A pointer to the uploaded asset. This value is returned by [StartContentUpload](https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_StartContentUpload.html).
     */
    public val uploadId: kotlin.String = requireNotNull(builder.uploadId) { "A non-null value must be provided for uploadId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.CreateContentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateContentRequest(")
        append("clientToken=$clientToken,")
        append("knowledgeBaseId=$knowledgeBaseId,")
        append("metadata=$metadata,")
        append("name=$name,")
        append("overrideLinkOutUri=$overrideLinkOutUri,")
        append("tags=$tags,")
        append("title=$title,")
        append("uploadId=$uploadId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (knowledgeBaseId.hashCode())
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (overrideLinkOutUri?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (uploadId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateContentRequest

        if (clientToken != other.clientToken) return false
        if (knowledgeBaseId != other.knowledgeBaseId) return false
        if (metadata != other.metadata) return false
        if (name != other.name) return false
        if (overrideLinkOutUri != other.overrideLinkOutUri) return false
        if (tags != other.tags) return false
        if (title != other.title) return false
        if (uploadId != other.uploadId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.CreateContentRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
         */
        public var clientToken: kotlin.String? = null
        /**
         * The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
         */
        public var knowledgeBaseId: kotlin.String? = null
        /**
         * A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Amazon Q in Connect, you can store an external version identifier as metadata to utilize for determining drift.
         */
        public var metadata: Map<String, String>? = null
        /**
         * The name of the content. Each piece of content in a knowledge base must have a unique name. You can retrieve a piece of content using only its knowledge base and its name with the [SearchContent](https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_SearchContent.html) API.
         */
        public var name: kotlin.String? = null
        /**
         * The URI you want to use for the article. If the knowledge base has a templateUri, setting this argument overrides it for this piece of content.
         */
        public var overrideLinkOutUri: kotlin.String? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * The title of the content. If not set, the title is equal to the name.
         */
        public var title: kotlin.String? = null
        /**
         * A pointer to the uploaded asset. This value is returned by [StartContentUpload](https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_StartContentUpload.html).
         */
        public var uploadId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.CreateContentRequest) : this() {
            this.clientToken = x.clientToken
            this.knowledgeBaseId = x.knowledgeBaseId
            this.metadata = x.metadata
            this.name = x.name
            this.overrideLinkOutUri = x.overrideLinkOutUri
            this.tags = x.tags
            this.title = x.title
            this.uploadId = x.uploadId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.CreateContentRequest = CreateContentRequest(this)

        internal fun correctErrors(): Builder {
            if (knowledgeBaseId == null) knowledgeBaseId = ""
            if (name == null) name = ""
            if (uploadId == null) uploadId = ""
            return this
        }
    }
}
