// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the content.
 */
public class ContentData private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the content.
     */
    public val contentArn: kotlin.String = requireNotNull(builder.contentArn) { "A non-null value must be provided for contentArn" }
    /**
     * The identifier of the content.
     */
    public val contentId: kotlin.String = requireNotNull(builder.contentId) { "A non-null value must be provided for contentId" }
    /**
     * The media type of the content.
     */
    public val contentType: kotlin.String = requireNotNull(builder.contentType) { "A non-null value must be provided for contentType" }
    /**
     * The Amazon Resource Name (ARN) of the knowledge base.
     */
    public val knowledgeBaseArn: kotlin.String = requireNotNull(builder.knowledgeBaseArn) { "A non-null value must be provided for knowledgeBaseArn" }
    /**
     * The identifier of the knowledge base.
     */
    public val knowledgeBaseId: kotlin.String = requireNotNull(builder.knowledgeBaseId) { "A non-null value must be provided for knowledgeBaseId" }
    /**
     * The URI of the content.
     */
    public val linkOutUri: kotlin.String? = builder.linkOutUri
    /**
     * A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Amazon Q in Connect, you can store an external version identifier as metadata to utilize for determining drift.
     */
    public val metadata: Map<String, String> = requireNotNull(builder.metadata) { "A non-null value must be provided for metadata" }
    /**
     * The name of the content.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The identifier of the content revision.
     */
    public val revisionId: kotlin.String = requireNotNull(builder.revisionId) { "A non-null value must be provided for revisionId" }
    /**
     * The status of the content.
     */
    public val status: aws.sdk.kotlin.services.qconnect.model.ContentStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The title of the content.
     */
    public val title: kotlin.String = requireNotNull(builder.title) { "A non-null value must be provided for title" }
    /**
     * The URL of the content.
     */
    public val url: kotlin.String = requireNotNull(builder.url) { "A non-null value must be provided for url" }
    /**
     * The expiration time of the URL as an epoch timestamp.
     */
    public val urlExpiry: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.urlExpiry) { "A non-null value must be provided for urlExpiry" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.ContentData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContentData(")
        append("contentArn=$contentArn,")
        append("contentId=$contentId,")
        append("contentType=$contentType,")
        append("knowledgeBaseArn=$knowledgeBaseArn,")
        append("knowledgeBaseId=$knowledgeBaseId,")
        append("linkOutUri=$linkOutUri,")
        append("metadata=$metadata,")
        append("name=$name,")
        append("revisionId=$revisionId,")
        append("status=$status,")
        append("tags=$tags,")
        append("title=$title,")
        append("url=*** Sensitive Data Redacted ***,")
        append("urlExpiry=$urlExpiry")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contentArn.hashCode()
        result = 31 * result + (contentId.hashCode())
        result = 31 * result + (contentType.hashCode())
        result = 31 * result + (knowledgeBaseArn.hashCode())
        result = 31 * result + (knowledgeBaseId.hashCode())
        result = 31 * result + (linkOutUri?.hashCode() ?: 0)
        result = 31 * result + (metadata.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (revisionId.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (title.hashCode())
        result = 31 * result + (url.hashCode())
        result = 31 * result + (urlExpiry.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContentData

        if (contentArn != other.contentArn) return false
        if (contentId != other.contentId) return false
        if (contentType != other.contentType) return false
        if (knowledgeBaseArn != other.knowledgeBaseArn) return false
        if (knowledgeBaseId != other.knowledgeBaseId) return false
        if (linkOutUri != other.linkOutUri) return false
        if (metadata != other.metadata) return false
        if (name != other.name) return false
        if (revisionId != other.revisionId) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (title != other.title) return false
        if (url != other.url) return false
        if (urlExpiry != other.urlExpiry) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.ContentData = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the content.
         */
        public var contentArn: kotlin.String? = null
        /**
         * The identifier of the content.
         */
        public var contentId: kotlin.String? = null
        /**
         * The media type of the content.
         */
        public var contentType: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the knowledge base.
         */
        public var knowledgeBaseArn: kotlin.String? = null
        /**
         * The identifier of the knowledge base.
         */
        public var knowledgeBaseId: kotlin.String? = null
        /**
         * The URI of the content.
         */
        public var linkOutUri: kotlin.String? = null
        /**
         * A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Amazon Q in Connect, you can store an external version identifier as metadata to utilize for determining drift.
         */
        public var metadata: Map<String, String>? = null
        /**
         * The name of the content.
         */
        public var name: kotlin.String? = null
        /**
         * The identifier of the content revision.
         */
        public var revisionId: kotlin.String? = null
        /**
         * The status of the content.
         */
        public var status: aws.sdk.kotlin.services.qconnect.model.ContentStatus? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * The title of the content.
         */
        public var title: kotlin.String? = null
        /**
         * The URL of the content.
         */
        public var url: kotlin.String? = null
        /**
         * The expiration time of the URL as an epoch timestamp.
         */
        public var urlExpiry: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.ContentData) : this() {
            this.contentArn = x.contentArn
            this.contentId = x.contentId
            this.contentType = x.contentType
            this.knowledgeBaseArn = x.knowledgeBaseArn
            this.knowledgeBaseId = x.knowledgeBaseId
            this.linkOutUri = x.linkOutUri
            this.metadata = x.metadata
            this.name = x.name
            this.revisionId = x.revisionId
            this.status = x.status
            this.tags = x.tags
            this.title = x.title
            this.url = x.url
            this.urlExpiry = x.urlExpiry
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.ContentData = ContentData(this)

        internal fun correctErrors(): Builder {
            if (contentArn == null) contentArn = ""
            if (contentId == null) contentId = ""
            if (contentType == null) contentType = ""
            if (knowledgeBaseArn == null) knowledgeBaseArn = ""
            if (knowledgeBaseId == null) knowledgeBaseId = ""
            if (metadata == null) metadata = emptyMap()
            if (name == null) name = ""
            if (revisionId == null) revisionId = ""
            if (status == null) status = ContentStatus.SdkUnknown("no value provided")
            if (title == null) title = ""
            if (url == null) url = ""
            if (urlExpiry == null) urlExpiry = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
