// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the content association.
 */
public class ContentAssociationData private constructor(builder: Builder) {
    /**
     * The content association.
     */
    public val associationData: aws.sdk.kotlin.services.qconnect.model.ContentAssociationContents? = builder.associationData
    /**
     * The type of association.
     */
    public val associationType: aws.sdk.kotlin.services.qconnect.model.ContentAssociationType = requireNotNull(builder.associationType) { "A non-null value must be provided for associationType" }
    /**
     * The Amazon Resource Name (ARN) of the content.
     */
    public val contentArn: kotlin.String = requireNotNull(builder.contentArn) { "A non-null value must be provided for contentArn" }
    /**
     * The Amazon Resource Name (ARN) of the content association.
     */
    public val contentAssociationArn: kotlin.String = requireNotNull(builder.contentAssociationArn) { "A non-null value must be provided for contentAssociationArn" }
    /**
     * The identifier of the content association. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    public val contentAssociationId: kotlin.String = requireNotNull(builder.contentAssociationId) { "A non-null value must be provided for contentAssociationId" }
    /**
     * The identifier of the content.
     */
    public val contentId: kotlin.String = requireNotNull(builder.contentId) { "A non-null value must be provided for contentId" }
    /**
     * The Amazon Resource Name (ARN) of the knowledge base.
     */
    public val knowledgeBaseArn: kotlin.String = requireNotNull(builder.knowledgeBaseArn) { "A non-null value must be provided for knowledgeBaseArn" }
    /**
     * The identifier of the knowledge base.
     */
    public val knowledgeBaseId: kotlin.String = requireNotNull(builder.knowledgeBaseId) { "A non-null value must be provided for knowledgeBaseId" }
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.ContentAssociationData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContentAssociationData(")
        append("associationData=$associationData,")
        append("associationType=$associationType,")
        append("contentArn=$contentArn,")
        append("contentAssociationArn=$contentAssociationArn,")
        append("contentAssociationId=$contentAssociationId,")
        append("contentId=$contentId,")
        append("knowledgeBaseArn=$knowledgeBaseArn,")
        append("knowledgeBaseId=$knowledgeBaseId,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationData?.hashCode() ?: 0
        result = 31 * result + (associationType.hashCode())
        result = 31 * result + (contentArn.hashCode())
        result = 31 * result + (contentAssociationArn.hashCode())
        result = 31 * result + (contentAssociationId.hashCode())
        result = 31 * result + (contentId.hashCode())
        result = 31 * result + (knowledgeBaseArn.hashCode())
        result = 31 * result + (knowledgeBaseId.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContentAssociationData

        if (associationData != other.associationData) return false
        if (associationType != other.associationType) return false
        if (contentArn != other.contentArn) return false
        if (contentAssociationArn != other.contentAssociationArn) return false
        if (contentAssociationId != other.contentAssociationId) return false
        if (contentId != other.contentId) return false
        if (knowledgeBaseArn != other.knowledgeBaseArn) return false
        if (knowledgeBaseId != other.knowledgeBaseId) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.ContentAssociationData = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The content association.
         */
        public var associationData: aws.sdk.kotlin.services.qconnect.model.ContentAssociationContents? = null
        /**
         * The type of association.
         */
        public var associationType: aws.sdk.kotlin.services.qconnect.model.ContentAssociationType? = null
        /**
         * The Amazon Resource Name (ARN) of the content.
         */
        public var contentArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the content association.
         */
        public var contentAssociationArn: kotlin.String? = null
        /**
         * The identifier of the content association. Can be either the ID or the ARN. URLs cannot contain the ARN.
         */
        public var contentAssociationId: kotlin.String? = null
        /**
         * The identifier of the content.
         */
        public var contentId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the knowledge base.
         */
        public var knowledgeBaseArn: kotlin.String? = null
        /**
         * The identifier of the knowledge base.
         */
        public var knowledgeBaseId: kotlin.String? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.ContentAssociationData) : this() {
            this.associationData = x.associationData
            this.associationType = x.associationType
            this.contentArn = x.contentArn
            this.contentAssociationArn = x.contentAssociationArn
            this.contentAssociationId = x.contentAssociationId
            this.contentId = x.contentId
            this.knowledgeBaseArn = x.knowledgeBaseArn
            this.knowledgeBaseId = x.knowledgeBaseId
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.ContentAssociationData = ContentAssociationData(this)

        internal fun correctErrors(): Builder {
            if (associationType == null) associationType = ContentAssociationType.SdkUnknown("no value provided")
            if (contentArn == null) contentArn = ""
            if (contentAssociationArn == null) contentAssociationArn = ""
            if (contentAssociationId == null) contentAssociationId = ""
            if (contentId == null) contentId = ""
            if (knowledgeBaseArn == null) knowledgeBaseArn = ""
            if (knowledgeBaseId == null) knowledgeBaseId = ""
            return this
        }
    }
}
