// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details about how to chunk the documents in the data source. A chunk refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried.
 */
public class ChunkingConfiguration private constructor(builder: Builder) {
    /**
     * Knowledge base can split your source data into chunks. A chunk refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried. You have the following options for chunking your data. If you opt for `NONE`, then you may want to pre-process your files by splitting them up such that each file corresponds to a chunk.
     */
    public val chunkingStrategy: aws.sdk.kotlin.services.qconnect.model.ChunkingStrategy = requireNotNull(builder.chunkingStrategy) { "A non-null value must be provided for chunkingStrategy" }
    /**
     * Configurations for when you choose fixed-size chunking. If you set the `chunkingStrategy` as `NONE`, exclude this field.
     */
    public val fixedSizeChunkingConfiguration: aws.sdk.kotlin.services.qconnect.model.FixedSizeChunkingConfiguration? = builder.fixedSizeChunkingConfiguration
    /**
     * Settings for hierarchical document chunking for a data source. Hierarchical chunking splits documents into layers of chunks where the first layer contains large chunks, and the second layer contains smaller chunks derived from the first layer.
     */
    public val hierarchicalChunkingConfiguration: aws.sdk.kotlin.services.qconnect.model.HierarchicalChunkingConfiguration? = builder.hierarchicalChunkingConfiguration
    /**
     * Settings for semantic document chunking for a data source. Semantic chunking splits a document into smaller documents based on groups of similar content derived from the text with natural language processing.
     */
    public val semanticChunkingConfiguration: aws.sdk.kotlin.services.qconnect.model.SemanticChunkingConfiguration? = builder.semanticChunkingConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.ChunkingConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ChunkingConfiguration(")
        append("chunkingStrategy=$chunkingStrategy,")
        append("fixedSizeChunkingConfiguration=$fixedSizeChunkingConfiguration,")
        append("hierarchicalChunkingConfiguration=$hierarchicalChunkingConfiguration,")
        append("semanticChunkingConfiguration=$semanticChunkingConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = chunkingStrategy.hashCode()
        result = 31 * result + (fixedSizeChunkingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (hierarchicalChunkingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (semanticChunkingConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ChunkingConfiguration

        if (chunkingStrategy != other.chunkingStrategy) return false
        if (fixedSizeChunkingConfiguration != other.fixedSizeChunkingConfiguration) return false
        if (hierarchicalChunkingConfiguration != other.hierarchicalChunkingConfiguration) return false
        if (semanticChunkingConfiguration != other.semanticChunkingConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.ChunkingConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Knowledge base can split your source data into chunks. A chunk refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried. You have the following options for chunking your data. If you opt for `NONE`, then you may want to pre-process your files by splitting them up such that each file corresponds to a chunk.
         */
        public var chunkingStrategy: aws.sdk.kotlin.services.qconnect.model.ChunkingStrategy? = null
        /**
         * Configurations for when you choose fixed-size chunking. If you set the `chunkingStrategy` as `NONE`, exclude this field.
         */
        public var fixedSizeChunkingConfiguration: aws.sdk.kotlin.services.qconnect.model.FixedSizeChunkingConfiguration? = null
        /**
         * Settings for hierarchical document chunking for a data source. Hierarchical chunking splits documents into layers of chunks where the first layer contains large chunks, and the second layer contains smaller chunks derived from the first layer.
         */
        public var hierarchicalChunkingConfiguration: aws.sdk.kotlin.services.qconnect.model.HierarchicalChunkingConfiguration? = null
        /**
         * Settings for semantic document chunking for a data source. Semantic chunking splits a document into smaller documents based on groups of similar content derived from the text with natural language processing.
         */
        public var semanticChunkingConfiguration: aws.sdk.kotlin.services.qconnect.model.SemanticChunkingConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.ChunkingConfiguration) : this() {
            this.chunkingStrategy = x.chunkingStrategy
            this.fixedSizeChunkingConfiguration = x.fixedSizeChunkingConfiguration
            this.hierarchicalChunkingConfiguration = x.hierarchicalChunkingConfiguration
            this.semanticChunkingConfiguration = x.semanticChunkingConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.ChunkingConfiguration = ChunkingConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.qconnect.model.FixedSizeChunkingConfiguration] inside the given [block]
         */
        public fun fixedSizeChunkingConfiguration(block: aws.sdk.kotlin.services.qconnect.model.FixedSizeChunkingConfiguration.Builder.() -> kotlin.Unit) {
            this.fixedSizeChunkingConfiguration = aws.sdk.kotlin.services.qconnect.model.FixedSizeChunkingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qconnect.model.HierarchicalChunkingConfiguration] inside the given [block]
         */
        public fun hierarchicalChunkingConfiguration(block: aws.sdk.kotlin.services.qconnect.model.HierarchicalChunkingConfiguration.Builder.() -> kotlin.Unit) {
            this.hierarchicalChunkingConfiguration = aws.sdk.kotlin.services.qconnect.model.HierarchicalChunkingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qconnect.model.SemanticChunkingConfiguration] inside the given [block]
         */
        public fun semanticChunkingConfiguration(block: aws.sdk.kotlin.services.qconnect.model.SemanticChunkingConfiguration.Builder.() -> kotlin.Unit) {
            this.semanticChunkingConfiguration = aws.sdk.kotlin.services.qconnect.model.SemanticChunkingConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (chunkingStrategy == null) chunkingStrategy = ChunkingStrategy.SdkUnknown("no value provided")
            return this
        }
    }
}
