// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The assistant data.
 */
public class AssistantData private constructor(builder: Builder) {
    /**
     * The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that is set on the Amazon Q in Connect Assistant.
     */
    public val aiAgentConfiguration: Map<AiAgentType, AiAgentConfigurationData>? = builder.aiAgentConfiguration
    /**
     * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
     */
    public val assistantArn: kotlin.String = requireNotNull(builder.assistantArn) { "A non-null value must be provided for assistantArn" }
    /**
     * The identifier of the Amazon Q in Connect assistant.
     */
    public val assistantId: kotlin.String = requireNotNull(builder.assistantId) { "A non-null value must be provided for assistantId" }
    /**
     * The configuration information for the Amazon Q in Connect assistant capability.
     */
    public val capabilityConfiguration: aws.sdk.kotlin.services.qconnect.model.AssistantCapabilityConfiguration? = builder.capabilityConfiguration
    /**
     * The description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The configuration information for the Amazon Q in Connect assistant integration.
     */
    public val integrationConfiguration: aws.sdk.kotlin.services.qconnect.model.AssistantIntegrationConfiguration? = builder.integrationConfiguration
    /**
     * The name.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The configuration information for the customer managed key used for encryption.
     *
     * This KMS key must have a policy that allows `kms:CreateGrant`, `kms:DescribeKey`, `kms:Decrypt`, and `kms:GenerateDataKey*` permissions to the IAM identity using the key to invoke Amazon Q in Connect. To use Amazon Q in Connect with chat, the key policy must also allow `kms:Decrypt`, `kms:GenerateDataKey*`, and `kms:DescribeKey` permissions to the `connect.amazonaws.com` service principal.
     *
     * For more information about setting up a customer managed key for Amazon Q in Connect, see [Enable Amazon Q in Connect for your instance](https://docs.aws.amazon.com/connect/latest/adminguide/enable-q.html).
     */
    public val serverSideEncryptionConfiguration: aws.sdk.kotlin.services.qconnect.model.ServerSideEncryptionConfiguration? = builder.serverSideEncryptionConfiguration
    /**
     * The status of the assistant.
     */
    public val status: aws.sdk.kotlin.services.qconnect.model.AssistantStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The type of assistant.
     */
    public val type: aws.sdk.kotlin.services.qconnect.model.AssistantType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.AssistantData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssistantData(")
        append("aiAgentConfiguration=$aiAgentConfiguration,")
        append("assistantArn=$assistantArn,")
        append("assistantId=$assistantId,")
        append("capabilityConfiguration=$capabilityConfiguration,")
        append("description=$description,")
        append("integrationConfiguration=$integrationConfiguration,")
        append("name=$name,")
        append("serverSideEncryptionConfiguration=$serverSideEncryptionConfiguration,")
        append("status=$status,")
        append("tags=$tags,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aiAgentConfiguration?.hashCode() ?: 0
        result = 31 * result + (assistantArn.hashCode())
        result = 31 * result + (assistantId.hashCode())
        result = 31 * result + (capabilityConfiguration?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (integrationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (serverSideEncryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssistantData

        if (aiAgentConfiguration != other.aiAgentConfiguration) return false
        if (assistantArn != other.assistantArn) return false
        if (assistantId != other.assistantId) return false
        if (capabilityConfiguration != other.capabilityConfiguration) return false
        if (description != other.description) return false
        if (integrationConfiguration != other.integrationConfiguration) return false
        if (name != other.name) return false
        if (serverSideEncryptionConfiguration != other.serverSideEncryptionConfiguration) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.AssistantData = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that is set on the Amazon Q in Connect Assistant.
         */
        public var aiAgentConfiguration: Map<AiAgentType, AiAgentConfigurationData>? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
         */
        public var assistantArn: kotlin.String? = null
        /**
         * The identifier of the Amazon Q in Connect assistant.
         */
        public var assistantId: kotlin.String? = null
        /**
         * The configuration information for the Amazon Q in Connect assistant capability.
         */
        public var capabilityConfiguration: aws.sdk.kotlin.services.qconnect.model.AssistantCapabilityConfiguration? = null
        /**
         * The description.
         */
        public var description: kotlin.String? = null
        /**
         * The configuration information for the Amazon Q in Connect assistant integration.
         */
        public var integrationConfiguration: aws.sdk.kotlin.services.qconnect.model.AssistantIntegrationConfiguration? = null
        /**
         * The name.
         */
        public var name: kotlin.String? = null
        /**
         * The configuration information for the customer managed key used for encryption.
         *
         * This KMS key must have a policy that allows `kms:CreateGrant`, `kms:DescribeKey`, `kms:Decrypt`, and `kms:GenerateDataKey*` permissions to the IAM identity using the key to invoke Amazon Q in Connect. To use Amazon Q in Connect with chat, the key policy must also allow `kms:Decrypt`, `kms:GenerateDataKey*`, and `kms:DescribeKey` permissions to the `connect.amazonaws.com` service principal.
         *
         * For more information about setting up a customer managed key for Amazon Q in Connect, see [Enable Amazon Q in Connect for your instance](https://docs.aws.amazon.com/connect/latest/adminguide/enable-q.html).
         */
        public var serverSideEncryptionConfiguration: aws.sdk.kotlin.services.qconnect.model.ServerSideEncryptionConfiguration? = null
        /**
         * The status of the assistant.
         */
        public var status: aws.sdk.kotlin.services.qconnect.model.AssistantStatus? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * The type of assistant.
         */
        public var type: aws.sdk.kotlin.services.qconnect.model.AssistantType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.AssistantData) : this() {
            this.aiAgentConfiguration = x.aiAgentConfiguration
            this.assistantArn = x.assistantArn
            this.assistantId = x.assistantId
            this.capabilityConfiguration = x.capabilityConfiguration
            this.description = x.description
            this.integrationConfiguration = x.integrationConfiguration
            this.name = x.name
            this.serverSideEncryptionConfiguration = x.serverSideEncryptionConfiguration
            this.status = x.status
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.AssistantData = AssistantData(this)

        /**
         * construct an [aws.sdk.kotlin.services.qconnect.model.AssistantCapabilityConfiguration] inside the given [block]
         */
        public fun capabilityConfiguration(block: aws.sdk.kotlin.services.qconnect.model.AssistantCapabilityConfiguration.Builder.() -> kotlin.Unit) {
            this.capabilityConfiguration = aws.sdk.kotlin.services.qconnect.model.AssistantCapabilityConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qconnect.model.AssistantIntegrationConfiguration] inside the given [block]
         */
        public fun integrationConfiguration(block: aws.sdk.kotlin.services.qconnect.model.AssistantIntegrationConfiguration.Builder.() -> kotlin.Unit) {
            this.integrationConfiguration = aws.sdk.kotlin.services.qconnect.model.AssistantIntegrationConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qconnect.model.ServerSideEncryptionConfiguration] inside the given [block]
         */
        public fun serverSideEncryptionConfiguration(block: aws.sdk.kotlin.services.qconnect.model.ServerSideEncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.serverSideEncryptionConfiguration = aws.sdk.kotlin.services.qconnect.model.ServerSideEncryptionConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (assistantArn == null) assistantArn = ""
            if (assistantId == null) assistantId = ""
            if (name == null) name = ""
            if (status == null) status = AssistantStatus.SdkUnknown("no value provided")
            if (type == null) type = AssistantType.SdkUnknown("no value provided")
            return this
        }
    }
}
