// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Summary information about the assistant association.
 */
public class AssistantAssociationSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
     */
    public val assistantArn: kotlin.String = requireNotNull(builder.assistantArn) { "A non-null value must be provided for assistantArn" }
    /**
     * The Amazon Resource Name (ARN) of the assistant association.
     */
    public val assistantAssociationArn: kotlin.String = requireNotNull(builder.assistantAssociationArn) { "A non-null value must be provided for assistantAssociationArn" }
    /**
     * The identifier of the assistant association.
     */
    public val assistantAssociationId: kotlin.String = requireNotNull(builder.assistantAssociationId) { "A non-null value must be provided for assistantAssociationId" }
    /**
     * The identifier of the Amazon Q in Connect assistant.
     */
    public val assistantId: kotlin.String = requireNotNull(builder.assistantId) { "A non-null value must be provided for assistantId" }
    /**
     * The association data.
     */
    public val associationData: aws.sdk.kotlin.services.qconnect.model.AssistantAssociationOutputData? = builder.associationData
    /**
     * The type of association.
     */
    public val associationType: aws.sdk.kotlin.services.qconnect.model.AssociationType = requireNotNull(builder.associationType) { "A non-null value must be provided for associationType" }
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.AssistantAssociationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssistantAssociationSummary(")
        append("assistantArn=$assistantArn,")
        append("assistantAssociationArn=$assistantAssociationArn,")
        append("assistantAssociationId=$assistantAssociationId,")
        append("assistantId=$assistantId,")
        append("associationData=$associationData,")
        append("associationType=$associationType,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assistantArn.hashCode()
        result = 31 * result + (assistantAssociationArn.hashCode())
        result = 31 * result + (assistantAssociationId.hashCode())
        result = 31 * result + (assistantId.hashCode())
        result = 31 * result + (associationData?.hashCode() ?: 0)
        result = 31 * result + (associationType.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssistantAssociationSummary

        if (assistantArn != other.assistantArn) return false
        if (assistantAssociationArn != other.assistantAssociationArn) return false
        if (assistantAssociationId != other.assistantAssociationId) return false
        if (assistantId != other.assistantId) return false
        if (associationData != other.associationData) return false
        if (associationType != other.associationType) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.AssistantAssociationSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
         */
        public var assistantArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the assistant association.
         */
        public var assistantAssociationArn: kotlin.String? = null
        /**
         * The identifier of the assistant association.
         */
        public var assistantAssociationId: kotlin.String? = null
        /**
         * The identifier of the Amazon Q in Connect assistant.
         */
        public var assistantId: kotlin.String? = null
        /**
         * The association data.
         */
        public var associationData: aws.sdk.kotlin.services.qconnect.model.AssistantAssociationOutputData? = null
        /**
         * The type of association.
         */
        public var associationType: aws.sdk.kotlin.services.qconnect.model.AssociationType? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.AssistantAssociationSummary) : this() {
            this.assistantArn = x.assistantArn
            this.assistantAssociationArn = x.assistantAssociationArn
            this.assistantAssociationId = x.assistantAssociationId
            this.assistantId = x.assistantId
            this.associationData = x.associationData
            this.associationType = x.associationType
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.AssistantAssociationSummary = AssistantAssociationSummary(this)

        internal fun correctErrors(): Builder {
            if (assistantArn == null) assistantArn = ""
            if (assistantAssociationArn == null) assistantAssociationArn = ""
            if (assistantAssociationId == null) assistantAssociationId = ""
            if (assistantId == null) assistantId = ""
            if (associationType == null) associationType = AssociationType.SdkUnknown("no value provided")
            return this
        }
    }
}
