// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The data for the AI Prompt
 */
public class AiPromptData private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the AI Prompt.
     */
    public val aiPromptArn: kotlin.String = requireNotNull(builder.aiPromptArn) { "A non-null value must be provided for aiPromptArn" }
    /**
     * The identifier of the Amazon Q in Connect AI prompt.
     */
    public val aiPromptId: kotlin.String = requireNotNull(builder.aiPromptId) { "A non-null value must be provided for aiPromptId" }
    /**
     * The API format used for this AI Prompt.
     */
    public val apiFormat: aws.sdk.kotlin.services.qconnect.model.AiPromptApiFormat = requireNotNull(builder.apiFormat) { "A non-null value must be provided for apiFormat" }
    /**
     * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
     */
    public val assistantArn: kotlin.String = requireNotNull(builder.assistantArn) { "A non-null value must be provided for assistantArn" }
    /**
     * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    public val assistantId: kotlin.String = requireNotNull(builder.assistantId) { "A non-null value must be provided for assistantId" }
    /**
     * The description of the AI Prompt.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the model used for this AI Prompt. The following model Ids are supported:
     * + `anthropic.claude-3-haiku--v1:0`
     * + `apac.amazon.nova-lite-v1:0`
     * + `apac.amazon.nova-micro-v1:0`
     * + `apac.amazon.nova-pro-v1:0`
     * + `apac.anthropic.claude-3-5-sonnet--v2:0`
     * + `apac.anthropic.claude-3-haiku-20240307-v1:0`
     * + `eu.amazon.nova-lite-v1:0`
     * + `eu.amazon.nova-micro-v1:0`
     * + `eu.amazon.nova-pro-v1:0`
     * + `eu.anthropic.claude-3-7-sonnet-20250219-v1:0`
     * + `eu.anthropic.claude-3-haiku-20240307-v1:0`
     * + `us.amazon.nova-lite-v1:0`
     * + `us.amazon.nova-micro-v1:0`
     * + `us.amazon.nova-pro-v1:0`
     * + `us.anthropic.claude-3-5-haiku-20241022-v1:0`
     * + `us.anthropic.claude-3-7-sonnet-20250219-v1:0`
     * + `us.anthropic.claude-3-haiku-20240307-v1:0`
     */
    public val modelId: kotlin.String = requireNotNull(builder.modelId) { "A non-null value must be provided for modelId" }
    /**
     * The time the AI Prompt was last modified.
     */
    public val modifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.modifiedTime
    /**
     * The name of the AI Prompt
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The origin of the AI Prompt. `SYSTEM` for a default AI Prompt created by Q in Connect or `CUSTOMER` for an AI Prompt created by calling AI Prompt creation APIs.
     */
    public val origin: aws.sdk.kotlin.services.qconnect.model.Origin? = builder.origin
    /**
     * The status of the AI Prompt.
     */
    public val status: aws.sdk.kotlin.services.qconnect.model.Status? = builder.status
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The configuration of the prompt template for this AI Prompt.
     */
    public val templateConfiguration: aws.sdk.kotlin.services.qconnect.model.AiPromptTemplateConfiguration? = builder.templateConfiguration
    /**
     * The type of the prompt template for this AI Prompt.
     */
    public val templateType: aws.sdk.kotlin.services.qconnect.model.AiPromptTemplateType = requireNotNull(builder.templateType) { "A non-null value must be provided for templateType" }
    /**
     * The type of this AI Prompt.
     */
    public val type: aws.sdk.kotlin.services.qconnect.model.AiPromptType = requireNotNull(builder.type) { "A non-null value must be provided for type" }
    /**
     * The visibility status of the AI Prompt.
     */
    public val visibilityStatus: aws.sdk.kotlin.services.qconnect.model.VisibilityStatus = requireNotNull(builder.visibilityStatus) { "A non-null value must be provided for visibilityStatus" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.AiPromptData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AiPromptData(")
        append("aiPromptArn=$aiPromptArn,")
        append("aiPromptId=$aiPromptId,")
        append("apiFormat=$apiFormat,")
        append("assistantArn=$assistantArn,")
        append("assistantId=$assistantId,")
        append("description=$description,")
        append("modelId=$modelId,")
        append("modifiedTime=$modifiedTime,")
        append("name=$name,")
        append("origin=$origin,")
        append("status=$status,")
        append("tags=$tags,")
        append("templateConfiguration=$templateConfiguration,")
        append("templateType=$templateType,")
        append("type=$type,")
        append("visibilityStatus=$visibilityStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aiPromptArn.hashCode()
        result = 31 * result + (aiPromptId.hashCode())
        result = 31 * result + (apiFormat.hashCode())
        result = 31 * result + (assistantArn.hashCode())
        result = 31 * result + (assistantId.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (modelId.hashCode())
        result = 31 * result + (modifiedTime?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (origin?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateConfiguration?.hashCode() ?: 0)
        result = 31 * result + (templateType.hashCode())
        result = 31 * result + (type.hashCode())
        result = 31 * result + (visibilityStatus.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AiPromptData

        if (aiPromptArn != other.aiPromptArn) return false
        if (aiPromptId != other.aiPromptId) return false
        if (apiFormat != other.apiFormat) return false
        if (assistantArn != other.assistantArn) return false
        if (assistantId != other.assistantId) return false
        if (description != other.description) return false
        if (modelId != other.modelId) return false
        if (modifiedTime != other.modifiedTime) return false
        if (name != other.name) return false
        if (origin != other.origin) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (templateConfiguration != other.templateConfiguration) return false
        if (templateType != other.templateType) return false
        if (type != other.type) return false
        if (visibilityStatus != other.visibilityStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.AiPromptData = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the AI Prompt.
         */
        public var aiPromptArn: kotlin.String? = null
        /**
         * The identifier of the Amazon Q in Connect AI prompt.
         */
        public var aiPromptId: kotlin.String? = null
        /**
         * The API format used for this AI Prompt.
         */
        public var apiFormat: aws.sdk.kotlin.services.qconnect.model.AiPromptApiFormat? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
         */
        public var assistantArn: kotlin.String? = null
        /**
         * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
         */
        public var assistantId: kotlin.String? = null
        /**
         * The description of the AI Prompt.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the model used for this AI Prompt. The following model Ids are supported:
         * + `anthropic.claude-3-haiku--v1:0`
         * + `apac.amazon.nova-lite-v1:0`
         * + `apac.amazon.nova-micro-v1:0`
         * + `apac.amazon.nova-pro-v1:0`
         * + `apac.anthropic.claude-3-5-sonnet--v2:0`
         * + `apac.anthropic.claude-3-haiku-20240307-v1:0`
         * + `eu.amazon.nova-lite-v1:0`
         * + `eu.amazon.nova-micro-v1:0`
         * + `eu.amazon.nova-pro-v1:0`
         * + `eu.anthropic.claude-3-7-sonnet-20250219-v1:0`
         * + `eu.anthropic.claude-3-haiku-20240307-v1:0`
         * + `us.amazon.nova-lite-v1:0`
         * + `us.amazon.nova-micro-v1:0`
         * + `us.amazon.nova-pro-v1:0`
         * + `us.anthropic.claude-3-5-haiku-20241022-v1:0`
         * + `us.anthropic.claude-3-7-sonnet-20250219-v1:0`
         * + `us.anthropic.claude-3-haiku-20240307-v1:0`
         */
        public var modelId: kotlin.String? = null
        /**
         * The time the AI Prompt was last modified.
         */
        public var modifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the AI Prompt
         */
        public var name: kotlin.String? = null
        /**
         * The origin of the AI Prompt. `SYSTEM` for a default AI Prompt created by Q in Connect or `CUSTOMER` for an AI Prompt created by calling AI Prompt creation APIs.
         */
        public var origin: aws.sdk.kotlin.services.qconnect.model.Origin? = null
        /**
         * The status of the AI Prompt.
         */
        public var status: aws.sdk.kotlin.services.qconnect.model.Status? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * The configuration of the prompt template for this AI Prompt.
         */
        public var templateConfiguration: aws.sdk.kotlin.services.qconnect.model.AiPromptTemplateConfiguration? = null
        /**
         * The type of the prompt template for this AI Prompt.
         */
        public var templateType: aws.sdk.kotlin.services.qconnect.model.AiPromptTemplateType? = null
        /**
         * The type of this AI Prompt.
         */
        public var type: aws.sdk.kotlin.services.qconnect.model.AiPromptType? = null
        /**
         * The visibility status of the AI Prompt.
         */
        public var visibilityStatus: aws.sdk.kotlin.services.qconnect.model.VisibilityStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.AiPromptData) : this() {
            this.aiPromptArn = x.aiPromptArn
            this.aiPromptId = x.aiPromptId
            this.apiFormat = x.apiFormat
            this.assistantArn = x.assistantArn
            this.assistantId = x.assistantId
            this.description = x.description
            this.modelId = x.modelId
            this.modifiedTime = x.modifiedTime
            this.name = x.name
            this.origin = x.origin
            this.status = x.status
            this.tags = x.tags
            this.templateConfiguration = x.templateConfiguration
            this.templateType = x.templateType
            this.type = x.type
            this.visibilityStatus = x.visibilityStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.AiPromptData = AiPromptData(this)

        internal fun correctErrors(): Builder {
            if (aiPromptArn == null) aiPromptArn = ""
            if (aiPromptId == null) aiPromptId = ""
            if (apiFormat == null) apiFormat = AiPromptApiFormat.SdkUnknown("no value provided")
            if (assistantArn == null) assistantArn = ""
            if (assistantId == null) assistantId = ""
            if (modelId == null) modelId = ""
            if (name == null) name = ""
            if (templateType == null) templateType = AiPromptTemplateType.SdkUnknown("no value provided")
            if (type == null) type = AiPromptType.SdkUnknown("no value provided")
            if (visibilityStatus == null) visibilityStatus = VisibilityStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
