// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The summary of the AI Guardrail.
 */
public class AiGuardrailSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the AI Guardrail.
     */
    public val aiGuardrailArn: kotlin.String = requireNotNull(builder.aiGuardrailArn) { "A non-null value must be provided for aiGuardrailArn" }
    /**
     * The identifier of the Amazon Q in Connect AI Guardrail.
     */
    public val aiGuardrailId: kotlin.String = requireNotNull(builder.aiGuardrailId) { "A non-null value must be provided for aiGuardrailId" }
    /**
     * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
     */
    public val assistantArn: kotlin.String = requireNotNull(builder.assistantArn) { "A non-null value must be provided for assistantArn" }
    /**
     * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    public val assistantId: kotlin.String = requireNotNull(builder.assistantId) { "A non-null value must be provided for assistantId" }
    /**
     * A description of the AI Guardrail.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The time the AI Guardrail was last modified.
     */
    public val modifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.modifiedTime
    /**
     * The name of the AI Guardrail.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The status of the AI Guardrail.
     */
    public val status: aws.sdk.kotlin.services.qconnect.model.Status? = builder.status
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The visibility status of the AI Guardrail.
     */
    public val visibilityStatus: aws.sdk.kotlin.services.qconnect.model.VisibilityStatus = requireNotNull(builder.visibilityStatus) { "A non-null value must be provided for visibilityStatus" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.AiGuardrailSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AiGuardrailSummary(")
        append("aiGuardrailArn=$aiGuardrailArn,")
        append("aiGuardrailId=$aiGuardrailId,")
        append("assistantArn=$assistantArn,")
        append("assistantId=$assistantId,")
        append("description=*** Sensitive Data Redacted ***,")
        append("modifiedTime=$modifiedTime,")
        append("name=$name,")
        append("status=$status,")
        append("tags=$tags,")
        append("visibilityStatus=$visibilityStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aiGuardrailArn.hashCode()
        result = 31 * result + (aiGuardrailId.hashCode())
        result = 31 * result + (assistantArn.hashCode())
        result = 31 * result + (assistantId.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (modifiedTime?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (visibilityStatus.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AiGuardrailSummary

        if (aiGuardrailArn != other.aiGuardrailArn) return false
        if (aiGuardrailId != other.aiGuardrailId) return false
        if (assistantArn != other.assistantArn) return false
        if (assistantId != other.assistantId) return false
        if (description != other.description) return false
        if (modifiedTime != other.modifiedTime) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (visibilityStatus != other.visibilityStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.AiGuardrailSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the AI Guardrail.
         */
        public var aiGuardrailArn: kotlin.String? = null
        /**
         * The identifier of the Amazon Q in Connect AI Guardrail.
         */
        public var aiGuardrailId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
         */
        public var assistantArn: kotlin.String? = null
        /**
         * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
         */
        public var assistantId: kotlin.String? = null
        /**
         * A description of the AI Guardrail.
         */
        public var description: kotlin.String? = null
        /**
         * The time the AI Guardrail was last modified.
         */
        public var modifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the AI Guardrail.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the AI Guardrail.
         */
        public var status: aws.sdk.kotlin.services.qconnect.model.Status? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * The visibility status of the AI Guardrail.
         */
        public var visibilityStatus: aws.sdk.kotlin.services.qconnect.model.VisibilityStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.AiGuardrailSummary) : this() {
            this.aiGuardrailArn = x.aiGuardrailArn
            this.aiGuardrailId = x.aiGuardrailId
            this.assistantArn = x.assistantArn
            this.assistantId = x.assistantId
            this.description = x.description
            this.modifiedTime = x.modifiedTime
            this.name = x.name
            this.status = x.status
            this.tags = x.tags
            this.visibilityStatus = x.visibilityStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.AiGuardrailSummary = AiGuardrailSummary(this)

        internal fun correctErrors(): Builder {
            if (aiGuardrailArn == null) aiGuardrailArn = ""
            if (aiGuardrailId == null) aiGuardrailId = ""
            if (assistantArn == null) assistantArn = ""
            if (assistantId == null) assistantId = ""
            if (name == null) name = ""
            if (visibilityStatus == null) visibilityStatus = VisibilityStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
