// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The data for the AI Guardrail
 */
public class AiGuardrailData private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the AI Guardrail.
     */
    public val aiGuardrailArn: kotlin.String = requireNotNull(builder.aiGuardrailArn) { "A non-null value must be provided for aiGuardrailArn" }
    /**
     * The identifier of the Amazon Q in Connect AI Guardrail.
     */
    public val aiGuardrailId: kotlin.String = requireNotNull(builder.aiGuardrailId) { "A non-null value must be provided for aiGuardrailId" }
    /**
     * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
     */
    public val assistantArn: kotlin.String = requireNotNull(builder.assistantArn) { "A non-null value must be provided for assistantArn" }
    /**
     * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    public val assistantId: kotlin.String = requireNotNull(builder.assistantId) { "A non-null value must be provided for assistantId" }
    /**
     * The message to return when the AI Guardrail blocks a prompt.
     */
    public val blockedInputMessaging: kotlin.String = requireNotNull(builder.blockedInputMessaging) { "A non-null value must be provided for blockedInputMessaging" }
    /**
     * The message to return when the AI Guardrail blocks a model response.
     */
    public val blockedOutputsMessaging: kotlin.String = requireNotNull(builder.blockedOutputsMessaging) { "A non-null value must be provided for blockedOutputsMessaging" }
    /**
     * Contains details about how to handle harmful content.
     */
    public val contentPolicyConfig: aws.sdk.kotlin.services.qconnect.model.AiGuardrailContentPolicyConfig? = builder.contentPolicyConfig
    /**
     * The policy configuration details for the AI Guardrail's contextual grounding policy.
     */
    public val contextualGroundingPolicyConfig: aws.sdk.kotlin.services.qconnect.model.AiGuardrailContextualGroundingPolicyConfig? = builder.contextualGroundingPolicyConfig
    /**
     * A description of the AI Guardrail.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The time the AI Guardrail was last modified.
     */
    public val modifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.modifiedTime
    /**
     * The name of the AI Guardrail.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Contains details about PII entities and regular expressions to configure for the AI Guardrail.
     */
    public val sensitiveInformationPolicyConfig: aws.sdk.kotlin.services.qconnect.model.AiGuardrailSensitiveInformationPolicyConfig? = builder.sensitiveInformationPolicyConfig
    /**
     * The status of the AI Guardrail.
     */
    public val status: aws.sdk.kotlin.services.qconnect.model.Status? = builder.status
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Contains details about topics that the AI Guardrail should identify and deny.
     */
    public val topicPolicyConfig: aws.sdk.kotlin.services.qconnect.model.AiGuardrailTopicPolicyConfig? = builder.topicPolicyConfig
    /**
     * The visibility status of the AI Guardrail.
     */
    public val visibilityStatus: aws.sdk.kotlin.services.qconnect.model.VisibilityStatus = requireNotNull(builder.visibilityStatus) { "A non-null value must be provided for visibilityStatus" }
    /**
     * Contains details about the word policy to configured for the AI Guardrail.
     */
    public val wordPolicyConfig: aws.sdk.kotlin.services.qconnect.model.AiGuardrailWordPolicyConfig? = builder.wordPolicyConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.AiGuardrailData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AiGuardrailData(")
        append("aiGuardrailArn=$aiGuardrailArn,")
        append("aiGuardrailId=$aiGuardrailId,")
        append("assistantArn=$assistantArn,")
        append("assistantId=$assistantId,")
        append("blockedInputMessaging=*** Sensitive Data Redacted ***,")
        append("blockedOutputsMessaging=*** Sensitive Data Redacted ***,")
        append("contentPolicyConfig=$contentPolicyConfig,")
        append("contextualGroundingPolicyConfig=$contextualGroundingPolicyConfig,")
        append("description=*** Sensitive Data Redacted ***,")
        append("modifiedTime=$modifiedTime,")
        append("name=$name,")
        append("sensitiveInformationPolicyConfig=$sensitiveInformationPolicyConfig,")
        append("status=$status,")
        append("tags=$tags,")
        append("topicPolicyConfig=$topicPolicyConfig,")
        append("visibilityStatus=$visibilityStatus,")
        append("wordPolicyConfig=$wordPolicyConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aiGuardrailArn.hashCode()
        result = 31 * result + (aiGuardrailId.hashCode())
        result = 31 * result + (assistantArn.hashCode())
        result = 31 * result + (assistantId.hashCode())
        result = 31 * result + (blockedInputMessaging.hashCode())
        result = 31 * result + (blockedOutputsMessaging.hashCode())
        result = 31 * result + (contentPolicyConfig?.hashCode() ?: 0)
        result = 31 * result + (contextualGroundingPolicyConfig?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (modifiedTime?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (sensitiveInformationPolicyConfig?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (topicPolicyConfig?.hashCode() ?: 0)
        result = 31 * result + (visibilityStatus.hashCode())
        result = 31 * result + (wordPolicyConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AiGuardrailData

        if (aiGuardrailArn != other.aiGuardrailArn) return false
        if (aiGuardrailId != other.aiGuardrailId) return false
        if (assistantArn != other.assistantArn) return false
        if (assistantId != other.assistantId) return false
        if (blockedInputMessaging != other.blockedInputMessaging) return false
        if (blockedOutputsMessaging != other.blockedOutputsMessaging) return false
        if (contentPolicyConfig != other.contentPolicyConfig) return false
        if (contextualGroundingPolicyConfig != other.contextualGroundingPolicyConfig) return false
        if (description != other.description) return false
        if (modifiedTime != other.modifiedTime) return false
        if (name != other.name) return false
        if (sensitiveInformationPolicyConfig != other.sensitiveInformationPolicyConfig) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (topicPolicyConfig != other.topicPolicyConfig) return false
        if (visibilityStatus != other.visibilityStatus) return false
        if (wordPolicyConfig != other.wordPolicyConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.AiGuardrailData = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the AI Guardrail.
         */
        public var aiGuardrailArn: kotlin.String? = null
        /**
         * The identifier of the Amazon Q in Connect AI Guardrail.
         */
        public var aiGuardrailId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
         */
        public var assistantArn: kotlin.String? = null
        /**
         * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
         */
        public var assistantId: kotlin.String? = null
        /**
         * The message to return when the AI Guardrail blocks a prompt.
         */
        public var blockedInputMessaging: kotlin.String? = null
        /**
         * The message to return when the AI Guardrail blocks a model response.
         */
        public var blockedOutputsMessaging: kotlin.String? = null
        /**
         * Contains details about how to handle harmful content.
         */
        public var contentPolicyConfig: aws.sdk.kotlin.services.qconnect.model.AiGuardrailContentPolicyConfig? = null
        /**
         * The policy configuration details for the AI Guardrail's contextual grounding policy.
         */
        public var contextualGroundingPolicyConfig: aws.sdk.kotlin.services.qconnect.model.AiGuardrailContextualGroundingPolicyConfig? = null
        /**
         * A description of the AI Guardrail.
         */
        public var description: kotlin.String? = null
        /**
         * The time the AI Guardrail was last modified.
         */
        public var modifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the AI Guardrail.
         */
        public var name: kotlin.String? = null
        /**
         * Contains details about PII entities and regular expressions to configure for the AI Guardrail.
         */
        public var sensitiveInformationPolicyConfig: aws.sdk.kotlin.services.qconnect.model.AiGuardrailSensitiveInformationPolicyConfig? = null
        /**
         * The status of the AI Guardrail.
         */
        public var status: aws.sdk.kotlin.services.qconnect.model.Status? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * Contains details about topics that the AI Guardrail should identify and deny.
         */
        public var topicPolicyConfig: aws.sdk.kotlin.services.qconnect.model.AiGuardrailTopicPolicyConfig? = null
        /**
         * The visibility status of the AI Guardrail.
         */
        public var visibilityStatus: aws.sdk.kotlin.services.qconnect.model.VisibilityStatus? = null
        /**
         * Contains details about the word policy to configured for the AI Guardrail.
         */
        public var wordPolicyConfig: aws.sdk.kotlin.services.qconnect.model.AiGuardrailWordPolicyConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.AiGuardrailData) : this() {
            this.aiGuardrailArn = x.aiGuardrailArn
            this.aiGuardrailId = x.aiGuardrailId
            this.assistantArn = x.assistantArn
            this.assistantId = x.assistantId
            this.blockedInputMessaging = x.blockedInputMessaging
            this.blockedOutputsMessaging = x.blockedOutputsMessaging
            this.contentPolicyConfig = x.contentPolicyConfig
            this.contextualGroundingPolicyConfig = x.contextualGroundingPolicyConfig
            this.description = x.description
            this.modifiedTime = x.modifiedTime
            this.name = x.name
            this.sensitiveInformationPolicyConfig = x.sensitiveInformationPolicyConfig
            this.status = x.status
            this.tags = x.tags
            this.topicPolicyConfig = x.topicPolicyConfig
            this.visibilityStatus = x.visibilityStatus
            this.wordPolicyConfig = x.wordPolicyConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.AiGuardrailData = AiGuardrailData(this)

        /**
         * construct an [aws.sdk.kotlin.services.qconnect.model.AiGuardrailContentPolicyConfig] inside the given [block]
         */
        public fun contentPolicyConfig(block: aws.sdk.kotlin.services.qconnect.model.AiGuardrailContentPolicyConfig.Builder.() -> kotlin.Unit) {
            this.contentPolicyConfig = aws.sdk.kotlin.services.qconnect.model.AiGuardrailContentPolicyConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qconnect.model.AiGuardrailContextualGroundingPolicyConfig] inside the given [block]
         */
        public fun contextualGroundingPolicyConfig(block: aws.sdk.kotlin.services.qconnect.model.AiGuardrailContextualGroundingPolicyConfig.Builder.() -> kotlin.Unit) {
            this.contextualGroundingPolicyConfig = aws.sdk.kotlin.services.qconnect.model.AiGuardrailContextualGroundingPolicyConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qconnect.model.AiGuardrailSensitiveInformationPolicyConfig] inside the given [block]
         */
        public fun sensitiveInformationPolicyConfig(block: aws.sdk.kotlin.services.qconnect.model.AiGuardrailSensitiveInformationPolicyConfig.Builder.() -> kotlin.Unit) {
            this.sensitiveInformationPolicyConfig = aws.sdk.kotlin.services.qconnect.model.AiGuardrailSensitiveInformationPolicyConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qconnect.model.AiGuardrailTopicPolicyConfig] inside the given [block]
         */
        public fun topicPolicyConfig(block: aws.sdk.kotlin.services.qconnect.model.AiGuardrailTopicPolicyConfig.Builder.() -> kotlin.Unit) {
            this.topicPolicyConfig = aws.sdk.kotlin.services.qconnect.model.AiGuardrailTopicPolicyConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qconnect.model.AiGuardrailWordPolicyConfig] inside the given [block]
         */
        public fun wordPolicyConfig(block: aws.sdk.kotlin.services.qconnect.model.AiGuardrailWordPolicyConfig.Builder.() -> kotlin.Unit) {
            this.wordPolicyConfig = aws.sdk.kotlin.services.qconnect.model.AiGuardrailWordPolicyConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (aiGuardrailArn == null) aiGuardrailArn = ""
            if (aiGuardrailId == null) aiGuardrailId = ""
            if (assistantArn == null) assistantArn = ""
            if (assistantId == null) assistantId = ""
            if (blockedInputMessaging == null) blockedInputMessaging = ""
            if (blockedOutputsMessaging == null) blockedOutputsMessaging = ""
            if (name == null) name = ""
            if (visibilityStatus == null) visibilityStatus = VisibilityStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
