// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The summary of the AI Agent.
 */
public class AiAgentSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the AI agent.
     */
    public val aiAgentArn: kotlin.String = requireNotNull(builder.aiAgentArn) { "A non-null value must be provided for aiAgentArn" }
    /**
     * The identifier of the AI Agent.
     */
    public val aiAgentId: kotlin.String = requireNotNull(builder.aiAgentId) { "A non-null value must be provided for aiAgentId" }
    /**
     * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
     */
    public val assistantArn: kotlin.String = requireNotNull(builder.assistantArn) { "A non-null value must be provided for assistantArn" }
    /**
     * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    public val assistantId: kotlin.String = requireNotNull(builder.assistantId) { "A non-null value must be provided for assistantId" }
    /**
     * The configuration for the AI Agent.
     */
    public val configuration: aws.sdk.kotlin.services.qconnect.model.AiAgentConfiguration? = builder.configuration
    /**
     * The description of the AI Agent.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The time the AI Agent was last modified.
     */
    public val modifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.modifiedTime
    /**
     * The name of the AI Agent.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The origin of the AI Agent. `SYSTEM` for a default AI Agent created by Q in Connect or `CUSTOMER` for an AI Agent created by calling AI Agent creation APIs.
     */
    public val origin: aws.sdk.kotlin.services.qconnect.model.Origin? = builder.origin
    /**
     * The status of the AI Agent.
     */
    public val status: aws.sdk.kotlin.services.qconnect.model.Status? = builder.status
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The type of the AI Agent.
     */
    public val type: aws.sdk.kotlin.services.qconnect.model.AiAgentType = requireNotNull(builder.type) { "A non-null value must be provided for type" }
    /**
     * The visibility status of the AI Agent.
     */
    public val visibilityStatus: aws.sdk.kotlin.services.qconnect.model.VisibilityStatus = requireNotNull(builder.visibilityStatus) { "A non-null value must be provided for visibilityStatus" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qconnect.model.AiAgentSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AiAgentSummary(")
        append("aiAgentArn=$aiAgentArn,")
        append("aiAgentId=$aiAgentId,")
        append("assistantArn=$assistantArn,")
        append("assistantId=$assistantId,")
        append("configuration=$configuration,")
        append("description=$description,")
        append("modifiedTime=$modifiedTime,")
        append("name=$name,")
        append("origin=$origin,")
        append("status=$status,")
        append("tags=$tags,")
        append("type=$type,")
        append("visibilityStatus=$visibilityStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aiAgentArn.hashCode()
        result = 31 * result + (aiAgentId.hashCode())
        result = 31 * result + (assistantArn.hashCode())
        result = 31 * result + (assistantId.hashCode())
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (modifiedTime?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (origin?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type.hashCode())
        result = 31 * result + (visibilityStatus.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AiAgentSummary

        if (aiAgentArn != other.aiAgentArn) return false
        if (aiAgentId != other.aiAgentId) return false
        if (assistantArn != other.assistantArn) return false
        if (assistantId != other.assistantId) return false
        if (configuration != other.configuration) return false
        if (description != other.description) return false
        if (modifiedTime != other.modifiedTime) return false
        if (name != other.name) return false
        if (origin != other.origin) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (visibilityStatus != other.visibilityStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qconnect.model.AiAgentSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the AI agent.
         */
        public var aiAgentArn: kotlin.String? = null
        /**
         * The identifier of the AI Agent.
         */
        public var aiAgentId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
         */
        public var assistantArn: kotlin.String? = null
        /**
         * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
         */
        public var assistantId: kotlin.String? = null
        /**
         * The configuration for the AI Agent.
         */
        public var configuration: aws.sdk.kotlin.services.qconnect.model.AiAgentConfiguration? = null
        /**
         * The description of the AI Agent.
         */
        public var description: kotlin.String? = null
        /**
         * The time the AI Agent was last modified.
         */
        public var modifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the AI Agent.
         */
        public var name: kotlin.String? = null
        /**
         * The origin of the AI Agent. `SYSTEM` for a default AI Agent created by Q in Connect or `CUSTOMER` for an AI Agent created by calling AI Agent creation APIs.
         */
        public var origin: aws.sdk.kotlin.services.qconnect.model.Origin? = null
        /**
         * The status of the AI Agent.
         */
        public var status: aws.sdk.kotlin.services.qconnect.model.Status? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * The type of the AI Agent.
         */
        public var type: aws.sdk.kotlin.services.qconnect.model.AiAgentType? = null
        /**
         * The visibility status of the AI Agent.
         */
        public var visibilityStatus: aws.sdk.kotlin.services.qconnect.model.VisibilityStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qconnect.model.AiAgentSummary) : this() {
            this.aiAgentArn = x.aiAgentArn
            this.aiAgentId = x.aiAgentId
            this.assistantArn = x.assistantArn
            this.assistantId = x.assistantId
            this.configuration = x.configuration
            this.description = x.description
            this.modifiedTime = x.modifiedTime
            this.name = x.name
            this.origin = x.origin
            this.status = x.status
            this.tags = x.tags
            this.type = x.type
            this.visibilityStatus = x.visibilityStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qconnect.model.AiAgentSummary = AiAgentSummary(this)

        internal fun correctErrors(): Builder {
            if (aiAgentArn == null) aiAgentArn = ""
            if (aiAgentId == null) aiAgentId = ""
            if (assistantArn == null) assistantArn = ""
            if (assistantId == null) assistantId = ""
            if (name == null) name = ""
            if (type == null) type = AiAgentType.SdkUnknown("no value provided")
            if (visibilityStatus == null) visibilityStatus = VisibilityStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
