// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.qconnect.auth.DefaultQConnectAuthSchemeProvider
import aws.sdk.kotlin.services.qconnect.auth.QConnectAuthSchemeProvider
import aws.sdk.kotlin.services.qconnect.endpoints.DefaultQConnectEndpointProvider
import aws.sdk.kotlin.services.qconnect.endpoints.QConnectEndpointParameters
import aws.sdk.kotlin.services.qconnect.endpoints.QConnectEndpointProvider
import aws.sdk.kotlin.services.qconnect.model.ActivateMessageTemplateRequest
import aws.sdk.kotlin.services.qconnect.model.ActivateMessageTemplateResponse
import aws.sdk.kotlin.services.qconnect.model.CreateAiAgentRequest
import aws.sdk.kotlin.services.qconnect.model.CreateAiAgentResponse
import aws.sdk.kotlin.services.qconnect.model.CreateAiAgentVersionRequest
import aws.sdk.kotlin.services.qconnect.model.CreateAiAgentVersionResponse
import aws.sdk.kotlin.services.qconnect.model.CreateAiGuardrailRequest
import aws.sdk.kotlin.services.qconnect.model.CreateAiGuardrailResponse
import aws.sdk.kotlin.services.qconnect.model.CreateAiGuardrailVersionRequest
import aws.sdk.kotlin.services.qconnect.model.CreateAiGuardrailVersionResponse
import aws.sdk.kotlin.services.qconnect.model.CreateAiPromptRequest
import aws.sdk.kotlin.services.qconnect.model.CreateAiPromptResponse
import aws.sdk.kotlin.services.qconnect.model.CreateAiPromptVersionRequest
import aws.sdk.kotlin.services.qconnect.model.CreateAiPromptVersionResponse
import aws.sdk.kotlin.services.qconnect.model.CreateAssistantAssociationRequest
import aws.sdk.kotlin.services.qconnect.model.CreateAssistantAssociationResponse
import aws.sdk.kotlin.services.qconnect.model.CreateAssistantRequest
import aws.sdk.kotlin.services.qconnect.model.CreateAssistantResponse
import aws.sdk.kotlin.services.qconnect.model.CreateContentAssociationRequest
import aws.sdk.kotlin.services.qconnect.model.CreateContentAssociationResponse
import aws.sdk.kotlin.services.qconnect.model.CreateContentRequest
import aws.sdk.kotlin.services.qconnect.model.CreateContentResponse
import aws.sdk.kotlin.services.qconnect.model.CreateKnowledgeBaseRequest
import aws.sdk.kotlin.services.qconnect.model.CreateKnowledgeBaseResponse
import aws.sdk.kotlin.services.qconnect.model.CreateMessageTemplateAttachmentRequest
import aws.sdk.kotlin.services.qconnect.model.CreateMessageTemplateAttachmentResponse
import aws.sdk.kotlin.services.qconnect.model.CreateMessageTemplateRequest
import aws.sdk.kotlin.services.qconnect.model.CreateMessageTemplateResponse
import aws.sdk.kotlin.services.qconnect.model.CreateMessageTemplateVersionRequest
import aws.sdk.kotlin.services.qconnect.model.CreateMessageTemplateVersionResponse
import aws.sdk.kotlin.services.qconnect.model.CreateQuickResponseRequest
import aws.sdk.kotlin.services.qconnect.model.CreateQuickResponseResponse
import aws.sdk.kotlin.services.qconnect.model.CreateSessionRequest
import aws.sdk.kotlin.services.qconnect.model.CreateSessionResponse
import aws.sdk.kotlin.services.qconnect.model.DeactivateMessageTemplateRequest
import aws.sdk.kotlin.services.qconnect.model.DeactivateMessageTemplateResponse
import aws.sdk.kotlin.services.qconnect.model.DeleteAiAgentRequest
import aws.sdk.kotlin.services.qconnect.model.DeleteAiAgentResponse
import aws.sdk.kotlin.services.qconnect.model.DeleteAiAgentVersionRequest
import aws.sdk.kotlin.services.qconnect.model.DeleteAiAgentVersionResponse
import aws.sdk.kotlin.services.qconnect.model.DeleteAiGuardrailRequest
import aws.sdk.kotlin.services.qconnect.model.DeleteAiGuardrailResponse
import aws.sdk.kotlin.services.qconnect.model.DeleteAiGuardrailVersionRequest
import aws.sdk.kotlin.services.qconnect.model.DeleteAiGuardrailVersionResponse
import aws.sdk.kotlin.services.qconnect.model.DeleteAiPromptRequest
import aws.sdk.kotlin.services.qconnect.model.DeleteAiPromptResponse
import aws.sdk.kotlin.services.qconnect.model.DeleteAiPromptVersionRequest
import aws.sdk.kotlin.services.qconnect.model.DeleteAiPromptVersionResponse
import aws.sdk.kotlin.services.qconnect.model.DeleteAssistantAssociationRequest
import aws.sdk.kotlin.services.qconnect.model.DeleteAssistantAssociationResponse
import aws.sdk.kotlin.services.qconnect.model.DeleteAssistantRequest
import aws.sdk.kotlin.services.qconnect.model.DeleteAssistantResponse
import aws.sdk.kotlin.services.qconnect.model.DeleteContentAssociationRequest
import aws.sdk.kotlin.services.qconnect.model.DeleteContentAssociationResponse
import aws.sdk.kotlin.services.qconnect.model.DeleteContentRequest
import aws.sdk.kotlin.services.qconnect.model.DeleteContentResponse
import aws.sdk.kotlin.services.qconnect.model.DeleteImportJobRequest
import aws.sdk.kotlin.services.qconnect.model.DeleteImportJobResponse
import aws.sdk.kotlin.services.qconnect.model.DeleteKnowledgeBaseRequest
import aws.sdk.kotlin.services.qconnect.model.DeleteKnowledgeBaseResponse
import aws.sdk.kotlin.services.qconnect.model.DeleteMessageTemplateAttachmentRequest
import aws.sdk.kotlin.services.qconnect.model.DeleteMessageTemplateAttachmentResponse
import aws.sdk.kotlin.services.qconnect.model.DeleteMessageTemplateRequest
import aws.sdk.kotlin.services.qconnect.model.DeleteMessageTemplateResponse
import aws.sdk.kotlin.services.qconnect.model.DeleteQuickResponseRequest
import aws.sdk.kotlin.services.qconnect.model.DeleteQuickResponseResponse
import aws.sdk.kotlin.services.qconnect.model.GetAiAgentRequest
import aws.sdk.kotlin.services.qconnect.model.GetAiAgentResponse
import aws.sdk.kotlin.services.qconnect.model.GetAiGuardrailRequest
import aws.sdk.kotlin.services.qconnect.model.GetAiGuardrailResponse
import aws.sdk.kotlin.services.qconnect.model.GetAiPromptRequest
import aws.sdk.kotlin.services.qconnect.model.GetAiPromptResponse
import aws.sdk.kotlin.services.qconnect.model.GetAssistantAssociationRequest
import aws.sdk.kotlin.services.qconnect.model.GetAssistantAssociationResponse
import aws.sdk.kotlin.services.qconnect.model.GetAssistantRequest
import aws.sdk.kotlin.services.qconnect.model.GetAssistantResponse
import aws.sdk.kotlin.services.qconnect.model.GetContentAssociationRequest
import aws.sdk.kotlin.services.qconnect.model.GetContentAssociationResponse
import aws.sdk.kotlin.services.qconnect.model.GetContentRequest
import aws.sdk.kotlin.services.qconnect.model.GetContentResponse
import aws.sdk.kotlin.services.qconnect.model.GetContentSummaryRequest
import aws.sdk.kotlin.services.qconnect.model.GetContentSummaryResponse
import aws.sdk.kotlin.services.qconnect.model.GetImportJobRequest
import aws.sdk.kotlin.services.qconnect.model.GetImportJobResponse
import aws.sdk.kotlin.services.qconnect.model.GetKnowledgeBaseRequest
import aws.sdk.kotlin.services.qconnect.model.GetKnowledgeBaseResponse
import aws.sdk.kotlin.services.qconnect.model.GetMessageTemplateRequest
import aws.sdk.kotlin.services.qconnect.model.GetMessageTemplateResponse
import aws.sdk.kotlin.services.qconnect.model.GetNextMessageRequest
import aws.sdk.kotlin.services.qconnect.model.GetNextMessageResponse
import aws.sdk.kotlin.services.qconnect.model.GetQuickResponseRequest
import aws.sdk.kotlin.services.qconnect.model.GetQuickResponseResponse
import aws.sdk.kotlin.services.qconnect.model.GetRecommendationsRequest
import aws.sdk.kotlin.services.qconnect.model.GetRecommendationsResponse
import aws.sdk.kotlin.services.qconnect.model.GetSessionRequest
import aws.sdk.kotlin.services.qconnect.model.GetSessionResponse
import aws.sdk.kotlin.services.qconnect.model.ListAiAgentVersionsRequest
import aws.sdk.kotlin.services.qconnect.model.ListAiAgentVersionsResponse
import aws.sdk.kotlin.services.qconnect.model.ListAiAgentsRequest
import aws.sdk.kotlin.services.qconnect.model.ListAiAgentsResponse
import aws.sdk.kotlin.services.qconnect.model.ListAiGuardrailVersionsRequest
import aws.sdk.kotlin.services.qconnect.model.ListAiGuardrailVersionsResponse
import aws.sdk.kotlin.services.qconnect.model.ListAiGuardrailsRequest
import aws.sdk.kotlin.services.qconnect.model.ListAiGuardrailsResponse
import aws.sdk.kotlin.services.qconnect.model.ListAiPromptVersionsRequest
import aws.sdk.kotlin.services.qconnect.model.ListAiPromptVersionsResponse
import aws.sdk.kotlin.services.qconnect.model.ListAiPromptsRequest
import aws.sdk.kotlin.services.qconnect.model.ListAiPromptsResponse
import aws.sdk.kotlin.services.qconnect.model.ListAssistantAssociationsRequest
import aws.sdk.kotlin.services.qconnect.model.ListAssistantAssociationsResponse
import aws.sdk.kotlin.services.qconnect.model.ListAssistantsRequest
import aws.sdk.kotlin.services.qconnect.model.ListAssistantsResponse
import aws.sdk.kotlin.services.qconnect.model.ListContentAssociationsRequest
import aws.sdk.kotlin.services.qconnect.model.ListContentAssociationsResponse
import aws.sdk.kotlin.services.qconnect.model.ListContentsRequest
import aws.sdk.kotlin.services.qconnect.model.ListContentsResponse
import aws.sdk.kotlin.services.qconnect.model.ListImportJobsRequest
import aws.sdk.kotlin.services.qconnect.model.ListImportJobsResponse
import aws.sdk.kotlin.services.qconnect.model.ListKnowledgeBasesRequest
import aws.sdk.kotlin.services.qconnect.model.ListKnowledgeBasesResponse
import aws.sdk.kotlin.services.qconnect.model.ListMessageTemplateVersionsRequest
import aws.sdk.kotlin.services.qconnect.model.ListMessageTemplateVersionsResponse
import aws.sdk.kotlin.services.qconnect.model.ListMessageTemplatesRequest
import aws.sdk.kotlin.services.qconnect.model.ListMessageTemplatesResponse
import aws.sdk.kotlin.services.qconnect.model.ListMessagesRequest
import aws.sdk.kotlin.services.qconnect.model.ListMessagesResponse
import aws.sdk.kotlin.services.qconnect.model.ListQuickResponsesRequest
import aws.sdk.kotlin.services.qconnect.model.ListQuickResponsesResponse
import aws.sdk.kotlin.services.qconnect.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.qconnect.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.qconnect.model.NotifyRecommendationsReceivedRequest
import aws.sdk.kotlin.services.qconnect.model.NotifyRecommendationsReceivedResponse
import aws.sdk.kotlin.services.qconnect.model.PutFeedbackRequest
import aws.sdk.kotlin.services.qconnect.model.PutFeedbackResponse
import aws.sdk.kotlin.services.qconnect.model.QueryAssistantRequest
import aws.sdk.kotlin.services.qconnect.model.QueryAssistantResponse
import aws.sdk.kotlin.services.qconnect.model.RemoveAssistantAiAgentRequest
import aws.sdk.kotlin.services.qconnect.model.RemoveAssistantAiAgentResponse
import aws.sdk.kotlin.services.qconnect.model.RemoveKnowledgeBaseTemplateUriRequest
import aws.sdk.kotlin.services.qconnect.model.RemoveKnowledgeBaseTemplateUriResponse
import aws.sdk.kotlin.services.qconnect.model.RenderMessageTemplateRequest
import aws.sdk.kotlin.services.qconnect.model.RenderMessageTemplateResponse
import aws.sdk.kotlin.services.qconnect.model.SearchContentRequest
import aws.sdk.kotlin.services.qconnect.model.SearchContentResponse
import aws.sdk.kotlin.services.qconnect.model.SearchMessageTemplatesRequest
import aws.sdk.kotlin.services.qconnect.model.SearchMessageTemplatesResponse
import aws.sdk.kotlin.services.qconnect.model.SearchQuickResponsesRequest
import aws.sdk.kotlin.services.qconnect.model.SearchQuickResponsesResponse
import aws.sdk.kotlin.services.qconnect.model.SearchSessionsRequest
import aws.sdk.kotlin.services.qconnect.model.SearchSessionsResponse
import aws.sdk.kotlin.services.qconnect.model.SendMessageRequest
import aws.sdk.kotlin.services.qconnect.model.SendMessageResponse
import aws.sdk.kotlin.services.qconnect.model.StartContentUploadRequest
import aws.sdk.kotlin.services.qconnect.model.StartContentUploadResponse
import aws.sdk.kotlin.services.qconnect.model.StartImportJobRequest
import aws.sdk.kotlin.services.qconnect.model.StartImportJobResponse
import aws.sdk.kotlin.services.qconnect.model.TagResourceRequest
import aws.sdk.kotlin.services.qconnect.model.TagResourceResponse
import aws.sdk.kotlin.services.qconnect.model.UntagResourceRequest
import aws.sdk.kotlin.services.qconnect.model.UntagResourceResponse
import aws.sdk.kotlin.services.qconnect.model.UpdateAiAgentRequest
import aws.sdk.kotlin.services.qconnect.model.UpdateAiAgentResponse
import aws.sdk.kotlin.services.qconnect.model.UpdateAiGuardrailRequest
import aws.sdk.kotlin.services.qconnect.model.UpdateAiGuardrailResponse
import aws.sdk.kotlin.services.qconnect.model.UpdateAiPromptRequest
import aws.sdk.kotlin.services.qconnect.model.UpdateAiPromptResponse
import aws.sdk.kotlin.services.qconnect.model.UpdateAssistantAiAgentRequest
import aws.sdk.kotlin.services.qconnect.model.UpdateAssistantAiAgentResponse
import aws.sdk.kotlin.services.qconnect.model.UpdateContentRequest
import aws.sdk.kotlin.services.qconnect.model.UpdateContentResponse
import aws.sdk.kotlin.services.qconnect.model.UpdateKnowledgeBaseTemplateUriRequest
import aws.sdk.kotlin.services.qconnect.model.UpdateKnowledgeBaseTemplateUriResponse
import aws.sdk.kotlin.services.qconnect.model.UpdateMessageTemplateMetadataRequest
import aws.sdk.kotlin.services.qconnect.model.UpdateMessageTemplateMetadataResponse
import aws.sdk.kotlin.services.qconnect.model.UpdateMessageTemplateRequest
import aws.sdk.kotlin.services.qconnect.model.UpdateMessageTemplateResponse
import aws.sdk.kotlin.services.qconnect.model.UpdateQuickResponseRequest
import aws.sdk.kotlin.services.qconnect.model.UpdateQuickResponseResponse
import aws.sdk.kotlin.services.qconnect.model.UpdateSessionDataRequest
import aws.sdk.kotlin.services.qconnect.model.UpdateSessionDataResponse
import aws.sdk.kotlin.services.qconnect.model.UpdateSessionRequest
import aws.sdk.kotlin.services.qconnect.model.UpdateSessionResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "QConnect"
public const val SdkVersion: String = "1.5.4"
public const val ServiceApiVersion: String = "2020-10-19"

/**
 * + [Amazon Q actions](https://docs.aws.amazon.com/connect/latest/APIReference/API_Operations_Amazon_Q_Connect.html)
 * + [Amazon Q data types](https://docs.aws.amazon.com/connect/latest/APIReference/API_Types_Amazon_Q_Connect.html)
 *
 * **Powered by Amazon Bedrock**: Amazon Web Services implements [automated abuse detection](https://docs.aws.amazon.com/bedrock/latest/userguide/abuse-detection.html). Because Amazon Q in Connect is built on Amazon Bedrock, users can take full advantage of the controls implemented in Amazon Bedrock to enforce safety, security, and the responsible use of artificial intelligence (AI).
 *
 * Amazon Q in Connect is a generative AI customer service assistant. It is an LLM-enhanced evolution of Amazon Connect Wisdom that delivers real-time recommendations to help contact center agents resolve customer issues quickly and accurately.
 *
 * Amazon Q in Connect automatically detects customer intent during calls and chats using conversational analytics and natural language understanding (NLU). It then provides agents with immediate, real-time generative responses and suggested actions, and links to relevant documents and articles. Agents can also query Amazon Q in Connect directly using natural language or keywords to answer customer requests.
 *
 * Use the Amazon Q in Connect APIs to create an assistant and a knowledge base, for example, or manage content by uploading custom files.
 *
 * For more information, see [Use Amazon Q in Connect for generative AI powered agent assistance in real-time](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-q-connect.html) in the *Amazon Connect Administrator Guide*.
 */
public interface QConnectClient : SdkClient {
    /**
     * QConnectClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, QConnectClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "QConnect",
                "QCONNECT",
                "qconnect",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, QConnectClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): QConnectClient = DefaultQConnectClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: QConnectEndpointProvider = builder.endpointProvider ?: DefaultQConnectEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: QConnectAuthSchemeProvider = builder.authSchemeProvider ?: DefaultQConnectAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "QConnect"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: QConnectEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: QConnectAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Activates a specific version of the Amazon Q in Connect message template. After the version is activated, the previous active version will be deactivated automatically. You can use the `$ACTIVE_VERSION` qualifier later to reference the version that is in active status.
     */
    public suspend fun activateMessageTemplate(input: ActivateMessageTemplateRequest): ActivateMessageTemplateResponse

    /**
     * Creates an Amazon Q in Connect AI Agent.
     */
    public suspend fun createAiAgent(input: CreateAiAgentRequest): CreateAiAgentResponse

    /**
     * Creates and Amazon Q in Connect AI Agent version.
     */
    public suspend fun createAiAgentVersion(input: CreateAiAgentVersionRequest): CreateAiAgentVersionResponse

    /**
     * Creates an Amazon Q in Connect AI Guardrail.
     */
    public suspend fun createAiGuardrail(input: CreateAiGuardrailRequest): CreateAiGuardrailResponse

    /**
     * Creates an Amazon Q in Connect AI Guardrail version.
     */
    public suspend fun createAiGuardrailVersion(input: CreateAiGuardrailVersionRequest): CreateAiGuardrailVersionResponse

    /**
     * Creates an Amazon Q in Connect AI Prompt.
     */
    public suspend fun createAiPrompt(input: CreateAiPromptRequest): CreateAiPromptResponse

    /**
     * Creates an Amazon Q in Connect AI Prompt version.
     */
    public suspend fun createAiPromptVersion(input: CreateAiPromptVersionRequest): CreateAiPromptVersionResponse

    /**
     * Creates an Amazon Q in Connect assistant.
     */
    public suspend fun createAssistant(input: CreateAssistantRequest): CreateAssistantResponse

    /**
     * Creates an association between an Amazon Q in Connect assistant and another resource. Currently, the only supported association is with a knowledge base. An assistant can have only a single association.
     */
    public suspend fun createAssistantAssociation(input: CreateAssistantAssociationRequest): CreateAssistantAssociationResponse

    /**
     * Creates Amazon Q in Connect content. Before to calling this API, use [StartContentUpload](https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_StartContentUpload.html) to upload an asset.
     */
    public suspend fun createContent(input: CreateContentRequest): CreateContentResponse

    /**
     * Creates an association between a content resource in a knowledge base and [step-by-step guides](https://docs.aws.amazon.com/connect/latest/adminguide/step-by-step-guided-experiences.html). Step-by-step guides offer instructions to agents for resolving common customer issues. You create a content association to integrate Amazon Q in Connect and step-by-step guides.
     *
     * After you integrate Amazon Q and step-by-step guides, when Amazon Q provides a recommendation to an agent based on the intent that it's detected, it also provides them with the option to start the step-by-step guide that you have associated with the content.
     *
     * Note the following limitations:
     * + You can create only one content association for each content resource in a knowledge base.
     * + You can associate a step-by-step guide with multiple content resources.
     *
     * For more information, see [Integrate Amazon Q in Connect with step-by-step guides](https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html) in the *Amazon Connect Administrator Guide*.
     */
    public suspend fun createContentAssociation(input: CreateContentAssociationRequest): CreateContentAssociationResponse

    /**
     * Creates a knowledge base.
     *
     * When using this API, you cannot reuse [Amazon AppIntegrations](https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html) DataIntegrations with external knowledge bases such as Salesforce and ServiceNow. If you do, you'll get an `InvalidRequestException` error.
     *
     * For example, you're programmatically managing your external knowledge base, and you want to add or remove one of the fields that is being ingested from Salesforce. Do the following:
     * + Call [DeleteKnowledgeBase](https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_DeleteKnowledgeBase.html).
     * + Call [DeleteDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html).
     * + Call [CreateDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html) to recreate the DataIntegration or a create different one.
     * + Call CreateKnowledgeBase.
     */
    public suspend fun createKnowledgeBase(input: CreateKnowledgeBaseRequest): CreateKnowledgeBaseResponse

    /**
     * Creates an Amazon Q in Connect message template. The name of the message template has to be unique for each knowledge base. The channel subtype of the message template is immutable and cannot be modified after creation. After the message template is created, you can use the `$LATEST` qualifier to reference the created message template.
     */
    public suspend fun createMessageTemplate(input: CreateMessageTemplateRequest): CreateMessageTemplateResponse

    /**
     * Uploads an attachment file to the specified Amazon Q in Connect message template. The name of the message template attachment has to be unique for each message template referenced by the `$LATEST` qualifier. The body of the attachment file should be encoded using base64 encoding. After the file is uploaded, you can use the pre-signed Amazon S3 URL returned in response to download the uploaded file.
     */
    public suspend fun createMessageTemplateAttachment(input: CreateMessageTemplateAttachmentRequest): CreateMessageTemplateAttachmentResponse

    /**
     * Creates a new Amazon Q in Connect message template version from the current content and configuration of a message template. Versions are immutable and monotonically increasing. Once a version is created, you can reference a specific version of the message template by passing in `&lt;message-template-id&gt;:&lt;versionNumber&gt;` as the message template identifier. An error is displayed if the supplied `messageTemplateContentSha256` is different from the `messageTemplateContentSha256` of the message template with `$LATEST` qualifier. If multiple `CreateMessageTemplateVersion` requests are made while the message template remains the same, only the first invocation creates a new version and the succeeding requests will return the same response as the first invocation.
     */
    public suspend fun createMessageTemplateVersion(input: CreateMessageTemplateVersionRequest): CreateMessageTemplateVersionResponse

    /**
     * Creates an Amazon Q in Connect quick response.
     */
    public suspend fun createQuickResponse(input: CreateQuickResponseRequest): CreateQuickResponseResponse

    /**
     * Creates a session. A session is a contextual container used for generating recommendations. Amazon Connect creates a new Amazon Q in Connect session for each contact on which Amazon Q in Connect is enabled.
     */
    public suspend fun createSession(input: CreateSessionRequest): CreateSessionResponse

    /**
     * Deactivates a specific version of the Amazon Q in Connect message template . After the version is deactivated, you can no longer use the `$ACTIVE_VERSION` qualifier to reference the version in active status.
     */
    public suspend fun deactivateMessageTemplate(input: DeactivateMessageTemplateRequest): DeactivateMessageTemplateResponse

    /**
     * Deletes an Amazon Q in Connect AI Agent.
     */
    public suspend fun deleteAiAgent(input: DeleteAiAgentRequest): DeleteAiAgentResponse

    /**
     * Deletes an Amazon Q in Connect AI Agent Version.
     */
    public suspend fun deleteAiAgentVersion(input: DeleteAiAgentVersionRequest): DeleteAiAgentVersionResponse

    /**
     * Deletes an Amazon Q in Connect AI Guardrail.
     */
    public suspend fun deleteAiGuardrail(input: DeleteAiGuardrailRequest): DeleteAiGuardrailResponse

    /**
     * Delete and Amazon Q in Connect AI Guardrail version.
     */
    public suspend fun deleteAiGuardrailVersion(input: DeleteAiGuardrailVersionRequest): DeleteAiGuardrailVersionResponse

    /**
     * Deletes an Amazon Q in Connect AI Prompt.
     */
    public suspend fun deleteAiPrompt(input: DeleteAiPromptRequest): DeleteAiPromptResponse

    /**
     * Delete and Amazon Q in Connect AI Prompt version.
     */
    public suspend fun deleteAiPromptVersion(input: DeleteAiPromptVersionRequest): DeleteAiPromptVersionResponse

    /**
     * Deletes an assistant.
     */
    public suspend fun deleteAssistant(input: DeleteAssistantRequest): DeleteAssistantResponse

    /**
     * Deletes an assistant association.
     */
    public suspend fun deleteAssistantAssociation(input: DeleteAssistantAssociationRequest): DeleteAssistantAssociationResponse

    /**
     * Deletes the content.
     */
    public suspend fun deleteContent(input: DeleteContentRequest): DeleteContentResponse

    /**
     * Deletes the content association.
     *
     * For more information about content associations--what they are and when they are used--see [Integrate Amazon Q in Connect with step-by-step guides](https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html) in the *Amazon Connect Administrator Guide*.
     */
    public suspend fun deleteContentAssociation(input: DeleteContentAssociationRequest): DeleteContentAssociationResponse

    /**
     * Deletes the quick response import job.
     */
    public suspend fun deleteImportJob(input: DeleteImportJobRequest): DeleteImportJobResponse

    /**
     * Deletes the knowledge base.
     *
     * When you use this API to delete an external knowledge base such as Salesforce or ServiceNow, you must also delete the [Amazon AppIntegrations](https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html) DataIntegration. This is because you can't reuse the DataIntegration after it's been associated with an external knowledge base. However, you can delete and recreate it. See [DeleteDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html) and [CreateDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html) in the *Amazon AppIntegrations API Reference*.
     */
    public suspend fun deleteKnowledgeBase(input: DeleteKnowledgeBaseRequest): DeleteKnowledgeBaseResponse

    /**
     * Deletes an Amazon Q in Connect message template entirely or a specific version of the message template if version is supplied in the request. You can provide the message template identifier as `&lt;message-template-id&gt;:&lt;versionNumber&gt;` to delete a specific version of the message template. If it is not supplied, the message template and all available versions will be deleted.
     */
    public suspend fun deleteMessageTemplate(input: DeleteMessageTemplateRequest): DeleteMessageTemplateResponse

    /**
     * Deletes the attachment file from the Amazon Q in Connect message template that is referenced by `$LATEST` qualifier. Attachments on available message template versions will remain unchanged.
     */
    public suspend fun deleteMessageTemplateAttachment(input: DeleteMessageTemplateAttachmentRequest): DeleteMessageTemplateAttachmentResponse

    /**
     * Deletes a quick response.
     */
    public suspend fun deleteQuickResponse(input: DeleteQuickResponseRequest): DeleteQuickResponseResponse

    /**
     * Gets an Amazon Q in Connect AI Agent.
     */
    public suspend fun getAiAgent(input: GetAiAgentRequest): GetAiAgentResponse

    /**
     * Gets the Amazon Q in Connect AI Guardrail.
     */
    public suspend fun getAiGuardrail(input: GetAiGuardrailRequest): GetAiGuardrailResponse

    /**
     * Gets and Amazon Q in Connect AI Prompt.
     */
    public suspend fun getAiPrompt(input: GetAiPromptRequest): GetAiPromptResponse

    /**
     * Retrieves information about an assistant.
     */
    public suspend fun getAssistant(input: GetAssistantRequest): GetAssistantResponse

    /**
     * Retrieves information about an assistant association.
     */
    public suspend fun getAssistantAssociation(input: GetAssistantAssociationRequest): GetAssistantAssociationResponse

    /**
     * Retrieves content, including a pre-signed URL to download the content.
     */
    public suspend fun getContent(input: GetContentRequest): GetContentResponse

    /**
     * Returns the content association.
     *
     * For more information about content associations--what they are and when they are used--see [Integrate Amazon Q in Connect with step-by-step guides](https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html) in the *Amazon Connect Administrator Guide*.
     */
    public suspend fun getContentAssociation(input: GetContentAssociationRequest): GetContentAssociationResponse

    /**
     * Retrieves summary information about the content.
     */
    public suspend fun getContentSummary(input: GetContentSummaryRequest): GetContentSummaryResponse

    /**
     * Retrieves the started import job.
     */
    public suspend fun getImportJob(input: GetImportJobRequest): GetImportJobResponse

    /**
     * Retrieves information about the knowledge base.
     */
    public suspend fun getKnowledgeBase(input: GetKnowledgeBaseRequest): GetKnowledgeBaseResponse

    /**
     * Retrieves the Amazon Q in Connect message template. The message template identifier can contain an optional qualifier, for example, `&lt;message-template-id&gt;:&lt;qualifier&gt;`, which is either an actual version number or an Amazon Q Connect managed qualifier `$ACTIVE_VERSION` | `$LATEST`. If it is not supplied, then `$LATEST` is assumed implicitly.
     */
    public suspend fun getMessageTemplate(input: GetMessageTemplateRequest): GetMessageTemplateResponse

    /**
     * Retrieves next message on an Amazon Q in Connect session.
     */
    public suspend fun getNextMessage(input: GetNextMessageRequest): GetNextMessageResponse

    /**
     * Retrieves the quick response.
     */
    public suspend fun getQuickResponse(input: GetQuickResponseRequest): GetQuickResponseResponse

    /**
     * This API will be discontinued starting June 1, 2024. To receive generative responses after March 1, 2024, you will need to create a new Assistant in the Amazon Connect console and integrate the Amazon Q in Connect JavaScript library (amazon-q-connectjs) into your applications.
     *
     * Retrieves recommendations for the specified session. To avoid retrieving the same recommendations in subsequent calls, use [NotifyRecommendationsReceived](https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_NotifyRecommendationsReceived.html). This API supports long-polling behavior with the `waitTimeSeconds` parameter. Short poll is the default behavior and only returns recommendations already available. To perform a manual query against an assistant, use [QueryAssistant](https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_QueryAssistant.html).
     */
    @Deprecated("GetRecommendations API will be discontinued starting June 1, 2024. To receive generative responses after March 1, 2024 you will need to create a new Assistant in the Connect console and integrate the Amazon Q in Connect JavaScript library (amazon-q-connectjs) into your applications.")
    public suspend fun getRecommendations(input: GetRecommendationsRequest): GetRecommendationsResponse

    /**
     * Retrieves information for a specified session.
     */
    public suspend fun getSession(input: GetSessionRequest): GetSessionResponse

    /**
     * List AI Agent versions.
     */
    public suspend fun listAiAgentVersions(input: ListAiAgentVersionsRequest): ListAiAgentVersionsResponse

    /**
     * Lists AI Agents.
     */
    public suspend fun listAiAgents(input: ListAiAgentsRequest): ListAiAgentsResponse

    /**
     * Lists AI Guardrail versions.
     */
    public suspend fun listAiGuardrailVersions(input: ListAiGuardrailVersionsRequest): ListAiGuardrailVersionsResponse

    /**
     * Lists the AI Guardrails available on the Amazon Q in Connect assistant.
     */
    public suspend fun listAiGuardrails(input: ListAiGuardrailsRequest): ListAiGuardrailsResponse

    /**
     * Lists AI Prompt versions.
     */
    public suspend fun listAiPromptVersions(input: ListAiPromptVersionsRequest): ListAiPromptVersionsResponse

    /**
     * Lists the AI Prompts available on the Amazon Q in Connect assistant.
     */
    public suspend fun listAiPrompts(input: ListAiPromptsRequest): ListAiPromptsResponse

    /**
     * Lists information about assistant associations.
     */
    public suspend fun listAssistantAssociations(input: ListAssistantAssociationsRequest): ListAssistantAssociationsResponse

    /**
     * Lists information about assistants.
     */
    public suspend fun listAssistants(input: ListAssistantsRequest = ListAssistantsRequest { }): ListAssistantsResponse

    /**
     * Lists the content associations.
     *
     * For more information about content associations--what they are and when they are used--see [Integrate Amazon Q in Connect with step-by-step guides](https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html) in the *Amazon Connect Administrator Guide*.
     */
    public suspend fun listContentAssociations(input: ListContentAssociationsRequest): ListContentAssociationsResponse

    /**
     * Lists the content.
     */
    public suspend fun listContents(input: ListContentsRequest): ListContentsResponse

    /**
     * Lists information about import jobs.
     */
    public suspend fun listImportJobs(input: ListImportJobsRequest): ListImportJobsResponse

    /**
     * Lists the knowledge bases.
     */
    public suspend fun listKnowledgeBases(input: ListKnowledgeBasesRequest = ListKnowledgeBasesRequest { }): ListKnowledgeBasesResponse

    /**
     * Lists all the available versions for the specified Amazon Q in Connect message template.
     */
    public suspend fun listMessageTemplateVersions(input: ListMessageTemplateVersionsRequest): ListMessageTemplateVersionsResponse

    /**
     * Lists all the available Amazon Q in Connect message templates for the specified knowledge base.
     */
    public suspend fun listMessageTemplates(input: ListMessageTemplatesRequest): ListMessageTemplatesResponse

    /**
     * Lists messages on an Amazon Q in Connect session.
     */
    public suspend fun listMessages(input: ListMessagesRequest): ListMessagesResponse

    /**
     * Lists information about quick response.
     */
    public suspend fun listQuickResponses(input: ListQuickResponsesRequest): ListQuickResponsesResponse

    /**
     * Lists the tags for the specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Removes the specified recommendations from the specified assistant's queue of newly available recommendations. You can use this API in conjunction with [GetRecommendations](https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_GetRecommendations.html) and a `waitTimeSeconds` input for long-polling behavior and avoiding duplicate recommendations.
     */
    public suspend fun notifyRecommendationsReceived(input: NotifyRecommendationsReceivedRequest): NotifyRecommendationsReceivedResponse

    /**
     * Provides feedback against the specified assistant for the specified target. This API only supports generative targets.
     */
    public suspend fun putFeedback(input: PutFeedbackRequest): PutFeedbackResponse

    /**
     * This API will be discontinued starting June 1, 2024. To receive generative responses after March 1, 2024, you will need to create a new Assistant in the Amazon Connect console and integrate the Amazon Q in Connect JavaScript library (amazon-q-connectjs) into your applications.
     *
     * Performs a manual search against the specified assistant. To retrieve recommendations for an assistant, use [GetRecommendations](https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_GetRecommendations.html).
     */
    @Deprecated("QueryAssistant API will be discontinued starting June 1, 2024. To receive generative responses after March 1, 2024 you will need to create a new Assistant in the Connect console and integrate the Amazon Q in Connect JavaScript library (amazon-q-connectjs) into your applications.")
    public suspend fun queryAssistant(input: QueryAssistantRequest): QueryAssistantResponse

    /**
     * Removes the AI Agent that is set for use by default on an Amazon Q in Connect Assistant.
     */
    public suspend fun removeAssistantAiAgent(input: RemoveAssistantAiAgentRequest): RemoveAssistantAiAgentResponse

    /**
     * Removes a URI template from a knowledge base.
     */
    public suspend fun removeKnowledgeBaseTemplateUri(input: RemoveKnowledgeBaseTemplateUriRequest): RemoveKnowledgeBaseTemplateUriResponse

    /**
     * Renders the Amazon Q in Connect message template based on the attribute values provided and generates the message content. For any variable present in the message template, if the attribute value is neither provided in the attribute request parameter nor the default attribute of the message template, the rendered message content will keep the variable placeholder as it is and return the attribute keys that are missing.
     */
    public suspend fun renderMessageTemplate(input: RenderMessageTemplateRequest): RenderMessageTemplateResponse

    /**
     * Searches for content in a specified knowledge base. Can be used to get a specific content resource by its name.
     */
    public suspend fun searchContent(input: SearchContentRequest): SearchContentResponse

    /**
     * Searches for Amazon Q in Connect message templates in the specified knowledge base.
     */
    public suspend fun searchMessageTemplates(input: SearchMessageTemplatesRequest): SearchMessageTemplatesResponse

    /**
     * Searches existing Amazon Q in Connect quick responses in an Amazon Q in Connect knowledge base.
     */
    public suspend fun searchQuickResponses(input: SearchQuickResponsesRequest): SearchQuickResponsesResponse

    /**
     * Searches for sessions.
     */
    public suspend fun searchSessions(input: SearchSessionsRequest): SearchSessionsResponse

    /**
     * Submits a message to the Amazon Q in Connect session.
     */
    public suspend fun sendMessage(input: SendMessageRequest): SendMessageResponse

    /**
     * Get a URL to upload content to a knowledge base. To upload content, first make a PUT request to the returned URL with your file, making sure to include the required headers. Then use [CreateContent](https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_CreateContent.html) to finalize the content creation process or [UpdateContent](https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_UpdateContent.html) to modify an existing resource. You can only upload content to a knowledge base of type CUSTOM.
     */
    public suspend fun startContentUpload(input: StartContentUploadRequest): StartContentUploadResponse

    /**
     * Start an asynchronous job to import Amazon Q in Connect resources from an uploaded source file. Before calling this API, use [StartContentUpload](https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html) to upload an asset that contains the resource data.
     * + For importing Amazon Q in Connect quick responses, you need to upload a csv file including the quick responses. For information about how to format the csv file for importing quick responses, see [Import quick responses](https://docs.aws.amazon.com/console/connect/quick-responses/add-data).
     */
    public suspend fun startImportJob(input: StartImportJobRequest): StartImportJobResponse

    /**
     * Adds the specified tags to the specified resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the specified tags from the specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an AI Agent.
     */
    public suspend fun updateAiAgent(input: UpdateAiAgentRequest): UpdateAiAgentResponse

    /**
     * Updates an AI Guardrail.
     */
    public suspend fun updateAiGuardrail(input: UpdateAiGuardrailRequest): UpdateAiGuardrailResponse

    /**
     * Updates an AI Prompt.
     */
    public suspend fun updateAiPrompt(input: UpdateAiPromptRequest): UpdateAiPromptResponse

    /**
     * Updates the AI Agent that is set for use by default on an Amazon Q in Connect Assistant.
     */
    public suspend fun updateAssistantAiAgent(input: UpdateAssistantAiAgentRequest): UpdateAssistantAiAgentResponse

    /**
     * Updates information about the content.
     */
    public suspend fun updateContent(input: UpdateContentRequest): UpdateContentResponse

    /**
     * Updates the template URI of a knowledge base. This is only supported for knowledge bases of type EXTERNAL. Include a single variable in `${variable}` format; this interpolated by Amazon Q in Connect using ingested content. For example, if you ingest a Salesforce article, it has an `Id` value, and you can set the template URI to `https://myInstanceName.lightning.force.com/lightning/r/Knowledge__kav&#47;*${Id}*&#47;view`.
     */
    public suspend fun updateKnowledgeBaseTemplateUri(input: UpdateKnowledgeBaseTemplateUriRequest): UpdateKnowledgeBaseTemplateUriResponse

    /**
     * Updates the Amazon Q in Connect message template. Partial update is supported. If any field is not supplied, it will remain unchanged for the message template that is referenced by the `$LATEST` qualifier. Any modification will only apply to the message template that is referenced by the `$LATEST` qualifier. The fields for all available versions will remain unchanged.
     */
    public suspend fun updateMessageTemplate(input: UpdateMessageTemplateRequest): UpdateMessageTemplateResponse

    /**
     * Updates the Amazon Q in Connect message template metadata. Note that any modification to the message template’s name, description and grouping configuration will applied to the message template pointed by the `$LATEST` qualifier and all available versions. Partial update is supported. If any field is not supplied, it will remain unchanged for the message template.
     */
    public suspend fun updateMessageTemplateMetadata(input: UpdateMessageTemplateMetadataRequest): UpdateMessageTemplateMetadataResponse

    /**
     * Updates an existing Amazon Q in Connect quick response.
     */
    public suspend fun updateQuickResponse(input: UpdateQuickResponseRequest): UpdateQuickResponseResponse

    /**
     * Updates a session. A session is a contextual container used for generating recommendations. Amazon Connect updates the existing Amazon Q in Connect session for each contact on which Amazon Q in Connect is enabled.
     */
    public suspend fun updateSession(input: UpdateSessionRequest): UpdateSessionResponse

    /**
     * Updates the data stored on an Amazon Q in Connect Session.
     */
    public suspend fun updateSessionData(input: UpdateSessionDataRequest): UpdateSessionDataResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun QConnectClient.withConfig(block: QConnectClient.Config.Builder.() -> Unit): QConnectClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultQConnectClient(newConfig)
}

/**
 * Activates a specific version of the Amazon Q in Connect message template. After the version is activated, the previous active version will be deactivated automatically. You can use the `$ACTIVE_VERSION` qualifier later to reference the version that is in active status.
 */
public suspend inline fun QConnectClient.activateMessageTemplate(crossinline block: ActivateMessageTemplateRequest.Builder.() -> Unit): ActivateMessageTemplateResponse = activateMessageTemplate(ActivateMessageTemplateRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Q in Connect AI Agent.
 */
public suspend inline fun QConnectClient.createAiAgent(crossinline block: CreateAiAgentRequest.Builder.() -> Unit): CreateAiAgentResponse = createAiAgent(CreateAiAgentRequest.Builder().apply(block).build())

/**
 * Creates and Amazon Q in Connect AI Agent version.
 */
public suspend inline fun QConnectClient.createAiAgentVersion(crossinline block: CreateAiAgentVersionRequest.Builder.() -> Unit): CreateAiAgentVersionResponse = createAiAgentVersion(CreateAiAgentVersionRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Q in Connect AI Guardrail.
 */
public suspend inline fun QConnectClient.createAiGuardrail(crossinline block: CreateAiGuardrailRequest.Builder.() -> Unit): CreateAiGuardrailResponse = createAiGuardrail(CreateAiGuardrailRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Q in Connect AI Guardrail version.
 */
public suspend inline fun QConnectClient.createAiGuardrailVersion(crossinline block: CreateAiGuardrailVersionRequest.Builder.() -> Unit): CreateAiGuardrailVersionResponse = createAiGuardrailVersion(CreateAiGuardrailVersionRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Q in Connect AI Prompt.
 */
public suspend inline fun QConnectClient.createAiPrompt(crossinline block: CreateAiPromptRequest.Builder.() -> Unit): CreateAiPromptResponse = createAiPrompt(CreateAiPromptRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Q in Connect AI Prompt version.
 */
public suspend inline fun QConnectClient.createAiPromptVersion(crossinline block: CreateAiPromptVersionRequest.Builder.() -> Unit): CreateAiPromptVersionResponse = createAiPromptVersion(CreateAiPromptVersionRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Q in Connect assistant.
 */
public suspend inline fun QConnectClient.createAssistant(crossinline block: CreateAssistantRequest.Builder.() -> Unit): CreateAssistantResponse = createAssistant(CreateAssistantRequest.Builder().apply(block).build())

/**
 * Creates an association between an Amazon Q in Connect assistant and another resource. Currently, the only supported association is with a knowledge base. An assistant can have only a single association.
 */
public suspend inline fun QConnectClient.createAssistantAssociation(crossinline block: CreateAssistantAssociationRequest.Builder.() -> Unit): CreateAssistantAssociationResponse = createAssistantAssociation(CreateAssistantAssociationRequest.Builder().apply(block).build())

/**
 * Creates Amazon Q in Connect content. Before to calling this API, use [StartContentUpload](https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_StartContentUpload.html) to upload an asset.
 */
public suspend inline fun QConnectClient.createContent(crossinline block: CreateContentRequest.Builder.() -> Unit): CreateContentResponse = createContent(CreateContentRequest.Builder().apply(block).build())

/**
 * Creates an association between a content resource in a knowledge base and [step-by-step guides](https://docs.aws.amazon.com/connect/latest/adminguide/step-by-step-guided-experiences.html). Step-by-step guides offer instructions to agents for resolving common customer issues. You create a content association to integrate Amazon Q in Connect and step-by-step guides.
 *
 * After you integrate Amazon Q and step-by-step guides, when Amazon Q provides a recommendation to an agent based on the intent that it's detected, it also provides them with the option to start the step-by-step guide that you have associated with the content.
 *
 * Note the following limitations:
 * + You can create only one content association for each content resource in a knowledge base.
 * + You can associate a step-by-step guide with multiple content resources.
 *
 * For more information, see [Integrate Amazon Q in Connect with step-by-step guides](https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html) in the *Amazon Connect Administrator Guide*.
 */
public suspend inline fun QConnectClient.createContentAssociation(crossinline block: CreateContentAssociationRequest.Builder.() -> Unit): CreateContentAssociationResponse = createContentAssociation(CreateContentAssociationRequest.Builder().apply(block).build())

/**
 * Creates a knowledge base.
 *
 * When using this API, you cannot reuse [Amazon AppIntegrations](https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html) DataIntegrations with external knowledge bases such as Salesforce and ServiceNow. If you do, you'll get an `InvalidRequestException` error.
 *
 * For example, you're programmatically managing your external knowledge base, and you want to add or remove one of the fields that is being ingested from Salesforce. Do the following:
 * + Call [DeleteKnowledgeBase](https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_DeleteKnowledgeBase.html).
 * + Call [DeleteDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html).
 * + Call [CreateDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html) to recreate the DataIntegration or a create different one.
 * + Call CreateKnowledgeBase.
 */
public suspend inline fun QConnectClient.createKnowledgeBase(crossinline block: CreateKnowledgeBaseRequest.Builder.() -> Unit): CreateKnowledgeBaseResponse = createKnowledgeBase(CreateKnowledgeBaseRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Q in Connect message template. The name of the message template has to be unique for each knowledge base. The channel subtype of the message template is immutable and cannot be modified after creation. After the message template is created, you can use the `$LATEST` qualifier to reference the created message template.
 */
public suspend inline fun QConnectClient.createMessageTemplate(crossinline block: CreateMessageTemplateRequest.Builder.() -> Unit): CreateMessageTemplateResponse = createMessageTemplate(CreateMessageTemplateRequest.Builder().apply(block).build())

/**
 * Uploads an attachment file to the specified Amazon Q in Connect message template. The name of the message template attachment has to be unique for each message template referenced by the `$LATEST` qualifier. The body of the attachment file should be encoded using base64 encoding. After the file is uploaded, you can use the pre-signed Amazon S3 URL returned in response to download the uploaded file.
 */
public suspend inline fun QConnectClient.createMessageTemplateAttachment(crossinline block: CreateMessageTemplateAttachmentRequest.Builder.() -> Unit): CreateMessageTemplateAttachmentResponse = createMessageTemplateAttachment(CreateMessageTemplateAttachmentRequest.Builder().apply(block).build())

/**
 * Creates a new Amazon Q in Connect message template version from the current content and configuration of a message template. Versions are immutable and monotonically increasing. Once a version is created, you can reference a specific version of the message template by passing in `&lt;message-template-id&gt;:&lt;versionNumber&gt;` as the message template identifier. An error is displayed if the supplied `messageTemplateContentSha256` is different from the `messageTemplateContentSha256` of the message template with `$LATEST` qualifier. If multiple `CreateMessageTemplateVersion` requests are made while the message template remains the same, only the first invocation creates a new version and the succeeding requests will return the same response as the first invocation.
 */
public suspend inline fun QConnectClient.createMessageTemplateVersion(crossinline block: CreateMessageTemplateVersionRequest.Builder.() -> Unit): CreateMessageTemplateVersionResponse = createMessageTemplateVersion(CreateMessageTemplateVersionRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Q in Connect quick response.
 */
public suspend inline fun QConnectClient.createQuickResponse(crossinline block: CreateQuickResponseRequest.Builder.() -> Unit): CreateQuickResponseResponse = createQuickResponse(CreateQuickResponseRequest.Builder().apply(block).build())

/**
 * Creates a session. A session is a contextual container used for generating recommendations. Amazon Connect creates a new Amazon Q in Connect session for each contact on which Amazon Q in Connect is enabled.
 */
public suspend inline fun QConnectClient.createSession(crossinline block: CreateSessionRequest.Builder.() -> Unit): CreateSessionResponse = createSession(CreateSessionRequest.Builder().apply(block).build())

/**
 * Deactivates a specific version of the Amazon Q in Connect message template . After the version is deactivated, you can no longer use the `$ACTIVE_VERSION` qualifier to reference the version in active status.
 */
public suspend inline fun QConnectClient.deactivateMessageTemplate(crossinline block: DeactivateMessageTemplateRequest.Builder.() -> Unit): DeactivateMessageTemplateResponse = deactivateMessageTemplate(DeactivateMessageTemplateRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Q in Connect AI Agent.
 */
public suspend inline fun QConnectClient.deleteAiAgent(crossinline block: DeleteAiAgentRequest.Builder.() -> Unit): DeleteAiAgentResponse = deleteAiAgent(DeleteAiAgentRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Q in Connect AI Agent Version.
 */
public suspend inline fun QConnectClient.deleteAiAgentVersion(crossinline block: DeleteAiAgentVersionRequest.Builder.() -> Unit): DeleteAiAgentVersionResponse = deleteAiAgentVersion(DeleteAiAgentVersionRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Q in Connect AI Guardrail.
 */
public suspend inline fun QConnectClient.deleteAiGuardrail(crossinline block: DeleteAiGuardrailRequest.Builder.() -> Unit): DeleteAiGuardrailResponse = deleteAiGuardrail(DeleteAiGuardrailRequest.Builder().apply(block).build())

/**
 * Delete and Amazon Q in Connect AI Guardrail version.
 */
public suspend inline fun QConnectClient.deleteAiGuardrailVersion(crossinline block: DeleteAiGuardrailVersionRequest.Builder.() -> Unit): DeleteAiGuardrailVersionResponse = deleteAiGuardrailVersion(DeleteAiGuardrailVersionRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Q in Connect AI Prompt.
 */
public suspend inline fun QConnectClient.deleteAiPrompt(crossinline block: DeleteAiPromptRequest.Builder.() -> Unit): DeleteAiPromptResponse = deleteAiPrompt(DeleteAiPromptRequest.Builder().apply(block).build())

/**
 * Delete and Amazon Q in Connect AI Prompt version.
 */
public suspend inline fun QConnectClient.deleteAiPromptVersion(crossinline block: DeleteAiPromptVersionRequest.Builder.() -> Unit): DeleteAiPromptVersionResponse = deleteAiPromptVersion(DeleteAiPromptVersionRequest.Builder().apply(block).build())

/**
 * Deletes an assistant.
 */
public suspend inline fun QConnectClient.deleteAssistant(crossinline block: DeleteAssistantRequest.Builder.() -> Unit): DeleteAssistantResponse = deleteAssistant(DeleteAssistantRequest.Builder().apply(block).build())

/**
 * Deletes an assistant association.
 */
public suspend inline fun QConnectClient.deleteAssistantAssociation(crossinline block: DeleteAssistantAssociationRequest.Builder.() -> Unit): DeleteAssistantAssociationResponse = deleteAssistantAssociation(DeleteAssistantAssociationRequest.Builder().apply(block).build())

/**
 * Deletes the content.
 */
public suspend inline fun QConnectClient.deleteContent(crossinline block: DeleteContentRequest.Builder.() -> Unit): DeleteContentResponse = deleteContent(DeleteContentRequest.Builder().apply(block).build())

/**
 * Deletes the content association.
 *
 * For more information about content associations--what they are and when they are used--see [Integrate Amazon Q in Connect with step-by-step guides](https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html) in the *Amazon Connect Administrator Guide*.
 */
public suspend inline fun QConnectClient.deleteContentAssociation(crossinline block: DeleteContentAssociationRequest.Builder.() -> Unit): DeleteContentAssociationResponse = deleteContentAssociation(DeleteContentAssociationRequest.Builder().apply(block).build())

/**
 * Deletes the quick response import job.
 */
public suspend inline fun QConnectClient.deleteImportJob(crossinline block: DeleteImportJobRequest.Builder.() -> Unit): DeleteImportJobResponse = deleteImportJob(DeleteImportJobRequest.Builder().apply(block).build())

/**
 * Deletes the knowledge base.
 *
 * When you use this API to delete an external knowledge base such as Salesforce or ServiceNow, you must also delete the [Amazon AppIntegrations](https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html) DataIntegration. This is because you can't reuse the DataIntegration after it's been associated with an external knowledge base. However, you can delete and recreate it. See [DeleteDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html) and [CreateDataIntegration](https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html) in the *Amazon AppIntegrations API Reference*.
 */
public suspend inline fun QConnectClient.deleteKnowledgeBase(crossinline block: DeleteKnowledgeBaseRequest.Builder.() -> Unit): DeleteKnowledgeBaseResponse = deleteKnowledgeBase(DeleteKnowledgeBaseRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Q in Connect message template entirely or a specific version of the message template if version is supplied in the request. You can provide the message template identifier as `&lt;message-template-id&gt;:&lt;versionNumber&gt;` to delete a specific version of the message template. If it is not supplied, the message template and all available versions will be deleted.
 */
public suspend inline fun QConnectClient.deleteMessageTemplate(crossinline block: DeleteMessageTemplateRequest.Builder.() -> Unit): DeleteMessageTemplateResponse = deleteMessageTemplate(DeleteMessageTemplateRequest.Builder().apply(block).build())

/**
 * Deletes the attachment file from the Amazon Q in Connect message template that is referenced by `$LATEST` qualifier. Attachments on available message template versions will remain unchanged.
 */
public suspend inline fun QConnectClient.deleteMessageTemplateAttachment(crossinline block: DeleteMessageTemplateAttachmentRequest.Builder.() -> Unit): DeleteMessageTemplateAttachmentResponse = deleteMessageTemplateAttachment(DeleteMessageTemplateAttachmentRequest.Builder().apply(block).build())

/**
 * Deletes a quick response.
 */
public suspend inline fun QConnectClient.deleteQuickResponse(crossinline block: DeleteQuickResponseRequest.Builder.() -> Unit): DeleteQuickResponseResponse = deleteQuickResponse(DeleteQuickResponseRequest.Builder().apply(block).build())

/**
 * Gets an Amazon Q in Connect AI Agent.
 */
public suspend inline fun QConnectClient.getAiAgent(crossinline block: GetAiAgentRequest.Builder.() -> Unit): GetAiAgentResponse = getAiAgent(GetAiAgentRequest.Builder().apply(block).build())

/**
 * Gets the Amazon Q in Connect AI Guardrail.
 */
public suspend inline fun QConnectClient.getAiGuardrail(crossinline block: GetAiGuardrailRequest.Builder.() -> Unit): GetAiGuardrailResponse = getAiGuardrail(GetAiGuardrailRequest.Builder().apply(block).build())

/**
 * Gets and Amazon Q in Connect AI Prompt.
 */
public suspend inline fun QConnectClient.getAiPrompt(crossinline block: GetAiPromptRequest.Builder.() -> Unit): GetAiPromptResponse = getAiPrompt(GetAiPromptRequest.Builder().apply(block).build())

/**
 * Retrieves information about an assistant.
 */
public suspend inline fun QConnectClient.getAssistant(crossinline block: GetAssistantRequest.Builder.() -> Unit): GetAssistantResponse = getAssistant(GetAssistantRequest.Builder().apply(block).build())

/**
 * Retrieves information about an assistant association.
 */
public suspend inline fun QConnectClient.getAssistantAssociation(crossinline block: GetAssistantAssociationRequest.Builder.() -> Unit): GetAssistantAssociationResponse = getAssistantAssociation(GetAssistantAssociationRequest.Builder().apply(block).build())

/**
 * Retrieves content, including a pre-signed URL to download the content.
 */
public suspend inline fun QConnectClient.getContent(crossinline block: GetContentRequest.Builder.() -> Unit): GetContentResponse = getContent(GetContentRequest.Builder().apply(block).build())

/**
 * Returns the content association.
 *
 * For more information about content associations--what they are and when they are used--see [Integrate Amazon Q in Connect with step-by-step guides](https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html) in the *Amazon Connect Administrator Guide*.
 */
public suspend inline fun QConnectClient.getContentAssociation(crossinline block: GetContentAssociationRequest.Builder.() -> Unit): GetContentAssociationResponse = getContentAssociation(GetContentAssociationRequest.Builder().apply(block).build())

/**
 * Retrieves summary information about the content.
 */
public suspend inline fun QConnectClient.getContentSummary(crossinline block: GetContentSummaryRequest.Builder.() -> Unit): GetContentSummaryResponse = getContentSummary(GetContentSummaryRequest.Builder().apply(block).build())

/**
 * Retrieves the started import job.
 */
public suspend inline fun QConnectClient.getImportJob(crossinline block: GetImportJobRequest.Builder.() -> Unit): GetImportJobResponse = getImportJob(GetImportJobRequest.Builder().apply(block).build())

/**
 * Retrieves information about the knowledge base.
 */
public suspend inline fun QConnectClient.getKnowledgeBase(crossinline block: GetKnowledgeBaseRequest.Builder.() -> Unit): GetKnowledgeBaseResponse = getKnowledgeBase(GetKnowledgeBaseRequest.Builder().apply(block).build())

/**
 * Retrieves the Amazon Q in Connect message template. The message template identifier can contain an optional qualifier, for example, `&lt;message-template-id&gt;:&lt;qualifier&gt;`, which is either an actual version number or an Amazon Q Connect managed qualifier `$ACTIVE_VERSION` | `$LATEST`. If it is not supplied, then `$LATEST` is assumed implicitly.
 */
public suspend inline fun QConnectClient.getMessageTemplate(crossinline block: GetMessageTemplateRequest.Builder.() -> Unit): GetMessageTemplateResponse = getMessageTemplate(GetMessageTemplateRequest.Builder().apply(block).build())

/**
 * Retrieves next message on an Amazon Q in Connect session.
 */
public suspend inline fun QConnectClient.getNextMessage(crossinline block: GetNextMessageRequest.Builder.() -> Unit): GetNextMessageResponse = getNextMessage(GetNextMessageRequest.Builder().apply(block).build())

/**
 * Retrieves the quick response.
 */
public suspend inline fun QConnectClient.getQuickResponse(crossinline block: GetQuickResponseRequest.Builder.() -> Unit): GetQuickResponseResponse = getQuickResponse(GetQuickResponseRequest.Builder().apply(block).build())

/**
 * This API will be discontinued starting June 1, 2024. To receive generative responses after March 1, 2024, you will need to create a new Assistant in the Amazon Connect console and integrate the Amazon Q in Connect JavaScript library (amazon-q-connectjs) into your applications.
 *
 * Retrieves recommendations for the specified session. To avoid retrieving the same recommendations in subsequent calls, use [NotifyRecommendationsReceived](https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_NotifyRecommendationsReceived.html). This API supports long-polling behavior with the `waitTimeSeconds` parameter. Short poll is the default behavior and only returns recommendations already available. To perform a manual query against an assistant, use [QueryAssistant](https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_QueryAssistant.html).
 */
@Deprecated("GetRecommendations API will be discontinued starting June 1, 2024. To receive generative responses after March 1, 2024 you will need to create a new Assistant in the Connect console and integrate the Amazon Q in Connect JavaScript library (amazon-q-connectjs) into your applications.")
public suspend inline fun QConnectClient.getRecommendations(crossinline block: GetRecommendationsRequest.Builder.() -> Unit): GetRecommendationsResponse = getRecommendations(GetRecommendationsRequest.Builder().apply(block).build())

/**
 * Retrieves information for a specified session.
 */
public suspend inline fun QConnectClient.getSession(crossinline block: GetSessionRequest.Builder.() -> Unit): GetSessionResponse = getSession(GetSessionRequest.Builder().apply(block).build())

/**
 * List AI Agent versions.
 */
public suspend inline fun QConnectClient.listAiAgentVersions(crossinline block: ListAiAgentVersionsRequest.Builder.() -> Unit): ListAiAgentVersionsResponse = listAiAgentVersions(ListAiAgentVersionsRequest.Builder().apply(block).build())

/**
 * Lists AI Agents.
 */
public suspend inline fun QConnectClient.listAiAgents(crossinline block: ListAiAgentsRequest.Builder.() -> Unit): ListAiAgentsResponse = listAiAgents(ListAiAgentsRequest.Builder().apply(block).build())

/**
 * Lists AI Guardrail versions.
 */
public suspend inline fun QConnectClient.listAiGuardrailVersions(crossinline block: ListAiGuardrailVersionsRequest.Builder.() -> Unit): ListAiGuardrailVersionsResponse = listAiGuardrailVersions(ListAiGuardrailVersionsRequest.Builder().apply(block).build())

/**
 * Lists the AI Guardrails available on the Amazon Q in Connect assistant.
 */
public suspend inline fun QConnectClient.listAiGuardrails(crossinline block: ListAiGuardrailsRequest.Builder.() -> Unit): ListAiGuardrailsResponse = listAiGuardrails(ListAiGuardrailsRequest.Builder().apply(block).build())

/**
 * Lists AI Prompt versions.
 */
public suspend inline fun QConnectClient.listAiPromptVersions(crossinline block: ListAiPromptVersionsRequest.Builder.() -> Unit): ListAiPromptVersionsResponse = listAiPromptVersions(ListAiPromptVersionsRequest.Builder().apply(block).build())

/**
 * Lists the AI Prompts available on the Amazon Q in Connect assistant.
 */
public suspend inline fun QConnectClient.listAiPrompts(crossinline block: ListAiPromptsRequest.Builder.() -> Unit): ListAiPromptsResponse = listAiPrompts(ListAiPromptsRequest.Builder().apply(block).build())

/**
 * Lists information about assistant associations.
 */
public suspend inline fun QConnectClient.listAssistantAssociations(crossinline block: ListAssistantAssociationsRequest.Builder.() -> Unit): ListAssistantAssociationsResponse = listAssistantAssociations(ListAssistantAssociationsRequest.Builder().apply(block).build())

/**
 * Lists information about assistants.
 */
public suspend inline fun QConnectClient.listAssistants(crossinline block: ListAssistantsRequest.Builder.() -> Unit): ListAssistantsResponse = listAssistants(ListAssistantsRequest.Builder().apply(block).build())

/**
 * Lists the content associations.
 *
 * For more information about content associations--what they are and when they are used--see [Integrate Amazon Q in Connect with step-by-step guides](https://docs.aws.amazon.com/connect/latest/adminguide/integrate-q-with-guides.html) in the *Amazon Connect Administrator Guide*.
 */
public suspend inline fun QConnectClient.listContentAssociations(crossinline block: ListContentAssociationsRequest.Builder.() -> Unit): ListContentAssociationsResponse = listContentAssociations(ListContentAssociationsRequest.Builder().apply(block).build())

/**
 * Lists the content.
 */
public suspend inline fun QConnectClient.listContents(crossinline block: ListContentsRequest.Builder.() -> Unit): ListContentsResponse = listContents(ListContentsRequest.Builder().apply(block).build())

/**
 * Lists information about import jobs.
 */
public suspend inline fun QConnectClient.listImportJobs(crossinline block: ListImportJobsRequest.Builder.() -> Unit): ListImportJobsResponse = listImportJobs(ListImportJobsRequest.Builder().apply(block).build())

/**
 * Lists the knowledge bases.
 */
public suspend inline fun QConnectClient.listKnowledgeBases(crossinline block: ListKnowledgeBasesRequest.Builder.() -> Unit): ListKnowledgeBasesResponse = listKnowledgeBases(ListKnowledgeBasesRequest.Builder().apply(block).build())

/**
 * Lists all the available versions for the specified Amazon Q in Connect message template.
 */
public suspend inline fun QConnectClient.listMessageTemplateVersions(crossinline block: ListMessageTemplateVersionsRequest.Builder.() -> Unit): ListMessageTemplateVersionsResponse = listMessageTemplateVersions(ListMessageTemplateVersionsRequest.Builder().apply(block).build())

/**
 * Lists all the available Amazon Q in Connect message templates for the specified knowledge base.
 */
public suspend inline fun QConnectClient.listMessageTemplates(crossinline block: ListMessageTemplatesRequest.Builder.() -> Unit): ListMessageTemplatesResponse = listMessageTemplates(ListMessageTemplatesRequest.Builder().apply(block).build())

/**
 * Lists messages on an Amazon Q in Connect session.
 */
public suspend inline fun QConnectClient.listMessages(crossinline block: ListMessagesRequest.Builder.() -> Unit): ListMessagesResponse = listMessages(ListMessagesRequest.Builder().apply(block).build())

/**
 * Lists information about quick response.
 */
public suspend inline fun QConnectClient.listQuickResponses(crossinline block: ListQuickResponsesRequest.Builder.() -> Unit): ListQuickResponsesResponse = listQuickResponses(ListQuickResponsesRequest.Builder().apply(block).build())

/**
 * Lists the tags for the specified resource.
 */
public suspend inline fun QConnectClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Removes the specified recommendations from the specified assistant's queue of newly available recommendations. You can use this API in conjunction with [GetRecommendations](https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_GetRecommendations.html) and a `waitTimeSeconds` input for long-polling behavior and avoiding duplicate recommendations.
 */
public suspend inline fun QConnectClient.notifyRecommendationsReceived(crossinline block: NotifyRecommendationsReceivedRequest.Builder.() -> Unit): NotifyRecommendationsReceivedResponse = notifyRecommendationsReceived(NotifyRecommendationsReceivedRequest.Builder().apply(block).build())

/**
 * Provides feedback against the specified assistant for the specified target. This API only supports generative targets.
 */
public suspend inline fun QConnectClient.putFeedback(crossinline block: PutFeedbackRequest.Builder.() -> Unit): PutFeedbackResponse = putFeedback(PutFeedbackRequest.Builder().apply(block).build())

/**
 * This API will be discontinued starting June 1, 2024. To receive generative responses after March 1, 2024, you will need to create a new Assistant in the Amazon Connect console and integrate the Amazon Q in Connect JavaScript library (amazon-q-connectjs) into your applications.
 *
 * Performs a manual search against the specified assistant. To retrieve recommendations for an assistant, use [GetRecommendations](https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_GetRecommendations.html).
 */
@Deprecated("QueryAssistant API will be discontinued starting June 1, 2024. To receive generative responses after March 1, 2024 you will need to create a new Assistant in the Connect console and integrate the Amazon Q in Connect JavaScript library (amazon-q-connectjs) into your applications.")
public suspend inline fun QConnectClient.queryAssistant(crossinline block: QueryAssistantRequest.Builder.() -> Unit): QueryAssistantResponse = queryAssistant(QueryAssistantRequest.Builder().apply(block).build())

/**
 * Removes the AI Agent that is set for use by default on an Amazon Q in Connect Assistant.
 */
public suspend inline fun QConnectClient.removeAssistantAiAgent(crossinline block: RemoveAssistantAiAgentRequest.Builder.() -> Unit): RemoveAssistantAiAgentResponse = removeAssistantAiAgent(RemoveAssistantAiAgentRequest.Builder().apply(block).build())

/**
 * Removes a URI template from a knowledge base.
 */
public suspend inline fun QConnectClient.removeKnowledgeBaseTemplateUri(crossinline block: RemoveKnowledgeBaseTemplateUriRequest.Builder.() -> Unit): RemoveKnowledgeBaseTemplateUriResponse = removeKnowledgeBaseTemplateUri(RemoveKnowledgeBaseTemplateUriRequest.Builder().apply(block).build())

/**
 * Renders the Amazon Q in Connect message template based on the attribute values provided and generates the message content. For any variable present in the message template, if the attribute value is neither provided in the attribute request parameter nor the default attribute of the message template, the rendered message content will keep the variable placeholder as it is and return the attribute keys that are missing.
 */
public suspend inline fun QConnectClient.renderMessageTemplate(crossinline block: RenderMessageTemplateRequest.Builder.() -> Unit): RenderMessageTemplateResponse = renderMessageTemplate(RenderMessageTemplateRequest.Builder().apply(block).build())

/**
 * Searches for content in a specified knowledge base. Can be used to get a specific content resource by its name.
 */
public suspend inline fun QConnectClient.searchContent(crossinline block: SearchContentRequest.Builder.() -> Unit): SearchContentResponse = searchContent(SearchContentRequest.Builder().apply(block).build())

/**
 * Searches for Amazon Q in Connect message templates in the specified knowledge base.
 */
public suspend inline fun QConnectClient.searchMessageTemplates(crossinline block: SearchMessageTemplatesRequest.Builder.() -> Unit): SearchMessageTemplatesResponse = searchMessageTemplates(SearchMessageTemplatesRequest.Builder().apply(block).build())

/**
 * Searches existing Amazon Q in Connect quick responses in an Amazon Q in Connect knowledge base.
 */
public suspend inline fun QConnectClient.searchQuickResponses(crossinline block: SearchQuickResponsesRequest.Builder.() -> Unit): SearchQuickResponsesResponse = searchQuickResponses(SearchQuickResponsesRequest.Builder().apply(block).build())

/**
 * Searches for sessions.
 */
public suspend inline fun QConnectClient.searchSessions(crossinline block: SearchSessionsRequest.Builder.() -> Unit): SearchSessionsResponse = searchSessions(SearchSessionsRequest.Builder().apply(block).build())

/**
 * Submits a message to the Amazon Q in Connect session.
 */
public suspend inline fun QConnectClient.sendMessage(crossinline block: SendMessageRequest.Builder.() -> Unit): SendMessageResponse = sendMessage(SendMessageRequest.Builder().apply(block).build())

/**
 * Get a URL to upload content to a knowledge base. To upload content, first make a PUT request to the returned URL with your file, making sure to include the required headers. Then use [CreateContent](https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_CreateContent.html) to finalize the content creation process or [UpdateContent](https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_UpdateContent.html) to modify an existing resource. You can only upload content to a knowledge base of type CUSTOM.
 */
public suspend inline fun QConnectClient.startContentUpload(crossinline block: StartContentUploadRequest.Builder.() -> Unit): StartContentUploadResponse = startContentUpload(StartContentUploadRequest.Builder().apply(block).build())

/**
 * Start an asynchronous job to import Amazon Q in Connect resources from an uploaded source file. Before calling this API, use [StartContentUpload](https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html) to upload an asset that contains the resource data.
 * + For importing Amazon Q in Connect quick responses, you need to upload a csv file including the quick responses. For information about how to format the csv file for importing quick responses, see [Import quick responses](https://docs.aws.amazon.com/console/connect/quick-responses/add-data).
 */
public suspend inline fun QConnectClient.startImportJob(crossinline block: StartImportJobRequest.Builder.() -> Unit): StartImportJobResponse = startImportJob(StartImportJobRequest.Builder().apply(block).build())

/**
 * Adds the specified tags to the specified resource.
 */
public suspend inline fun QConnectClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the specified resource.
 */
public suspend inline fun QConnectClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an AI Agent.
 */
public suspend inline fun QConnectClient.updateAiAgent(crossinline block: UpdateAiAgentRequest.Builder.() -> Unit): UpdateAiAgentResponse = updateAiAgent(UpdateAiAgentRequest.Builder().apply(block).build())

/**
 * Updates an AI Guardrail.
 */
public suspend inline fun QConnectClient.updateAiGuardrail(crossinline block: UpdateAiGuardrailRequest.Builder.() -> Unit): UpdateAiGuardrailResponse = updateAiGuardrail(UpdateAiGuardrailRequest.Builder().apply(block).build())

/**
 * Updates an AI Prompt.
 */
public suspend inline fun QConnectClient.updateAiPrompt(crossinline block: UpdateAiPromptRequest.Builder.() -> Unit): UpdateAiPromptResponse = updateAiPrompt(UpdateAiPromptRequest.Builder().apply(block).build())

/**
 * Updates the AI Agent that is set for use by default on an Amazon Q in Connect Assistant.
 */
public suspend inline fun QConnectClient.updateAssistantAiAgent(crossinline block: UpdateAssistantAiAgentRequest.Builder.() -> Unit): UpdateAssistantAiAgentResponse = updateAssistantAiAgent(UpdateAssistantAiAgentRequest.Builder().apply(block).build())

/**
 * Updates information about the content.
 */
public suspend inline fun QConnectClient.updateContent(crossinline block: UpdateContentRequest.Builder.() -> Unit): UpdateContentResponse = updateContent(UpdateContentRequest.Builder().apply(block).build())

/**
 * Updates the template URI of a knowledge base. This is only supported for knowledge bases of type EXTERNAL. Include a single variable in `${variable}` format; this interpolated by Amazon Q in Connect using ingested content. For example, if you ingest a Salesforce article, it has an `Id` value, and you can set the template URI to `https://myInstanceName.lightning.force.com/lightning/r/Knowledge__kav&#47;*${Id}*&#47;view`.
 */
public suspend inline fun QConnectClient.updateKnowledgeBaseTemplateUri(crossinline block: UpdateKnowledgeBaseTemplateUriRequest.Builder.() -> Unit): UpdateKnowledgeBaseTemplateUriResponse = updateKnowledgeBaseTemplateUri(UpdateKnowledgeBaseTemplateUriRequest.Builder().apply(block).build())

/**
 * Updates the Amazon Q in Connect message template. Partial update is supported. If any field is not supplied, it will remain unchanged for the message template that is referenced by the `$LATEST` qualifier. Any modification will only apply to the message template that is referenced by the `$LATEST` qualifier. The fields for all available versions will remain unchanged.
 */
public suspend inline fun QConnectClient.updateMessageTemplate(crossinline block: UpdateMessageTemplateRequest.Builder.() -> Unit): UpdateMessageTemplateResponse = updateMessageTemplate(UpdateMessageTemplateRequest.Builder().apply(block).build())

/**
 * Updates the Amazon Q in Connect message template metadata. Note that any modification to the message template’s name, description and grouping configuration will applied to the message template pointed by the `$LATEST` qualifier and all available versions. Partial update is supported. If any field is not supplied, it will remain unchanged for the message template.
 */
public suspend inline fun QConnectClient.updateMessageTemplateMetadata(crossinline block: UpdateMessageTemplateMetadataRequest.Builder.() -> Unit): UpdateMessageTemplateMetadataResponse = updateMessageTemplateMetadata(UpdateMessageTemplateMetadataRequest.Builder().apply(block).build())

/**
 * Updates an existing Amazon Q in Connect quick response.
 */
public suspend inline fun QConnectClient.updateQuickResponse(crossinline block: UpdateQuickResponseRequest.Builder.() -> Unit): UpdateQuickResponseResponse = updateQuickResponse(UpdateQuickResponseRequest.Builder().apply(block).build())

/**
 * Updates a session. A session is a contextual container used for generating recommendations. Amazon Connect updates the existing Amazon Q in Connect session for each contact on which Amazon Q in Connect is enabled.
 */
public suspend inline fun QConnectClient.updateSession(crossinline block: UpdateSessionRequest.Builder.() -> Unit): UpdateSessionResponse = updateSession(UpdateSessionRequest.Builder().apply(block).build())

/**
 * Updates the data stored on an Amazon Q in Connect Session.
 */
public suspend inline fun QConnectClient.updateSessionData(crossinline block: UpdateSessionDataRequest.Builder.() -> Unit): UpdateSessionDataResponse = updateSessionData(UpdateSessionDataRequest.Builder().apply(block).build())
