// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.serde

import aws.sdk.kotlin.services.qbusiness.model.QBusinessException
import aws.sdk.kotlin.services.qbusiness.model.UpdateUserResponse
import aws.sdk.kotlin.services.qbusiness.model.UserAlias
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class UpdateUserOperationDeserializer: HttpDeserializer.NonStreaming<UpdateUserResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateUserResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateUserError(context, call, payload)
        }
        val builder = UpdateUserResponse.Builder()

        if (payload != null) {
            deserializeUpdateUserOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateUserError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw QBusinessException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> QBusinessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateUserOperationBody(builder: UpdateUserResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val USERALIASESADDED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("userAliasesAdded"))
    val USERALIASESDELETED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("userAliasesDeleted"))
    val USERALIASESUPDATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("userAliasesUpdated"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(USERALIASESADDED_DESCRIPTOR)
        field(USERALIASESDELETED_DESCRIPTOR)
        field(USERALIASESUPDATED_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                USERALIASESADDED_DESCRIPTOR.index -> builder.userAliasesAdded =
                    deserializer.deserializeList(USERALIASESADDED_DESCRIPTOR) {
                        val col0 = mutableListOf<UserAlias>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUserAliasDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                USERALIASESDELETED_DESCRIPTOR.index -> builder.userAliasesDeleted =
                    deserializer.deserializeList(USERALIASESDELETED_DESCRIPTOR) {
                        val col0 = mutableListOf<UserAlias>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUserAliasDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                USERALIASESUPDATED_DESCRIPTOR.index -> builder.userAliasesUpdated =
                    deserializer.deserializeList(USERALIASESUPDATED_DESCRIPTOR) {
                        val col0 = mutableListOf<UserAlias>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUserAliasDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
