// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.serde

import aws.sdk.kotlin.services.qbusiness.model.AttributeFilter
import aws.sdk.kotlin.services.qbusiness.model.ContentSource
import aws.sdk.kotlin.services.qbusiness.model.SearchRelevantContentRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class SearchRelevantContentOperationSerializer: HttpSerializer.NonStreaming<SearchRelevantContentRequest> {
    override fun serialize(context: ExecutionContext, input: SearchRelevantContentRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.applicationId) { "applicationId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("applications"))
                add(PercentEncoding.SmithyLabel.encode(input.applicationId))
                add(PercentEncoding.Path.encode("relevant-content"))
            }
        }

        val payload = serializeSearchRelevantContentOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeSearchRelevantContentOperationBody(context: ExecutionContext, input: SearchRelevantContentRequest): ByteArray {
    val serializer = JsonSerializer()
    val ATTRIBUTEFILTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("attributeFilter"))
    val CONTENTSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("contentSource"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maxResults"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val QUERYTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("queryText"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTRIBUTEFILTER_DESCRIPTOR)
        field(CONTENTSOURCE_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(QUERYTEXT_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.attributeFilter?.let { field(ATTRIBUTEFILTER_DESCRIPTOR, it, ::serializeAttributeFilterDocument) }
        input.contentSource?.let { field(CONTENTSOURCE_DESCRIPTOR, it, ::serializeContentSourceDocument) }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        input.queryText?.let { field(QUERYTEXT_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
