// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.serde

import aws.sdk.kotlin.services.qbusiness.model.ChatInputStream
import aws.sdk.kotlin.services.qbusiness.model.ChatRequest
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.HashSpecification
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.HeaderValue
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.Message
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.asEventStreamHttpBody
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.buildMessage
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.encode
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.sign
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import kotlinx.coroutines.CompletableDeferred
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.map
import kotlinx.coroutines.job


internal class ChatOperationSerializer: HttpSerializer.Streaming<ChatRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ChatRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.applicationId) { "applicationId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("applications"))
                add(PercentEncoding.SmithyLabel.encode(input.applicationId))
                add(PercentEncoding.Path.encode("conversations"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                add("clientToken", (input.clientToken ?: context.idempotencyTokenProvider.generateToken()))
                if (input.conversationId != null) add("conversationId", input.conversationId)
                if (input.parentMessageId != null) add("parentMessageId", input.parentMessageId)
                if (input.userGroups != null) addAll("userGroups", input.userGroups)
                if (input.userId != null) add("userId", input.userId)
            }
        }

        builder.body = serializeChatOperationBody(context, input)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

internal suspend fun serializeChatOperationBody(context: ExecutionContext, input: ChatRequest): HttpBody {
    val stream = input.inputStream ?: return HttpBody.Empty
    context[AwsSigningAttributes.HashSpecification] = HashSpecification.EmptyBody
    context[AwsSigningAttributes.Signer] = DefaultAwsSigner
    context[AwsSigningAttributes.RequestSignature] = CompletableDeferred(context.coroutineContext.job)

    val messages = stream
        .map(::encodeChatChatInputStreamEventMessage)
        .sign(context)
        .encode()

    return messages.asEventStreamHttpBody(context)
}

private fun encodeChatChatInputStreamEventMessage(input: ChatInputStream): Message = buildMessage {
    addHeader(":message-type", HeaderValue.String("event"))
    when(input) {
        is ChatInputStream.ConfigurationEvent -> {
            addHeader(":event-type", HeaderValue.String("configurationEvent"))
            addHeader(":content-type", HeaderValue.String("application/json"))
            payload = serializeConfigurationEventPayload(input.value)
        }
        is ChatInputStream.TextEvent -> {
            addHeader(":event-type", HeaderValue.String("textEvent"))
            addHeader(":content-type", HeaderValue.String("application/json"))
            payload = serializeTextInputEventPayload(input.value)
        }
        is ChatInputStream.AttachmentEvent -> {
            addHeader(":event-type", HeaderValue.String("attachmentEvent"))
            addHeader(":content-type", HeaderValue.String("application/json"))
            payload = serializeAttachmentInputEventPayload(input.value)
        }
        is ChatInputStream.ActionExecutionEvent -> {
            addHeader(":event-type", HeaderValue.String("actionExecutionEvent"))
            addHeader(":content-type", HeaderValue.String("application/json"))
            payload = serializeActionExecutionEventPayload(input.value)
        }
        is ChatInputStream.EndOfInputEvent -> {
            addHeader(":event-type", HeaderValue.String("endOfInputEvent"))
        }
        is ChatInputStream.AuthChallengeResponseEvent -> {
            addHeader(":event-type", HeaderValue.String("authChallengeResponseEvent"))
            addHeader(":content-type", HeaderValue.String("application/json"))
            payload = serializeAuthChallengeResponseEventPayload(input.value)
        }
        is ChatInputStream.SdkUnknown -> error("cannot serialize the unknown event type!")
    }
}
