// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateWebExperienceRequest private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon Q Business application attached to the web experience.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The authentication configuration of the Amazon Q Business web experience.
     */
    @Deprecated("Property associated with legacy SAML IdP flow. Deprecated in favor of using AWS IAM Identity Center for user management.")
    public val authenticationConfiguration: aws.sdk.kotlin.services.qbusiness.model.WebExperienceAuthConfiguration? = builder.authenticationConfiguration
    /**
     * The browser extension configuration for an Amazon Q Business web experience.
     *
     *  For Amazon Q Business application using external OIDC-compliant identity providers (IdPs). The IdP administrator must add the browser extension sign-in redirect URLs to the IdP application. For more information, see [Configure external OIDC identity provider for your browser extensions.](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/browser-extensions.html).
     */
    public val browserExtensionConfiguration: aws.sdk.kotlin.services.qbusiness.model.BrowserExtensionConfiguration? = builder.browserExtensionConfiguration
    /**
     * Updates the custom logo, favicon, font, and color used in the Amazon Q web experience.
     */
    public val customizationConfiguration: aws.sdk.kotlin.services.qbusiness.model.CustomizationConfiguration? = builder.customizationConfiguration
    /**
     * Information about the identity provider (IdP) used to authenticate end users of an Amazon Q Business web experience.
     */
    public val identityProviderConfiguration: aws.sdk.kotlin.services.qbusiness.model.IdentityProviderConfiguration? = builder.identityProviderConfiguration
    /**
     * Updates the website domain origins that are allowed to embed the Amazon Q Business web experience. The *domain origin* refers to the *base URL* for accessing a website including the protocol (`http/https`), the domain name, and the port number (if specified).
     *
     * + Any values except `null` submitted as part of this update will replace all previous values.
     * + You must only submit a *base URL* and not a full path. For example, `https://docs.aws.amazon.com`.
     */
    public val origins: List<String>? = builder.origins
    /**
     * The Amazon Resource Name (ARN) of the role with permission to access the Amazon Q Business web experience and required resources.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Determines whether sample prompts are enabled in the web experience for an end user.
     */
    public val samplePromptsControlMode: aws.sdk.kotlin.services.qbusiness.model.WebExperienceSamplePromptsControlMode? = builder.samplePromptsControlMode
    /**
     * The subtitle of the Amazon Q Business web experience.
     */
    public val subtitle: kotlin.String? = builder.subtitle
    /**
     * The title of the Amazon Q Business web experience.
     */
    public val title: kotlin.String? = builder.title
    /**
     * The identifier of the Amazon Q Business web experience.
     */
    public val webExperienceId: kotlin.String? = builder.webExperienceId
    /**
     * A customized welcome message for an end user in an Amazon Q Business web experience.
     */
    public val welcomeMessage: kotlin.String? = builder.welcomeMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.UpdateWebExperienceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateWebExperienceRequest(")
        append("applicationId=$applicationId,")
        append("authenticationConfiguration=$authenticationConfiguration,")
        append("browserExtensionConfiguration=$browserExtensionConfiguration,")
        append("customizationConfiguration=$customizationConfiguration,")
        append("identityProviderConfiguration=$identityProviderConfiguration,")
        append("origins=$origins,")
        append("roleArn=$roleArn,")
        append("samplePromptsControlMode=$samplePromptsControlMode,")
        append("subtitle=$subtitle,")
        append("title=$title,")
        append("webExperienceId=$webExperienceId,")
        append("welcomeMessage=$welcomeMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (authenticationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (browserExtensionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (customizationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (identityProviderConfiguration?.hashCode() ?: 0)
        result = 31 * result + (origins?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (samplePromptsControlMode?.hashCode() ?: 0)
        result = 31 * result + (subtitle?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (webExperienceId?.hashCode() ?: 0)
        result = 31 * result + (welcomeMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateWebExperienceRequest

        if (applicationId != other.applicationId) return false
        if (authenticationConfiguration != other.authenticationConfiguration) return false
        if (browserExtensionConfiguration != other.browserExtensionConfiguration) return false
        if (customizationConfiguration != other.customizationConfiguration) return false
        if (identityProviderConfiguration != other.identityProviderConfiguration) return false
        if (origins != other.origins) return false
        if (roleArn != other.roleArn) return false
        if (samplePromptsControlMode != other.samplePromptsControlMode) return false
        if (subtitle != other.subtitle) return false
        if (title != other.title) return false
        if (webExperienceId != other.webExperienceId) return false
        if (welcomeMessage != other.welcomeMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.UpdateWebExperienceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the Amazon Q Business application attached to the web experience.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The authentication configuration of the Amazon Q Business web experience.
         */
        @Deprecated("Property associated with legacy SAML IdP flow. Deprecated in favor of using AWS IAM Identity Center for user management.")
        public var authenticationConfiguration: aws.sdk.kotlin.services.qbusiness.model.WebExperienceAuthConfiguration? = null
        /**
         * The browser extension configuration for an Amazon Q Business web experience.
         *
         *  For Amazon Q Business application using external OIDC-compliant identity providers (IdPs). The IdP administrator must add the browser extension sign-in redirect URLs to the IdP application. For more information, see [Configure external OIDC identity provider for your browser extensions.](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/browser-extensions.html).
         */
        public var browserExtensionConfiguration: aws.sdk.kotlin.services.qbusiness.model.BrowserExtensionConfiguration? = null
        /**
         * Updates the custom logo, favicon, font, and color used in the Amazon Q web experience.
         */
        public var customizationConfiguration: aws.sdk.kotlin.services.qbusiness.model.CustomizationConfiguration? = null
        /**
         * Information about the identity provider (IdP) used to authenticate end users of an Amazon Q Business web experience.
         */
        public var identityProviderConfiguration: aws.sdk.kotlin.services.qbusiness.model.IdentityProviderConfiguration? = null
        /**
         * Updates the website domain origins that are allowed to embed the Amazon Q Business web experience. The *domain origin* refers to the *base URL* for accessing a website including the protocol (`http/https`), the domain name, and the port number (if specified).
         *
         * + Any values except `null` submitted as part of this update will replace all previous values.
         * + You must only submit a *base URL* and not a full path. For example, `https://docs.aws.amazon.com`.
         */
        public var origins: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the role with permission to access the Amazon Q Business web experience and required resources.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Determines whether sample prompts are enabled in the web experience for an end user.
         */
        public var samplePromptsControlMode: aws.sdk.kotlin.services.qbusiness.model.WebExperienceSamplePromptsControlMode? = null
        /**
         * The subtitle of the Amazon Q Business web experience.
         */
        public var subtitle: kotlin.String? = null
        /**
         * The title of the Amazon Q Business web experience.
         */
        public var title: kotlin.String? = null
        /**
         * The identifier of the Amazon Q Business web experience.
         */
        public var webExperienceId: kotlin.String? = null
        /**
         * A customized welcome message for an end user in an Amazon Q Business web experience.
         */
        public var welcomeMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.UpdateWebExperienceRequest) : this() {
            this.applicationId = x.applicationId
            this.authenticationConfiguration = x.authenticationConfiguration
            this.browserExtensionConfiguration = x.browserExtensionConfiguration
            this.customizationConfiguration = x.customizationConfiguration
            this.identityProviderConfiguration = x.identityProviderConfiguration
            this.origins = x.origins
            this.roleArn = x.roleArn
            this.samplePromptsControlMode = x.samplePromptsControlMode
            this.subtitle = x.subtitle
            this.title = x.title
            this.webExperienceId = x.webExperienceId
            this.welcomeMessage = x.welcomeMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.UpdateWebExperienceRequest = UpdateWebExperienceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.BrowserExtensionConfiguration] inside the given [block]
         */
        public fun browserExtensionConfiguration(block: aws.sdk.kotlin.services.qbusiness.model.BrowserExtensionConfiguration.Builder.() -> kotlin.Unit) {
            this.browserExtensionConfiguration = aws.sdk.kotlin.services.qbusiness.model.BrowserExtensionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.CustomizationConfiguration] inside the given [block]
         */
        public fun customizationConfiguration(block: aws.sdk.kotlin.services.qbusiness.model.CustomizationConfiguration.Builder.() -> kotlin.Unit) {
            this.customizationConfiguration = aws.sdk.kotlin.services.qbusiness.model.CustomizationConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
