// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateApplicationRequest private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon Q Business application.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * An option to allow end users to upload files directly during chat.
     */
    public val attachmentsConfiguration: aws.sdk.kotlin.services.qbusiness.model.AttachmentsConfiguration? = builder.attachmentsConfiguration
    /**
     * An option to enable updating the default subscription type assigned to an Amazon Q Business application using IAM identity federation for user management.
     */
    public val autoSubscriptionConfiguration: aws.sdk.kotlin.services.qbusiness.model.AutoSubscriptionConfiguration? = builder.autoSubscriptionConfiguration
    /**
     * A description for the Amazon Q Business application.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A name for the Amazon Q Business application.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * The Amazon Resource Name (ARN) of the IAM Identity Center instance you are either creating for—or connecting to—your Amazon Q Business application.
     */
    public val identityCenterInstanceArn: kotlin.String? = builder.identityCenterInstanceArn
    /**
     * Configuration information about chat response personalization. For more information, see [Personalizing chat responses](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/personalizing-chat-responses.html).
     */
    public val personalizationConfiguration: aws.sdk.kotlin.services.qbusiness.model.PersonalizationConfiguration? = builder.personalizationConfiguration
    /**
     * An option to allow end users to create and use Amazon Q Apps in the web experience.
     */
    public val qAppsConfiguration: aws.sdk.kotlin.services.qbusiness.model.QAppsConfiguration? = builder.qAppsConfiguration
    /**
     * An Amazon Web Services Identity and Access Management (IAM) role that gives Amazon Q Business permission to access Amazon CloudWatch logs and metrics.
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.UpdateApplicationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateApplicationRequest(")
        append("applicationId=$applicationId,")
        append("attachmentsConfiguration=$attachmentsConfiguration,")
        append("autoSubscriptionConfiguration=$autoSubscriptionConfiguration,")
        append("description=$description,")
        append("displayName=$displayName,")
        append("identityCenterInstanceArn=$identityCenterInstanceArn,")
        append("personalizationConfiguration=$personalizationConfiguration,")
        append("qAppsConfiguration=$qAppsConfiguration,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (attachmentsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (autoSubscriptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (identityCenterInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (personalizationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (qAppsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateApplicationRequest

        if (applicationId != other.applicationId) return false
        if (attachmentsConfiguration != other.attachmentsConfiguration) return false
        if (autoSubscriptionConfiguration != other.autoSubscriptionConfiguration) return false
        if (description != other.description) return false
        if (displayName != other.displayName) return false
        if (identityCenterInstanceArn != other.identityCenterInstanceArn) return false
        if (personalizationConfiguration != other.personalizationConfiguration) return false
        if (qAppsConfiguration != other.qAppsConfiguration) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.UpdateApplicationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the Amazon Q Business application.
         */
        public var applicationId: kotlin.String? = null
        /**
         * An option to allow end users to upload files directly during chat.
         */
        public var attachmentsConfiguration: aws.sdk.kotlin.services.qbusiness.model.AttachmentsConfiguration? = null
        /**
         * An option to enable updating the default subscription type assigned to an Amazon Q Business application using IAM identity federation for user management.
         */
        public var autoSubscriptionConfiguration: aws.sdk.kotlin.services.qbusiness.model.AutoSubscriptionConfiguration? = null
        /**
         * A description for the Amazon Q Business application.
         */
        public var description: kotlin.String? = null
        /**
         * A name for the Amazon Q Business application.
         */
        public var displayName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM Identity Center instance you are either creating for—or connecting to—your Amazon Q Business application.
         */
        public var identityCenterInstanceArn: kotlin.String? = null
        /**
         * Configuration information about chat response personalization. For more information, see [Personalizing chat responses](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/personalizing-chat-responses.html).
         */
        public var personalizationConfiguration: aws.sdk.kotlin.services.qbusiness.model.PersonalizationConfiguration? = null
        /**
         * An option to allow end users to create and use Amazon Q Apps in the web experience.
         */
        public var qAppsConfiguration: aws.sdk.kotlin.services.qbusiness.model.QAppsConfiguration? = null
        /**
         * An Amazon Web Services Identity and Access Management (IAM) role that gives Amazon Q Business permission to access Amazon CloudWatch logs and metrics.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.UpdateApplicationRequest) : this() {
            this.applicationId = x.applicationId
            this.attachmentsConfiguration = x.attachmentsConfiguration
            this.autoSubscriptionConfiguration = x.autoSubscriptionConfiguration
            this.description = x.description
            this.displayName = x.displayName
            this.identityCenterInstanceArn = x.identityCenterInstanceArn
            this.personalizationConfiguration = x.personalizationConfiguration
            this.qAppsConfiguration = x.qAppsConfiguration
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.UpdateApplicationRequest = UpdateApplicationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.AttachmentsConfiguration] inside the given [block]
         */
        public fun attachmentsConfiguration(block: aws.sdk.kotlin.services.qbusiness.model.AttachmentsConfiguration.Builder.() -> kotlin.Unit) {
            this.attachmentsConfiguration = aws.sdk.kotlin.services.qbusiness.model.AttachmentsConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.AutoSubscriptionConfiguration] inside the given [block]
         */
        public fun autoSubscriptionConfiguration(block: aws.sdk.kotlin.services.qbusiness.model.AutoSubscriptionConfiguration.Builder.() -> kotlin.Unit) {
            this.autoSubscriptionConfiguration = aws.sdk.kotlin.services.qbusiness.model.AutoSubscriptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.PersonalizationConfiguration] inside the given [block]
         */
        public fun personalizationConfiguration(block: aws.sdk.kotlin.services.qbusiness.model.PersonalizationConfiguration.Builder.() -> kotlin.Unit) {
            this.personalizationConfiguration = aws.sdk.kotlin.services.qbusiness.model.PersonalizationConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.QAppsConfiguration] inside the given [block]
         */
        public fun qAppsConfiguration(block: aws.sdk.kotlin.services.qbusiness.model.QAppsConfiguration.Builder.() -> kotlin.Unit) {
            this.qAppsConfiguration = aws.sdk.kotlin.services.qbusiness.model.QAppsConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
