// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information about a text extract in a chat response that can be attributed to a source document.
 */
public class TextSegment private constructor(builder: Builder) {
    /**
     * The zero-based location in the response string where the source attribution starts.
     */
    public val beginOffset: kotlin.Int? = builder.beginOffset
    /**
     * The zero-based location in the response string where the source attribution ends.
     */
    public val endOffset: kotlin.Int? = builder.endOffset
    /**
     * The identifier of the media object associated with the text segment in the source attribution.
     */
    public val mediaId: kotlin.String? = builder.mediaId
    /**
     * The MIME type (image/png) of the media object associated with the text segment in the source attribution.
     */
    public val mediaMimeType: kotlin.String? = builder.mediaMimeType
    /**
     * The relevant text excerpt from a source that was used to generate a citation text segment in an Amazon Q Business chat response.
     */
    public val snippetExcerpt: aws.sdk.kotlin.services.qbusiness.model.SnippetExcerpt? = builder.snippetExcerpt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.TextSegment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TextSegment(")
        append("beginOffset=$beginOffset,")
        append("endOffset=$endOffset,")
        append("mediaId=$mediaId,")
        append("mediaMimeType=$mediaMimeType,")
        append("snippetExcerpt=$snippetExcerpt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = beginOffset ?: 0
        result = 31 * result + (endOffset ?: 0)
        result = 31 * result + (mediaId?.hashCode() ?: 0)
        result = 31 * result + (mediaMimeType?.hashCode() ?: 0)
        result = 31 * result + (snippetExcerpt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TextSegment

        if (beginOffset != other.beginOffset) return false
        if (endOffset != other.endOffset) return false
        if (mediaId != other.mediaId) return false
        if (mediaMimeType != other.mediaMimeType) return false
        if (snippetExcerpt != other.snippetExcerpt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.TextSegment = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The zero-based location in the response string where the source attribution starts.
         */
        public var beginOffset: kotlin.Int? = null
        /**
         * The zero-based location in the response string where the source attribution ends.
         */
        public var endOffset: kotlin.Int? = null
        /**
         * The identifier of the media object associated with the text segment in the source attribution.
         */
        public var mediaId: kotlin.String? = null
        /**
         * The MIME type (image/png) of the media object associated with the text segment in the source attribution.
         */
        public var mediaMimeType: kotlin.String? = null
        /**
         * The relevant text excerpt from a source that was used to generate a citation text segment in an Amazon Q Business chat response.
         */
        public var snippetExcerpt: aws.sdk.kotlin.services.qbusiness.model.SnippetExcerpt? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.TextSegment) : this() {
            this.beginOffset = x.beginOffset
            this.endOffset = x.endOffset
            this.mediaId = x.mediaId
            this.mediaMimeType = x.mediaMimeType
            this.snippetExcerpt = x.snippetExcerpt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.TextSegment = TextSegment(this)

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.SnippetExcerpt] inside the given [block]
         */
        public fun snippetExcerpt(block: aws.sdk.kotlin.services.qbusiness.model.SnippetExcerpt.Builder.() -> kotlin.Unit) {
            this.snippetExcerpt = aws.sdk.kotlin.services.qbusiness.model.SnippetExcerpt.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
