// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about an Amazon Q Business subscription.
 *
 * Subscriptions are used to provide access for an IAM Identity Center user or a group to an Amazon Q Business application.
 *
 * Amazon Q Business offers two subscription tiers: `Q_LITE` and `Q_BUSINESS`. Subscription tier determines feature access for the user. For more information on subscriptions and pricing tiers, see [Amazon Q Business pricing](https://aws.amazon.com/q/business/pricing/).
 */
public class Subscription private constructor(builder: Builder) {
    /**
     * The type of your current Amazon Q Business subscription.
     */
    public val currentSubscription: aws.sdk.kotlin.services.qbusiness.model.SubscriptionDetails? = builder.currentSubscription
    /**
     * The type of the Amazon Q Business subscription for the next month.
     */
    public val nextSubscription: aws.sdk.kotlin.services.qbusiness.model.SubscriptionDetails? = builder.nextSubscription
    /**
     * The IAM Identity Center `UserId` or `GroupId` of a user or group in the IAM Identity Center instance connected to the Amazon Q Business application.
     */
    public val principal: aws.sdk.kotlin.services.qbusiness.model.SubscriptionPrincipal? = builder.principal
    /**
     * The Amazon Resource Name (ARN) of the Amazon Q Business subscription that was updated.
     */
    public val subscriptionArn: kotlin.String? = builder.subscriptionArn
    /**
     * The identifier of the Amazon Q Business subscription to be updated.
     */
    public val subscriptionId: kotlin.String? = builder.subscriptionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.Subscription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Subscription(")
        append("currentSubscription=$currentSubscription,")
        append("nextSubscription=$nextSubscription,")
        append("principal=$principal,")
        append("subscriptionArn=$subscriptionArn,")
        append("subscriptionId=$subscriptionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = currentSubscription?.hashCode() ?: 0
        result = 31 * result + (nextSubscription?.hashCode() ?: 0)
        result = 31 * result + (principal?.hashCode() ?: 0)
        result = 31 * result + (subscriptionArn?.hashCode() ?: 0)
        result = 31 * result + (subscriptionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Subscription

        if (currentSubscription != other.currentSubscription) return false
        if (nextSubscription != other.nextSubscription) return false
        if (principal != other.principal) return false
        if (subscriptionArn != other.subscriptionArn) return false
        if (subscriptionId != other.subscriptionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.Subscription = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The type of your current Amazon Q Business subscription.
         */
        public var currentSubscription: aws.sdk.kotlin.services.qbusiness.model.SubscriptionDetails? = null
        /**
         * The type of the Amazon Q Business subscription for the next month.
         */
        public var nextSubscription: aws.sdk.kotlin.services.qbusiness.model.SubscriptionDetails? = null
        /**
         * The IAM Identity Center `UserId` or `GroupId` of a user or group in the IAM Identity Center instance connected to the Amazon Q Business application.
         */
        public var principal: aws.sdk.kotlin.services.qbusiness.model.SubscriptionPrincipal? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon Q Business subscription that was updated.
         */
        public var subscriptionArn: kotlin.String? = null
        /**
         * The identifier of the Amazon Q Business subscription to be updated.
         */
        public var subscriptionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.Subscription) : this() {
            this.currentSubscription = x.currentSubscription
            this.nextSubscription = x.nextSubscription
            this.principal = x.principal
            this.subscriptionArn = x.subscriptionArn
            this.subscriptionId = x.subscriptionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.Subscription = Subscription(this)

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.SubscriptionDetails] inside the given [block]
         */
        public fun currentSubscription(block: aws.sdk.kotlin.services.qbusiness.model.SubscriptionDetails.Builder.() -> kotlin.Unit) {
            this.currentSubscription = aws.sdk.kotlin.services.qbusiness.model.SubscriptionDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.SubscriptionDetails] inside the given [block]
         */
        public fun nextSubscription(block: aws.sdk.kotlin.services.qbusiness.model.SubscriptionDetails.Builder.() -> kotlin.Unit) {
            this.nextSubscription = aws.sdk.kotlin.services.qbusiness.model.SubscriptionDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
