// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model

import aws.smithy.kotlin.runtime.SdkDsl

public class PutGroupRequest private constructor(builder: Builder) {
    /**
     * The identifier of the application in which the user and group mapping belongs.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The identifier of the data source for which you want to map users to their groups. This is useful if a group is tied to multiple data sources, but you only want the group to access documents of a certain data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to the company's documents stored in the data sources Confluence and Salesforce. However, "Sales and Marketing" team only needs access to customer-related documents stored in Salesforce.
     */
    public val dataSourceId: kotlin.String? = builder.dataSourceId
    /**
     * A list of users or sub groups that belong to a group. This is for generating Amazon Q Business chat results only from document a user has access to.
     */
    public val groupMembers: aws.sdk.kotlin.services.qbusiness.model.GroupMembers? = builder.groupMembers
    /**
     * The list that contains your users or sub groups that belong the same group. For example, the group "Company" includes the user "CEO" and the sub groups "Research", "Engineering", and "Sales and Marketing".
     */
    public val groupName: kotlin.String? = builder.groupName
    /**
     * The identifier of the index in which you want to map users to their groups.
     */
    public val indexId: kotlin.String? = builder.indexId
    /**
     * The Amazon Resource Name (ARN) of an IAM role that has access to the S3 file that contains your list of users that belong to a group.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The type of the group.
     */
    public val type: aws.sdk.kotlin.services.qbusiness.model.MembershipType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.PutGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutGroupRequest(")
        append("applicationId=$applicationId,")
        append("dataSourceId=$dataSourceId,")
        append("groupMembers=$groupMembers,")
        append("groupName=$groupName,")
        append("indexId=$indexId,")
        append("roleArn=$roleArn,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (dataSourceId?.hashCode() ?: 0)
        result = 31 * result + (groupMembers?.hashCode() ?: 0)
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (indexId?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutGroupRequest

        if (applicationId != other.applicationId) return false
        if (dataSourceId != other.dataSourceId) return false
        if (groupMembers != other.groupMembers) return false
        if (groupName != other.groupName) return false
        if (indexId != other.indexId) return false
        if (roleArn != other.roleArn) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.PutGroupRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the application in which the user and group mapping belongs.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The identifier of the data source for which you want to map users to their groups. This is useful if a group is tied to multiple data sources, but you only want the group to access documents of a certain data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to the company's documents stored in the data sources Confluence and Salesforce. However, "Sales and Marketing" team only needs access to customer-related documents stored in Salesforce.
         */
        public var dataSourceId: kotlin.String? = null
        /**
         * A list of users or sub groups that belong to a group. This is for generating Amazon Q Business chat results only from document a user has access to.
         */
        public var groupMembers: aws.sdk.kotlin.services.qbusiness.model.GroupMembers? = null
        /**
         * The list that contains your users or sub groups that belong the same group. For example, the group "Company" includes the user "CEO" and the sub groups "Research", "Engineering", and "Sales and Marketing".
         */
        public var groupName: kotlin.String? = null
        /**
         * The identifier of the index in which you want to map users to their groups.
         */
        public var indexId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role that has access to the S3 file that contains your list of users that belong to a group.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The type of the group.
         */
        public var type: aws.sdk.kotlin.services.qbusiness.model.MembershipType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.PutGroupRequest) : this() {
            this.applicationId = x.applicationId
            this.dataSourceId = x.dataSourceId
            this.groupMembers = x.groupMembers
            this.groupName = x.groupName
            this.indexId = x.indexId
            this.roleArn = x.roleArn
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.PutGroupRequest = PutGroupRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.GroupMembers] inside the given [block]
         */
        public fun groupMembers(block: aws.sdk.kotlin.services.qbusiness.model.GroupMembers.Builder.() -> kotlin.Unit) {
            this.groupMembers = aws.sdk.kotlin.services.qbusiness.model.GroupMembers.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
