// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the IAM Identity Center Application used to configure authentication for a plugin.
 */
public class IdcAuthConfiguration private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the IAM Identity Center Application used to configure authentication.
     */
    public val idcApplicationArn: kotlin.String = requireNotNull(builder.idcApplicationArn) { "A non-null value must be provided for idcApplicationArn" }
    /**
     * The Amazon Resource Name (ARN) of the IAM role with permissions to perform actions on Amazon Web Services services on your behalf.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.IdcAuthConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IdcAuthConfiguration(")
        append("idcApplicationArn=$idcApplicationArn,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = idcApplicationArn.hashCode()
        result = 31 * result + (roleArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IdcAuthConfiguration

        if (idcApplicationArn != other.idcApplicationArn) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.IdcAuthConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the IAM Identity Center Application used to configure authentication.
         */
        public var idcApplicationArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role with permissions to perform actions on Amazon Web Services services on your behalf.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.IdcAuthConfiguration) : this() {
            this.idcApplicationArn = x.idcApplicationArn
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.IdcAuthConfiguration = IdcAuthConfiguration(this)

        internal fun correctErrors(): Builder {
            if (idcApplicationArn == null) idcApplicationArn = ""
            if (roleArn == null) roleArn = ""
            return this
        }
    }
}
