// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateWebExperienceRequest private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon Q Business web experience.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The browser extension configuration for an Amazon Q Business web experience.
     *
     *  For Amazon Q Business application using external OIDC-compliant identity providers (IdPs). The IdP administrator must add the browser extension sign-in redirect URLs to the IdP application. For more information, see [Configure external OIDC identity provider for your browser extensions.](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/browser-extensions.html).
     */
    public val browserExtensionConfiguration: aws.sdk.kotlin.services.qbusiness.model.BrowserExtensionConfiguration? = builder.browserExtensionConfiguration
    /**
     * A token you provide to identify a request to create an Amazon Q Business web experience.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Sets the custom logo, favicon, font, and color used in the Amazon Q web experience.
     */
    public val customizationConfiguration: aws.sdk.kotlin.services.qbusiness.model.CustomizationConfiguration? = builder.customizationConfiguration
    /**
     * Information about the identity provider (IdP) used to authenticate end users of an Amazon Q Business web experience.
     */
    public val identityProviderConfiguration: aws.sdk.kotlin.services.qbusiness.model.IdentityProviderConfiguration? = builder.identityProviderConfiguration
    /**
     * Sets the website domain origins that are allowed to embed the Amazon Q Business web experience. The *domain origin* refers to the base URL for accessing a website including the protocol (`http/https`), the domain name, and the port number (if specified).
     *
     * You must only submit a *base URL* and not a full path. For example, `https://docs.aws.amazon.com`.
     */
    public val origins: List<String>? = builder.origins
    /**
     * The Amazon Resource Name (ARN) of the service role attached to your web experience.
     *
     * You must provide this value if you're using IAM Identity Center to manage end user access to your application. If you're using legacy identity management to manage user access, you don't need to provide this value.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Determines whether sample prompts are enabled in the web experience for an end user.
     */
    public val samplePromptsControlMode: aws.sdk.kotlin.services.qbusiness.model.WebExperienceSamplePromptsControlMode? = builder.samplePromptsControlMode
    /**
     * A subtitle to personalize your Amazon Q Business web experience.
     */
    public val subtitle: kotlin.String? = builder.subtitle
    /**
     * A list of key-value pairs that identify or categorize your Amazon Q Business web experience. You can also use tags to help control access to the web experience. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The title for your Amazon Q Business web experience.
     */
    public val title: kotlin.String? = builder.title
    /**
     * The customized welcome message for end users of an Amazon Q Business web experience.
     */
    public val welcomeMessage: kotlin.String? = builder.welcomeMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.CreateWebExperienceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateWebExperienceRequest(")
        append("applicationId=$applicationId,")
        append("browserExtensionConfiguration=$browserExtensionConfiguration,")
        append("clientToken=$clientToken,")
        append("customizationConfiguration=$customizationConfiguration,")
        append("identityProviderConfiguration=$identityProviderConfiguration,")
        append("origins=$origins,")
        append("roleArn=$roleArn,")
        append("samplePromptsControlMode=$samplePromptsControlMode,")
        append("subtitle=$subtitle,")
        append("tags=$tags,")
        append("title=$title,")
        append("welcomeMessage=$welcomeMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (browserExtensionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (customizationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (identityProviderConfiguration?.hashCode() ?: 0)
        result = 31 * result + (origins?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (samplePromptsControlMode?.hashCode() ?: 0)
        result = 31 * result + (subtitle?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (welcomeMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateWebExperienceRequest

        if (applicationId != other.applicationId) return false
        if (browserExtensionConfiguration != other.browserExtensionConfiguration) return false
        if (clientToken != other.clientToken) return false
        if (customizationConfiguration != other.customizationConfiguration) return false
        if (identityProviderConfiguration != other.identityProviderConfiguration) return false
        if (origins != other.origins) return false
        if (roleArn != other.roleArn) return false
        if (samplePromptsControlMode != other.samplePromptsControlMode) return false
        if (subtitle != other.subtitle) return false
        if (tags != other.tags) return false
        if (title != other.title) return false
        if (welcomeMessage != other.welcomeMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.CreateWebExperienceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the Amazon Q Business web experience.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The browser extension configuration for an Amazon Q Business web experience.
         *
         *  For Amazon Q Business application using external OIDC-compliant identity providers (IdPs). The IdP administrator must add the browser extension sign-in redirect URLs to the IdP application. For more information, see [Configure external OIDC identity provider for your browser extensions.](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/browser-extensions.html).
         */
        public var browserExtensionConfiguration: aws.sdk.kotlin.services.qbusiness.model.BrowserExtensionConfiguration? = null
        /**
         * A token you provide to identify a request to create an Amazon Q Business web experience.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Sets the custom logo, favicon, font, and color used in the Amazon Q web experience.
         */
        public var customizationConfiguration: aws.sdk.kotlin.services.qbusiness.model.CustomizationConfiguration? = null
        /**
         * Information about the identity provider (IdP) used to authenticate end users of an Amazon Q Business web experience.
         */
        public var identityProviderConfiguration: aws.sdk.kotlin.services.qbusiness.model.IdentityProviderConfiguration? = null
        /**
         * Sets the website domain origins that are allowed to embed the Amazon Q Business web experience. The *domain origin* refers to the base URL for accessing a website including the protocol (`http/https`), the domain name, and the port number (if specified).
         *
         * You must only submit a *base URL* and not a full path. For example, `https://docs.aws.amazon.com`.
         */
        public var origins: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the service role attached to your web experience.
         *
         * You must provide this value if you're using IAM Identity Center to manage end user access to your application. If you're using legacy identity management to manage user access, you don't need to provide this value.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Determines whether sample prompts are enabled in the web experience for an end user.
         */
        public var samplePromptsControlMode: aws.sdk.kotlin.services.qbusiness.model.WebExperienceSamplePromptsControlMode? = null
        /**
         * A subtitle to personalize your Amazon Q Business web experience.
         */
        public var subtitle: kotlin.String? = null
        /**
         * A list of key-value pairs that identify or categorize your Amazon Q Business web experience. You can also use tags to help control access to the web experience. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
         */
        public var tags: List<Tag>? = null
        /**
         * The title for your Amazon Q Business web experience.
         */
        public var title: kotlin.String? = null
        /**
         * The customized welcome message for end users of an Amazon Q Business web experience.
         */
        public var welcomeMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.CreateWebExperienceRequest) : this() {
            this.applicationId = x.applicationId
            this.browserExtensionConfiguration = x.browserExtensionConfiguration
            this.clientToken = x.clientToken
            this.customizationConfiguration = x.customizationConfiguration
            this.identityProviderConfiguration = x.identityProviderConfiguration
            this.origins = x.origins
            this.roleArn = x.roleArn
            this.samplePromptsControlMode = x.samplePromptsControlMode
            this.subtitle = x.subtitle
            this.tags = x.tags
            this.title = x.title
            this.welcomeMessage = x.welcomeMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.CreateWebExperienceRequest = CreateWebExperienceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.BrowserExtensionConfiguration] inside the given [block]
         */
        public fun browserExtensionConfiguration(block: aws.sdk.kotlin.services.qbusiness.model.BrowserExtensionConfiguration.Builder.() -> kotlin.Unit) {
            this.browserExtensionConfiguration = aws.sdk.kotlin.services.qbusiness.model.BrowserExtensionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.CustomizationConfiguration] inside the given [block]
         */
        public fun customizationConfiguration(block: aws.sdk.kotlin.services.qbusiness.model.CustomizationConfiguration.Builder.() -> kotlin.Unit) {
            this.customizationConfiguration = aws.sdk.kotlin.services.qbusiness.model.CustomizationConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
