// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.content.Document

public class CreateDataSourceRequest private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon Q Business application the data source will be attached to.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * A token you provide to identify a request to create a data source connector. Multiple calls to the `CreateDataSource` API with the same client token will create only one data source connector.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Configuration information to connect your data source repository to Amazon Q Business. Use this parameter to provide a JSON schema with configuration information specific to your data source connector.
     *
     * Each data source has a JSON schema provided by Amazon Q Business that you must use. For example, the Amazon S3 and Web Crawler connectors require the following JSON schemas:
     * + [Amazon S3 JSON schema](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/s3-api.html)
     * + [Web Crawler JSON schema](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/web-crawler-api.html)
     *
     * You can find configuration templates for your specific data source using the following steps:
     * + Navigate to the [Supported connectors](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connectors-list.html) page in the Amazon Q Business User Guide, and select the data source of your choice.
     * + Then, from your specific data source connector page, select **Using the API**. You will find the JSON schema for your data source, including parameter descriptions, in this section.
     */
    public val configuration: aws.smithy.kotlin.runtime.content.Document? = builder.configuration
    /**
     * A description for the data source connector.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A name for the data source connector.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * Provides the configuration information for altering document metadata and content during the document ingestion process.
     *
     * For more information, see [Custom document enrichment](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html).
     */
    public val documentEnrichmentConfiguration: aws.sdk.kotlin.services.qbusiness.model.DocumentEnrichmentConfiguration? = builder.documentEnrichmentConfiguration
    /**
     * The identifier of the index that you want to use with the data source connector.
     */
    public val indexId: kotlin.String? = builder.indexId
    /**
     * The configuration for extracting information from media in documents during ingestion.
     */
    public val mediaExtractionConfiguration: aws.sdk.kotlin.services.qbusiness.model.MediaExtractionConfiguration? = builder.mediaExtractionConfiguration
    /**
     * The Amazon Resource Name (ARN) of an IAM role with permission to access the data source and required resources.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Sets the frequency for Amazon Q Business to check the documents in your data source repository and update your index. If you don't set a schedule, Amazon Q Business won't periodically update the index.
     *
     * Specify a `cron-` format schedule string or an empty string to indicate that the index is updated on demand. You can't specify the `Schedule` parameter when the `Type` parameter is set to `CUSTOM`. If you do, you receive a `ValidationException` exception.
     */
    public val syncSchedule: kotlin.String? = builder.syncSchedule
    /**
     * A list of key-value pairs that identify or categorize the data source connector. You can also use tags to help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source. For more information, see [Using Amazon VPC with Amazon Q Business connectors](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connector-vpc.html).
     */
    public val vpcConfiguration: aws.sdk.kotlin.services.qbusiness.model.DataSourceVpcConfiguration? = builder.vpcConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.CreateDataSourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDataSourceRequest(")
        append("applicationId=$applicationId,")
        append("clientToken=$clientToken,")
        append("configuration=$configuration,")
        append("description=$description,")
        append("displayName=$displayName,")
        append("documentEnrichmentConfiguration=$documentEnrichmentConfiguration,")
        append("indexId=$indexId,")
        append("mediaExtractionConfiguration=$mediaExtractionConfiguration,")
        append("roleArn=$roleArn,")
        append("syncSchedule=$syncSchedule,")
        append("tags=$tags,")
        append("vpcConfiguration=$vpcConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (documentEnrichmentConfiguration?.hashCode() ?: 0)
        result = 31 * result + (indexId?.hashCode() ?: 0)
        result = 31 * result + (mediaExtractionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (syncSchedule?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDataSourceRequest

        if (applicationId != other.applicationId) return false
        if (clientToken != other.clientToken) return false
        if (configuration != other.configuration) return false
        if (description != other.description) return false
        if (displayName != other.displayName) return false
        if (documentEnrichmentConfiguration != other.documentEnrichmentConfiguration) return false
        if (indexId != other.indexId) return false
        if (mediaExtractionConfiguration != other.mediaExtractionConfiguration) return false
        if (roleArn != other.roleArn) return false
        if (syncSchedule != other.syncSchedule) return false
        if (tags != other.tags) return false
        if (vpcConfiguration != other.vpcConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.CreateDataSourceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the Amazon Q Business application the data source will be attached to.
         */
        public var applicationId: kotlin.String? = null
        /**
         * A token you provide to identify a request to create a data source connector. Multiple calls to the `CreateDataSource` API with the same client token will create only one data source connector.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Configuration information to connect your data source repository to Amazon Q Business. Use this parameter to provide a JSON schema with configuration information specific to your data source connector.
         *
         * Each data source has a JSON schema provided by Amazon Q Business that you must use. For example, the Amazon S3 and Web Crawler connectors require the following JSON schemas:
         * + [Amazon S3 JSON schema](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/s3-api.html)
         * + [Web Crawler JSON schema](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/web-crawler-api.html)
         *
         * You can find configuration templates for your specific data source using the following steps:
         * + Navigate to the [Supported connectors](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connectors-list.html) page in the Amazon Q Business User Guide, and select the data source of your choice.
         * + Then, from your specific data source connector page, select **Using the API**. You will find the JSON schema for your data source, including parameter descriptions, in this section.
         */
        public var configuration: aws.smithy.kotlin.runtime.content.Document? = null
        /**
         * A description for the data source connector.
         */
        public var description: kotlin.String? = null
        /**
         * A name for the data source connector.
         */
        public var displayName: kotlin.String? = null
        /**
         * Provides the configuration information for altering document metadata and content during the document ingestion process.
         *
         * For more information, see [Custom document enrichment](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html).
         */
        public var documentEnrichmentConfiguration: aws.sdk.kotlin.services.qbusiness.model.DocumentEnrichmentConfiguration? = null
        /**
         * The identifier of the index that you want to use with the data source connector.
         */
        public var indexId: kotlin.String? = null
        /**
         * The configuration for extracting information from media in documents during ingestion.
         */
        public var mediaExtractionConfiguration: aws.sdk.kotlin.services.qbusiness.model.MediaExtractionConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role with permission to access the data source and required resources.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Sets the frequency for Amazon Q Business to check the documents in your data source repository and update your index. If you don't set a schedule, Amazon Q Business won't periodically update the index.
         *
         * Specify a `cron-` format schedule string or an empty string to indicate that the index is updated on demand. You can't specify the `Schedule` parameter when the `Type` parameter is set to `CUSTOM`. If you do, you receive a `ValidationException` exception.
         */
        public var syncSchedule: kotlin.String? = null
        /**
         * A list of key-value pairs that identify or categorize the data source connector. You can also use tags to help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
         */
        public var tags: List<Tag>? = null
        /**
         * Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source. For more information, see [Using Amazon VPC with Amazon Q Business connectors](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connector-vpc.html).
         */
        public var vpcConfiguration: aws.sdk.kotlin.services.qbusiness.model.DataSourceVpcConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.CreateDataSourceRequest) : this() {
            this.applicationId = x.applicationId
            this.clientToken = x.clientToken
            this.configuration = x.configuration
            this.description = x.description
            this.displayName = x.displayName
            this.documentEnrichmentConfiguration = x.documentEnrichmentConfiguration
            this.indexId = x.indexId
            this.mediaExtractionConfiguration = x.mediaExtractionConfiguration
            this.roleArn = x.roleArn
            this.syncSchedule = x.syncSchedule
            this.tags = x.tags
            this.vpcConfiguration = x.vpcConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.CreateDataSourceRequest = CreateDataSourceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.DocumentEnrichmentConfiguration] inside the given [block]
         */
        public fun documentEnrichmentConfiguration(block: aws.sdk.kotlin.services.qbusiness.model.DocumentEnrichmentConfiguration.Builder.() -> kotlin.Unit) {
            this.documentEnrichmentConfiguration = aws.sdk.kotlin.services.qbusiness.model.DocumentEnrichmentConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.MediaExtractionConfiguration] inside the given [block]
         */
        public fun mediaExtractionConfiguration(block: aws.sdk.kotlin.services.qbusiness.model.MediaExtractionConfiguration.Builder.() -> kotlin.Unit) {
            this.mediaExtractionConfiguration = aws.sdk.kotlin.services.qbusiness.model.MediaExtractionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.DataSourceVpcConfiguration] inside the given [block]
         */
        public fun vpcConfiguration(block: aws.sdk.kotlin.services.qbusiness.model.DataSourceVpcConfiguration.Builder.() -> kotlin.Unit) {
            this.vpcConfiguration = aws.sdk.kotlin.services.qbusiness.model.DataSourceVpcConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
