// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary information for an Amazon Q Business application.
 */
public class Application private constructor(builder: Builder) {
    /**
     * The identifier for the Amazon Q Business application.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The Unix timestamp when the Amazon Q Business application was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The name of the Amazon Q Business application.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * The authentication type being used by a Amazon Q Business application.
     */
    public val identityType: aws.sdk.kotlin.services.qbusiness.model.IdentityType? = builder.identityType
    /**
     * The Amazon QuickSight configuration for an Amazon Q Business application that uses QuickSight as the identity provider.
     */
    public val quickSightConfiguration: aws.sdk.kotlin.services.qbusiness.model.QuickSightConfiguration? = builder.quickSightConfiguration
    /**
     * The status of the Amazon Q Business application. The application is ready to use when the status is `ACTIVE`.
     */
    public val status: aws.sdk.kotlin.services.qbusiness.model.ApplicationStatus? = builder.status
    /**
     * The Unix timestamp when the Amazon Q Business application was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.Application = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Application(")
        append("applicationId=$applicationId,")
        append("createdAt=$createdAt,")
        append("displayName=$displayName,")
        append("identityType=$identityType,")
        append("quickSightConfiguration=$quickSightConfiguration,")
        append("status=$status,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (identityType?.hashCode() ?: 0)
        result = 31 * result + (quickSightConfiguration?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Application

        if (applicationId != other.applicationId) return false
        if (createdAt != other.createdAt) return false
        if (displayName != other.displayName) return false
        if (identityType != other.identityType) return false
        if (quickSightConfiguration != other.quickSightConfiguration) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.Application = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier for the Amazon Q Business application.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The Unix timestamp when the Amazon Q Business application was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the Amazon Q Business application.
         */
        public var displayName: kotlin.String? = null
        /**
         * The authentication type being used by a Amazon Q Business application.
         */
        public var identityType: aws.sdk.kotlin.services.qbusiness.model.IdentityType? = null
        /**
         * The Amazon QuickSight configuration for an Amazon Q Business application that uses QuickSight as the identity provider.
         */
        public var quickSightConfiguration: aws.sdk.kotlin.services.qbusiness.model.QuickSightConfiguration? = null
        /**
         * The status of the Amazon Q Business application. The application is ready to use when the status is `ACTIVE`.
         */
        public var status: aws.sdk.kotlin.services.qbusiness.model.ApplicationStatus? = null
        /**
         * The Unix timestamp when the Amazon Q Business application was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.Application) : this() {
            this.applicationId = x.applicationId
            this.createdAt = x.createdAt
            this.displayName = x.displayName
            this.identityType = x.identityType
            this.quickSightConfiguration = x.quickSightConfiguration
            this.status = x.status
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.Application = Application(this)

        /**
         * construct an [aws.sdk.kotlin.services.qbusiness.model.QuickSightConfiguration] inside the given [block]
         */
        public fun quickSightConfiguration(block: aws.sdk.kotlin.services.qbusiness.model.QuickSightConfiguration.Builder.() -> kotlin.Unit) {
            this.quickSightConfiguration = aws.sdk.kotlin.services.qbusiness.model.QuickSightConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
