// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An output event that Amazon Q Business returns to an user who wants to perform a plugin action during a non-streaming chat conversation. It contains information about the selected action with a list of possible user input fields, some pre-populated by Amazon Q Business.
 */
public class ActionReview private constructor(builder: Builder) {
    /**
     * Field values that an end user needs to provide to Amazon Q Business for Amazon Q Business to perform the requested plugin action.
     */
    public val payload: Map<String, ActionReviewPayloadField>? = builder.payload
    /**
     * A string used to retain information about the hierarchical contexts within an action review payload.
     */
    public val payloadFieldNameSeparator: kotlin.String? = builder.payloadFieldNameSeparator
    /**
     * The identifier of the plugin associated with the action review.
     */
    public val pluginId: kotlin.String? = builder.pluginId
    /**
     * The type of plugin.
     */
    public val pluginType: aws.sdk.kotlin.services.qbusiness.model.PluginType? = builder.pluginType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qbusiness.model.ActionReview = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActionReview(")
        append("payload=$payload,")
        append("payloadFieldNameSeparator=$payloadFieldNameSeparator,")
        append("pluginId=$pluginId,")
        append("pluginType=$pluginType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = payload?.hashCode() ?: 0
        result = 31 * result + (payloadFieldNameSeparator?.hashCode() ?: 0)
        result = 31 * result + (pluginId?.hashCode() ?: 0)
        result = 31 * result + (pluginType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActionReview

        if (payload != other.payload) return false
        if (payloadFieldNameSeparator != other.payloadFieldNameSeparator) return false
        if (pluginId != other.pluginId) return false
        if (pluginType != other.pluginType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qbusiness.model.ActionReview = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Field values that an end user needs to provide to Amazon Q Business for Amazon Q Business to perform the requested plugin action.
         */
        public var payload: Map<String, ActionReviewPayloadField>? = null
        /**
         * A string used to retain information about the hierarchical contexts within an action review payload.
         */
        public var payloadFieldNameSeparator: kotlin.String? = null
        /**
         * The identifier of the plugin associated with the action review.
         */
        public var pluginId: kotlin.String? = null
        /**
         * The type of plugin.
         */
        public var pluginType: aws.sdk.kotlin.services.qbusiness.model.PluginType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qbusiness.model.ActionReview) : this() {
            this.payload = x.payload
            this.payloadFieldNameSeparator = x.payloadFieldNameSeparator
            this.pluginId = x.pluginId
            this.pluginType = x.pluginType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qbusiness.model.ActionReview = ActionReview(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
