// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.qbusiness.auth.DefaultQBusinessAuthSchemeProvider
import aws.sdk.kotlin.services.qbusiness.auth.QBusinessAuthSchemeProvider
import aws.sdk.kotlin.services.qbusiness.endpoints.DefaultQBusinessEndpointProvider
import aws.sdk.kotlin.services.qbusiness.endpoints.QBusinessEndpointParameters
import aws.sdk.kotlin.services.qbusiness.endpoints.QBusinessEndpointProvider
import aws.sdk.kotlin.services.qbusiness.model.AssociatePermissionRequest
import aws.sdk.kotlin.services.qbusiness.model.AssociatePermissionResponse
import aws.sdk.kotlin.services.qbusiness.model.BatchDeleteDocumentRequest
import aws.sdk.kotlin.services.qbusiness.model.BatchDeleteDocumentResponse
import aws.sdk.kotlin.services.qbusiness.model.BatchPutDocumentRequest
import aws.sdk.kotlin.services.qbusiness.model.BatchPutDocumentResponse
import aws.sdk.kotlin.services.qbusiness.model.CancelSubscriptionRequest
import aws.sdk.kotlin.services.qbusiness.model.CancelSubscriptionResponse
import aws.sdk.kotlin.services.qbusiness.model.ChatRequest
import aws.sdk.kotlin.services.qbusiness.model.ChatResponse
import aws.sdk.kotlin.services.qbusiness.model.ChatSyncRequest
import aws.sdk.kotlin.services.qbusiness.model.ChatSyncResponse
import aws.sdk.kotlin.services.qbusiness.model.CreateApplicationRequest
import aws.sdk.kotlin.services.qbusiness.model.CreateApplicationResponse
import aws.sdk.kotlin.services.qbusiness.model.CreateDataAccessorRequest
import aws.sdk.kotlin.services.qbusiness.model.CreateDataAccessorResponse
import aws.sdk.kotlin.services.qbusiness.model.CreateDataSourceRequest
import aws.sdk.kotlin.services.qbusiness.model.CreateDataSourceResponse
import aws.sdk.kotlin.services.qbusiness.model.CreateIndexRequest
import aws.sdk.kotlin.services.qbusiness.model.CreateIndexResponse
import aws.sdk.kotlin.services.qbusiness.model.CreatePluginRequest
import aws.sdk.kotlin.services.qbusiness.model.CreatePluginResponse
import aws.sdk.kotlin.services.qbusiness.model.CreateRetrieverRequest
import aws.sdk.kotlin.services.qbusiness.model.CreateRetrieverResponse
import aws.sdk.kotlin.services.qbusiness.model.CreateSubscriptionRequest
import aws.sdk.kotlin.services.qbusiness.model.CreateSubscriptionResponse
import aws.sdk.kotlin.services.qbusiness.model.CreateUserRequest
import aws.sdk.kotlin.services.qbusiness.model.CreateUserResponse
import aws.sdk.kotlin.services.qbusiness.model.CreateWebExperienceRequest
import aws.sdk.kotlin.services.qbusiness.model.CreateWebExperienceResponse
import aws.sdk.kotlin.services.qbusiness.model.DeleteApplicationRequest
import aws.sdk.kotlin.services.qbusiness.model.DeleteApplicationResponse
import aws.sdk.kotlin.services.qbusiness.model.DeleteChatControlsConfigurationRequest
import aws.sdk.kotlin.services.qbusiness.model.DeleteChatControlsConfigurationResponse
import aws.sdk.kotlin.services.qbusiness.model.DeleteConversationRequest
import aws.sdk.kotlin.services.qbusiness.model.DeleteConversationResponse
import aws.sdk.kotlin.services.qbusiness.model.DeleteDataAccessorRequest
import aws.sdk.kotlin.services.qbusiness.model.DeleteDataAccessorResponse
import aws.sdk.kotlin.services.qbusiness.model.DeleteDataSourceRequest
import aws.sdk.kotlin.services.qbusiness.model.DeleteDataSourceResponse
import aws.sdk.kotlin.services.qbusiness.model.DeleteGroupRequest
import aws.sdk.kotlin.services.qbusiness.model.DeleteGroupResponse
import aws.sdk.kotlin.services.qbusiness.model.DeleteIndexRequest
import aws.sdk.kotlin.services.qbusiness.model.DeleteIndexResponse
import aws.sdk.kotlin.services.qbusiness.model.DeletePluginRequest
import aws.sdk.kotlin.services.qbusiness.model.DeletePluginResponse
import aws.sdk.kotlin.services.qbusiness.model.DeleteRetrieverRequest
import aws.sdk.kotlin.services.qbusiness.model.DeleteRetrieverResponse
import aws.sdk.kotlin.services.qbusiness.model.DeleteUserRequest
import aws.sdk.kotlin.services.qbusiness.model.DeleteUserResponse
import aws.sdk.kotlin.services.qbusiness.model.DeleteWebExperienceRequest
import aws.sdk.kotlin.services.qbusiness.model.DeleteWebExperienceResponse
import aws.sdk.kotlin.services.qbusiness.model.DisassociatePermissionRequest
import aws.sdk.kotlin.services.qbusiness.model.DisassociatePermissionResponse
import aws.sdk.kotlin.services.qbusiness.model.GetApplicationRequest
import aws.sdk.kotlin.services.qbusiness.model.GetApplicationResponse
import aws.sdk.kotlin.services.qbusiness.model.GetChatControlsConfigurationRequest
import aws.sdk.kotlin.services.qbusiness.model.GetChatControlsConfigurationResponse
import aws.sdk.kotlin.services.qbusiness.model.GetDataAccessorRequest
import aws.sdk.kotlin.services.qbusiness.model.GetDataAccessorResponse
import aws.sdk.kotlin.services.qbusiness.model.GetDataSourceRequest
import aws.sdk.kotlin.services.qbusiness.model.GetDataSourceResponse
import aws.sdk.kotlin.services.qbusiness.model.GetGroupRequest
import aws.sdk.kotlin.services.qbusiness.model.GetGroupResponse
import aws.sdk.kotlin.services.qbusiness.model.GetIndexRequest
import aws.sdk.kotlin.services.qbusiness.model.GetIndexResponse
import aws.sdk.kotlin.services.qbusiness.model.GetMediaRequest
import aws.sdk.kotlin.services.qbusiness.model.GetMediaResponse
import aws.sdk.kotlin.services.qbusiness.model.GetPluginRequest
import aws.sdk.kotlin.services.qbusiness.model.GetPluginResponse
import aws.sdk.kotlin.services.qbusiness.model.GetPolicyRequest
import aws.sdk.kotlin.services.qbusiness.model.GetPolicyResponse
import aws.sdk.kotlin.services.qbusiness.model.GetRetrieverRequest
import aws.sdk.kotlin.services.qbusiness.model.GetRetrieverResponse
import aws.sdk.kotlin.services.qbusiness.model.GetUserRequest
import aws.sdk.kotlin.services.qbusiness.model.GetUserResponse
import aws.sdk.kotlin.services.qbusiness.model.GetWebExperienceRequest
import aws.sdk.kotlin.services.qbusiness.model.GetWebExperienceResponse
import aws.sdk.kotlin.services.qbusiness.model.ListApplicationsRequest
import aws.sdk.kotlin.services.qbusiness.model.ListApplicationsResponse
import aws.sdk.kotlin.services.qbusiness.model.ListAttachmentsRequest
import aws.sdk.kotlin.services.qbusiness.model.ListAttachmentsResponse
import aws.sdk.kotlin.services.qbusiness.model.ListConversationsRequest
import aws.sdk.kotlin.services.qbusiness.model.ListConversationsResponse
import aws.sdk.kotlin.services.qbusiness.model.ListDataAccessorsRequest
import aws.sdk.kotlin.services.qbusiness.model.ListDataAccessorsResponse
import aws.sdk.kotlin.services.qbusiness.model.ListDataSourceSyncJobsRequest
import aws.sdk.kotlin.services.qbusiness.model.ListDataSourceSyncJobsResponse
import aws.sdk.kotlin.services.qbusiness.model.ListDataSourcesRequest
import aws.sdk.kotlin.services.qbusiness.model.ListDataSourcesResponse
import aws.sdk.kotlin.services.qbusiness.model.ListDocumentsRequest
import aws.sdk.kotlin.services.qbusiness.model.ListDocumentsResponse
import aws.sdk.kotlin.services.qbusiness.model.ListGroupsRequest
import aws.sdk.kotlin.services.qbusiness.model.ListGroupsResponse
import aws.sdk.kotlin.services.qbusiness.model.ListIndicesRequest
import aws.sdk.kotlin.services.qbusiness.model.ListIndicesResponse
import aws.sdk.kotlin.services.qbusiness.model.ListMessagesRequest
import aws.sdk.kotlin.services.qbusiness.model.ListMessagesResponse
import aws.sdk.kotlin.services.qbusiness.model.ListPluginActionsRequest
import aws.sdk.kotlin.services.qbusiness.model.ListPluginActionsResponse
import aws.sdk.kotlin.services.qbusiness.model.ListPluginTypeActionsRequest
import aws.sdk.kotlin.services.qbusiness.model.ListPluginTypeActionsResponse
import aws.sdk.kotlin.services.qbusiness.model.ListPluginTypeMetadataRequest
import aws.sdk.kotlin.services.qbusiness.model.ListPluginTypeMetadataResponse
import aws.sdk.kotlin.services.qbusiness.model.ListPluginsRequest
import aws.sdk.kotlin.services.qbusiness.model.ListPluginsResponse
import aws.sdk.kotlin.services.qbusiness.model.ListRetrieversRequest
import aws.sdk.kotlin.services.qbusiness.model.ListRetrieversResponse
import aws.sdk.kotlin.services.qbusiness.model.ListSubscriptionsRequest
import aws.sdk.kotlin.services.qbusiness.model.ListSubscriptionsResponse
import aws.sdk.kotlin.services.qbusiness.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.qbusiness.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.qbusiness.model.ListWebExperiencesRequest
import aws.sdk.kotlin.services.qbusiness.model.ListWebExperiencesResponse
import aws.sdk.kotlin.services.qbusiness.model.PutFeedbackRequest
import aws.sdk.kotlin.services.qbusiness.model.PutFeedbackResponse
import aws.sdk.kotlin.services.qbusiness.model.PutGroupRequest
import aws.sdk.kotlin.services.qbusiness.model.PutGroupResponse
import aws.sdk.kotlin.services.qbusiness.model.SearchRelevantContentRequest
import aws.sdk.kotlin.services.qbusiness.model.SearchRelevantContentResponse
import aws.sdk.kotlin.services.qbusiness.model.StartDataSourceSyncJobRequest
import aws.sdk.kotlin.services.qbusiness.model.StartDataSourceSyncJobResponse
import aws.sdk.kotlin.services.qbusiness.model.StopDataSourceSyncJobRequest
import aws.sdk.kotlin.services.qbusiness.model.StopDataSourceSyncJobResponse
import aws.sdk.kotlin.services.qbusiness.model.TagResourceRequest
import aws.sdk.kotlin.services.qbusiness.model.TagResourceResponse
import aws.sdk.kotlin.services.qbusiness.model.UntagResourceRequest
import aws.sdk.kotlin.services.qbusiness.model.UntagResourceResponse
import aws.sdk.kotlin.services.qbusiness.model.UpdateApplicationRequest
import aws.sdk.kotlin.services.qbusiness.model.UpdateApplicationResponse
import aws.sdk.kotlin.services.qbusiness.model.UpdateChatControlsConfigurationRequest
import aws.sdk.kotlin.services.qbusiness.model.UpdateChatControlsConfigurationResponse
import aws.sdk.kotlin.services.qbusiness.model.UpdateDataAccessorRequest
import aws.sdk.kotlin.services.qbusiness.model.UpdateDataAccessorResponse
import aws.sdk.kotlin.services.qbusiness.model.UpdateDataSourceRequest
import aws.sdk.kotlin.services.qbusiness.model.UpdateDataSourceResponse
import aws.sdk.kotlin.services.qbusiness.model.UpdateIndexRequest
import aws.sdk.kotlin.services.qbusiness.model.UpdateIndexResponse
import aws.sdk.kotlin.services.qbusiness.model.UpdatePluginRequest
import aws.sdk.kotlin.services.qbusiness.model.UpdatePluginResponse
import aws.sdk.kotlin.services.qbusiness.model.UpdateRetrieverRequest
import aws.sdk.kotlin.services.qbusiness.model.UpdateRetrieverResponse
import aws.sdk.kotlin.services.qbusiness.model.UpdateSubscriptionRequest
import aws.sdk.kotlin.services.qbusiness.model.UpdateSubscriptionResponse
import aws.sdk.kotlin.services.qbusiness.model.UpdateUserRequest
import aws.sdk.kotlin.services.qbusiness.model.UpdateUserResponse
import aws.sdk.kotlin.services.qbusiness.model.UpdateWebExperienceRequest
import aws.sdk.kotlin.services.qbusiness.model.UpdateWebExperienceResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "QBusiness"
public const val SdkVersion: String = "1.4.10"
public const val ServiceApiVersion: String = "2023-11-27"

/**
 * This is the *Amazon Q Business* API Reference. Amazon Q Business is a fully managed, generative-AI powered enterprise chat assistant that you can deploy within your organization. Amazon Q Business enhances employee productivity by supporting key tasks such as question-answering, knowledge discovery, writing email messages, summarizing text, drafting document outlines, and brainstorming ideas. Users ask questions of Amazon Q Business and get answers that are presented in a conversational manner. For an introduction to the service, see the *Amazon Q Business User Guide*[](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/what-is.html).
 *
 * For an overview of the Amazon Q Business APIs, see [Overview of Amazon Q Business API operations](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/api-ref.html#api-overview).
 *
 * For information about the IAM access control permissions you need to use this API, see [IAM roles for Amazon Q Business](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/iam-roles.html) in the *Amazon Q Business User Guide*.
 *
 * The following resources provide additional information about using the Amazon Q Business API:
 * + *[Setting up for Amazon Q Business](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/setting-up.html)*
 * + *[Amazon Q Business CLI Reference](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/qbusiness/index.html)*
 * + *[Amazon Web Services General Reference](https://docs.aws.amazon.com/general/latest/gr/amazonq.html)*
 */
public interface QBusinessClient : SdkClient {
    /**
     * QBusinessClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, QBusinessClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "QBusiness",
                "QBUSINESS",
                "qbusiness",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, QBusinessClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): QBusinessClient = DefaultQBusinessClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: QBusinessEndpointProvider = builder.endpointProvider ?: DefaultQBusinessEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: QBusinessAuthSchemeProvider = builder.authSchemeProvider ?: DefaultQBusinessAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "QBusiness"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: QBusinessEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: QBusinessAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Adds or updates a permission policy for a Amazon Q Business application, allowing cross-account access for an ISV. This operation creates a new policy statement for the specified Amazon Q Business application. The policy statement defines the IAM actions that the ISV is allowed to perform on the Amazon Q Business application's resources.
     */
    public suspend fun associatePermission(input: AssociatePermissionRequest): AssociatePermissionResponse

    /**
     * Asynchronously deletes one or more documents added using the `BatchPutDocument` API from an Amazon Q Business index.
     *
     * You can see the progress of the deletion, and any error messages related to the process, by using CloudWatch.
     */
    public suspend fun batchDeleteDocument(input: BatchDeleteDocumentRequest): BatchDeleteDocumentResponse

    /**
     * Adds one or more documents to an Amazon Q Business index.
     *
     * You use this API to:
     * + ingest your structured and unstructured documents and documents stored in an Amazon S3 bucket into an Amazon Q Business index.
     * + add custom attributes to documents in an Amazon Q Business index.
     * + attach an access control list to the documents added to an Amazon Q Business index.
     *
     * You can see the progress of the deletion, and any error messages related to the process, by using CloudWatch.
     */
    public suspend fun batchPutDocument(input: BatchPutDocumentRequest): BatchPutDocumentResponse

    /**
     * Unsubscribes a user or a group from their pricing tier in an Amazon Q Business application. An unsubscribed user or group loses all Amazon Q Business feature access at the start of next month.
     */
    public suspend fun cancelSubscription(input: CancelSubscriptionRequest): CancelSubscriptionResponse

    /**
     * Starts or continues a streaming Amazon Q Business conversation.
     */
    public suspend fun <T> chat(input: ChatRequest, block: suspend (ChatResponse) -> T): T

    /**
     * Starts or continues a non-streaming Amazon Q Business conversation.
     */
    public suspend fun chatSync(input: ChatSyncRequest): ChatSyncResponse

    /**
     * Creates an Amazon Q Business application.
     *
     * There are new tiers for Amazon Q Business. Not all features in Amazon Q Business Pro are also available in Amazon Q Business Lite. For information on what's included in Amazon Q Business Lite and what's included in Amazon Q Business Pro, see [Amazon Q Business tiers](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/tiers.html#user-sub-tiers). You must use the Amazon Q Business console to assign subscription tiers to users.
     *
     * An Amazon Q Apps service linked role will be created if it's absent in the Amazon Web Services account when `QAppsConfiguration` is enabled in the request. For more information, see [ Using service-linked roles for Q Apps](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/using-service-linked-roles-qapps.html).
     *
     * When you create an application, Amazon Q Business may securely transmit data for processing from your selected Amazon Web Services region, but within your geography. For more information, see [Cross region inference in Amazon Q Business](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/cross-region-inference.html).
     */
    public suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse

    /**
     * Creates a new data accessor for an ISV to access data from a Amazon Q Business application. The data accessor is an entity that represents the ISV's access to the Amazon Q Business application's data. It includes the IAM role ARN for the ISV, a friendly name, and a set of action configurations that define the specific actions the ISV is allowed to perform and any associated data filters. When the data accessor is created, an IAM Identity Center application is also created to manage the ISV's identity and authentication for accessing the Amazon Q Business application.
     */
    public suspend fun createDataAccessor(input: CreateDataAccessorRequest): CreateDataAccessorResponse

    /**
     * Creates a data source connector for an Amazon Q Business application.
     *
     * `CreateDataSource` is a synchronous operation. The operation returns 200 if the data source was successfully created. Otherwise, an exception is raised.
     */
    public suspend fun createDataSource(input: CreateDataSourceRequest): CreateDataSourceResponse

    /**
     * Creates an Amazon Q Business index.
     *
     * To determine if index creation has completed, check the `Status` field returned from a call to `DescribeIndex`. The `Status` field is set to `ACTIVE` when the index is ready to use.
     *
     * Once the index is active, you can index your documents using the `BatchPutDocument`[](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_BatchPutDocument.html) API or the `CreateDataSource`[](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_CreateDataSource.html) API.
     */
    public suspend fun createIndex(input: CreateIndexRequest): CreateIndexResponse

    /**
     * Creates an Amazon Q Business plugin.
     */
    public suspend fun createPlugin(input: CreatePluginRequest): CreatePluginResponse

    /**
     * Adds a retriever to your Amazon Q Business application.
     */
    public suspend fun createRetriever(input: CreateRetrieverRequest): CreateRetrieverResponse

    /**
     * Subscribes an IAM Identity Center user or a group to a pricing tier for an Amazon Q Business application.
     *
     * Amazon Q Business offers two subscription tiers: `Q_LITE` and `Q_BUSINESS`. Subscription tier determines feature access for the user. For more information on subscriptions and pricing tiers, see [Amazon Q Business pricing](https://aws.amazon.com/q/business/pricing/).
     */
    public suspend fun createSubscription(input: CreateSubscriptionRequest): CreateSubscriptionResponse

    /**
     * Creates a universally unique identifier (UUID) mapped to a list of local user ids within an application.
     */
    public suspend fun createUser(input: CreateUserRequest): CreateUserResponse

    /**
     * Creates an Amazon Q Business web experience.
     */
    public suspend fun createWebExperience(input: CreateWebExperienceRequest): CreateWebExperienceResponse

    /**
     * Deletes an Amazon Q Business application.
     */
    public suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse

    /**
     * Deletes chat controls configured for an existing Amazon Q Business application.
     */
    public suspend fun deleteChatControlsConfiguration(input: DeleteChatControlsConfigurationRequest): DeleteChatControlsConfigurationResponse

    /**
     * Deletes an Amazon Q Business web experience conversation.
     */
    public suspend fun deleteConversation(input: DeleteConversationRequest): DeleteConversationResponse

    /**
     * Deletes a specified data accessor. This operation permanently removes the data accessor and its associated IAM Identity Center application. Any access granted to the ISV through this data accessor will be revoked.
     */
    public suspend fun deleteDataAccessor(input: DeleteDataAccessorRequest): DeleteDataAccessorResponse

    /**
     * Deletes an Amazon Q Business data source connector. While the data source is being deleted, the `Status` field returned by a call to the `DescribeDataSource` API is set to `DELETING`.
     */
    public suspend fun deleteDataSource(input: DeleteDataSourceRequest): DeleteDataSourceResponse

    /**
     * Deletes a group so that all users and sub groups that belong to the group can no longer access documents only available to that group. For example, after deleting the group "Summer Interns", all interns who belonged to that group no longer see intern-only documents in their chat results.
     *
     * If you want to delete, update, or replace users or sub groups of a group, you need to use the `PutGroup` operation. For example, if a user in the group "Engineering" leaves the engineering team and another user takes their place, you provide an updated list of users or sub groups that belong to the "Engineering" group when calling `PutGroup`.
     */
    public suspend fun deleteGroup(input: DeleteGroupRequest): DeleteGroupResponse

    /**
     * Deletes an Amazon Q Business index.
     */
    public suspend fun deleteIndex(input: DeleteIndexRequest): DeleteIndexResponse

    /**
     * Deletes an Amazon Q Business plugin.
     */
    public suspend fun deletePlugin(input: DeletePluginRequest): DeletePluginResponse

    /**
     * Deletes the retriever used by an Amazon Q Business application.
     */
    public suspend fun deleteRetriever(input: DeleteRetrieverRequest): DeleteRetrieverResponse

    /**
     * Deletes a user by email id.
     */
    public suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse

    /**
     * Deletes an Amazon Q Business web experience.
     */
    public suspend fun deleteWebExperience(input: DeleteWebExperienceRequest): DeleteWebExperienceResponse

    /**
     * Removes a permission policy from a Amazon Q Business application, revoking the cross-account access that was previously granted to an ISV. This operation deletes the specified policy statement from the application's permission policy.
     */
    public suspend fun disassociatePermission(input: DisassociatePermissionRequest): DisassociatePermissionResponse

    /**
     * Gets information about an existing Amazon Q Business application.
     */
    public suspend fun getApplication(input: GetApplicationRequest): GetApplicationResponse

    /**
     * Gets information about an chat controls configured for an existing Amazon Q Business application.
     */
    public suspend fun getChatControlsConfiguration(input: GetChatControlsConfigurationRequest): GetChatControlsConfigurationResponse

    /**
     * Retrieves information about a specified data accessor. This operation returns details about the data accessor, including its display name, unique identifier, Amazon Resource Name (ARN), the associated Amazon Q Business application and IAM Identity Center application, the IAM role for the ISV, the action configurations, and the timestamps for when the data accessor was created and last updated.
     */
    public suspend fun getDataAccessor(input: GetDataAccessorRequest): GetDataAccessorResponse

    /**
     * Gets information about an existing Amazon Q Business data source connector.
     */
    public suspend fun getDataSource(input: GetDataSourceRequest): GetDataSourceResponse

    /**
     * Describes a group by group name.
     */
    public suspend fun getGroup(input: GetGroupRequest): GetGroupResponse

    /**
     * Gets information about an existing Amazon Q Business index.
     */
    public suspend fun getIndex(input: GetIndexRequest): GetIndexResponse

    /**
     * Returns the image bytes corresponding to a media object. If you have implemented your own application with the Chat and ChatSync APIs, and have enabled content extraction from visual data in Amazon Q Business, you use the GetMedia API operation to download the images so you can show them in your UI with responses.
     *
     * For more information, see [Extracting semantic meaning from images and visuals](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/extracting-meaning-from-images.html).
     */
    public suspend fun getMedia(input: GetMediaRequest): GetMediaResponse

    /**
     * Gets information about an existing Amazon Q Business plugin.
     */
    public suspend fun getPlugin(input: GetPluginRequest): GetPluginResponse

    /**
     * Retrieves the current permission policy for a Amazon Q Business application. The policy is returned as a JSON-formatted string and defines the IAM actions that are allowed or denied for the application's resources.
     */
    public suspend fun getPolicy(input: GetPolicyRequest): GetPolicyResponse

    /**
     * Gets information about an existing retriever used by an Amazon Q Business application.
     */
    public suspend fun getRetriever(input: GetRetrieverRequest): GetRetrieverResponse

    /**
     * Describes the universally unique identifier (UUID) associated with a local user in a data source.
     */
    public suspend fun getUser(input: GetUserRequest): GetUserResponse

    /**
     * Gets information about an existing Amazon Q Business web experience.
     */
    public suspend fun getWebExperience(input: GetWebExperienceRequest): GetWebExperienceResponse

    /**
     * Lists Amazon Q Business applications.
     *
     * Amazon Q Business applications may securely transmit data for processing across Amazon Web Services Regions within your geography. For more information, see [Cross region inference in Amazon Q Business](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/cross-region-inference.html).
     */
    public suspend fun listApplications(input: ListApplicationsRequest = ListApplicationsRequest { }): ListApplicationsResponse

    /**
     * Gets a list of attachments associated with an Amazon Q Business web experience or a list of attachements associated with a specific Amazon Q Business conversation.
     */
    public suspend fun listAttachments(input: ListAttachmentsRequest): ListAttachmentsResponse

    /**
     * Lists one or more Amazon Q Business conversations.
     */
    public suspend fun listConversations(input: ListConversationsRequest): ListConversationsResponse

    /**
     * Lists the data accessors for a Amazon Q Business application. This operation returns a paginated list of data accessor summaries, including the friendly name, unique identifier, ARN, associated IAM role, and creation/update timestamps for each data accessor.
     */
    public suspend fun listDataAccessors(input: ListDataAccessorsRequest): ListDataAccessorsResponse

    /**
     * Get information about an Amazon Q Business data source connector synchronization.
     */
    public suspend fun listDataSourceSyncJobs(input: ListDataSourceSyncJobsRequest): ListDataSourceSyncJobsResponse

    /**
     * Lists the Amazon Q Business data source connectors that you have created.
     */
    public suspend fun listDataSources(input: ListDataSourcesRequest): ListDataSourcesResponse

    /**
     * A list of documents attached to an index.
     */
    public suspend fun listDocuments(input: ListDocumentsRequest): ListDocumentsResponse

    /**
     * Provides a list of groups that are mapped to users.
     */
    public suspend fun listGroups(input: ListGroupsRequest): ListGroupsResponse

    /**
     * Lists the Amazon Q Business indices you have created.
     */
    public suspend fun listIndices(input: ListIndicesRequest): ListIndicesResponse

    /**
     * Gets a list of messages associated with an Amazon Q Business web experience.
     */
    public suspend fun listMessages(input: ListMessagesRequest): ListMessagesResponse

    /**
     * Lists configured Amazon Q Business actions for a specific plugin in an Amazon Q Business application.
     */
    public suspend fun listPluginActions(input: ListPluginActionsRequest): ListPluginActionsResponse

    /**
     * Lists configured Amazon Q Business actions for any plugin type—both built-in and custom.
     */
    public suspend fun listPluginTypeActions(input: ListPluginTypeActionsRequest): ListPluginTypeActionsResponse

    /**
     * Lists metadata for all Amazon Q Business plugin types.
     */
    public suspend fun listPluginTypeMetadata(input: ListPluginTypeMetadataRequest = ListPluginTypeMetadataRequest { }): ListPluginTypeMetadataResponse

    /**
     * Lists configured Amazon Q Business plugins.
     */
    public suspend fun listPlugins(input: ListPluginsRequest): ListPluginsResponse

    /**
     * Lists the retriever used by an Amazon Q Business application.
     */
    public suspend fun listRetrievers(input: ListRetrieversRequest): ListRetrieversResponse

    /**
     * Lists all subscriptions created in an Amazon Q Business application.
     */
    public suspend fun listSubscriptions(input: ListSubscriptionsRequest): ListSubscriptionsResponse

    /**
     * Gets a list of tags associated with a specified resource. Amazon Q Business applications and data sources can have tags associated with them.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists one or more Amazon Q Business Web Experiences.
     */
    public suspend fun listWebExperiences(input: ListWebExperiencesRequest): ListWebExperiencesResponse

    /**
     * Enables your end user to provide feedback on their Amazon Q Business generated chat responses.
     */
    public suspend fun putFeedback(input: PutFeedbackRequest): PutFeedbackResponse

    /**
     * Create, or updates, a mapping of users—who have access to a document—to groups.
     *
     * You can also map sub groups to groups. For example, the group "Company Intellectual Property Teams" includes sub groups "Research" and "Engineering". These sub groups include their own list of users or people who work in these teams. Only users who work in research and engineering, and therefore belong in the intellectual property group, can see top-secret company documents in their Amazon Q Business chat results.
     *
     * There are two options for creating groups, either passing group members inline or using an S3 file via the S3PathForGroupMembers field. For inline groups, there is a limit of 1000 members per group and for provided S3 files there is a limit of 100 thousand members. When creating a group using an S3 file, you provide both an S3 file and a `RoleArn` for Amazon Q Buisness to access the file.
     */
    public suspend fun putGroup(input: PutGroupRequest): PutGroupResponse

    /**
     * Searches for relevant content in a Amazon Q Business application based on a query. This operation takes a search query text, the Amazon Q Business application identifier, and optional filters (such as content source and maximum results) as input. It returns a list of relevant content items, where each item includes the content text, the unique document identifier, the document title, the document URI, any relevant document attributes, and score attributes indicating the confidence level of the relevance.
     */
    public suspend fun searchRelevantContent(input: SearchRelevantContentRequest): SearchRelevantContentResponse

    /**
     * Starts a data source connector synchronization job. If a synchronization job is already in progress, Amazon Q Business returns a `ConflictException`.
     */
    public suspend fun startDataSourceSyncJob(input: StartDataSourceSyncJobRequest): StartDataSourceSyncJobResponse

    /**
     * Stops an Amazon Q Business data source connector synchronization job already in progress.
     */
    public suspend fun stopDataSourceSyncJob(input: StopDataSourceSyncJobRequest): StopDataSourceSyncJobResponse

    /**
     * Adds the specified tag to the specified Amazon Q Business application or data source resource. If the tag already exists, the existing value is replaced with the new value.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a tag from an Amazon Q Business application or a data source.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an existing Amazon Q Business application.
     *
     * Amazon Q Business applications may securely transmit data for processing across Amazon Web Services Regions within your geography. For more information, see [Cross region inference in Amazon Q Business](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/cross-region-inference.html).
     *
     * An Amazon Q Apps service-linked role will be created if it's absent in the Amazon Web Services account when `QAppsConfiguration` is enabled in the request. For more information, see [Using service-linked roles for Q Apps](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/using-service-linked-roles-qapps.html).
     */
    public suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse

    /**
     * Updates an set of chat controls configured for an existing Amazon Q Business application.
     */
    public suspend fun updateChatControlsConfiguration(input: UpdateChatControlsConfigurationRequest): UpdateChatControlsConfigurationResponse

    /**
     * Updates an existing data accessor. This operation allows modifying the action configurations (the allowed actions and associated filters) and the display name of the data accessor. It does not allow changing the IAM role associated with the data accessor or other core properties of the data accessor.
     */
    public suspend fun updateDataAccessor(input: UpdateDataAccessorRequest): UpdateDataAccessorResponse

    /**
     * Updates an existing Amazon Q Business data source connector.
     */
    public suspend fun updateDataSource(input: UpdateDataSourceRequest): UpdateDataSourceResponse

    /**
     * Updates an Amazon Q Business index.
     */
    public suspend fun updateIndex(input: UpdateIndexRequest): UpdateIndexResponse

    /**
     * Updates an Amazon Q Business plugin.
     */
    public suspend fun updatePlugin(input: UpdatePluginRequest): UpdatePluginResponse

    /**
     * Updates the retriever used for your Amazon Q Business application.
     */
    public suspend fun updateRetriever(input: UpdateRetrieverRequest): UpdateRetrieverResponse

    /**
     * Updates the pricing tier for an Amazon Q Business subscription. Upgrades are instant. Downgrades apply at the start of the next month. Subscription tier determines feature access for the user. For more information on subscriptions and pricing tiers, see [Amazon Q Business pricing](https://aws.amazon.com/q/business/pricing/).
     */
    public suspend fun updateSubscription(input: UpdateSubscriptionRequest): UpdateSubscriptionResponse

    /**
     * Updates a information associated with a user id.
     */
    public suspend fun updateUser(input: UpdateUserRequest): UpdateUserResponse

    /**
     * Updates an Amazon Q Business web experience.
     */
    public suspend fun updateWebExperience(input: UpdateWebExperienceRequest): UpdateWebExperienceResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun QBusinessClient.withConfig(block: QBusinessClient.Config.Builder.() -> Unit): QBusinessClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultQBusinessClient(newConfig)
}

/**
 * Adds or updates a permission policy for a Amazon Q Business application, allowing cross-account access for an ISV. This operation creates a new policy statement for the specified Amazon Q Business application. The policy statement defines the IAM actions that the ISV is allowed to perform on the Amazon Q Business application's resources.
 */
public suspend inline fun QBusinessClient.associatePermission(crossinline block: AssociatePermissionRequest.Builder.() -> Unit): AssociatePermissionResponse = associatePermission(AssociatePermissionRequest.Builder().apply(block).build())

/**
 * Asynchronously deletes one or more documents added using the `BatchPutDocument` API from an Amazon Q Business index.
 *
 * You can see the progress of the deletion, and any error messages related to the process, by using CloudWatch.
 */
public suspend inline fun QBusinessClient.batchDeleteDocument(crossinline block: BatchDeleteDocumentRequest.Builder.() -> Unit): BatchDeleteDocumentResponse = batchDeleteDocument(BatchDeleteDocumentRequest.Builder().apply(block).build())

/**
 * Adds one or more documents to an Amazon Q Business index.
 *
 * You use this API to:
 * + ingest your structured and unstructured documents and documents stored in an Amazon S3 bucket into an Amazon Q Business index.
 * + add custom attributes to documents in an Amazon Q Business index.
 * + attach an access control list to the documents added to an Amazon Q Business index.
 *
 * You can see the progress of the deletion, and any error messages related to the process, by using CloudWatch.
 */
public suspend inline fun QBusinessClient.batchPutDocument(crossinline block: BatchPutDocumentRequest.Builder.() -> Unit): BatchPutDocumentResponse = batchPutDocument(BatchPutDocumentRequest.Builder().apply(block).build())

/**
 * Unsubscribes a user or a group from their pricing tier in an Amazon Q Business application. An unsubscribed user or group loses all Amazon Q Business feature access at the start of next month.
 */
public suspend inline fun QBusinessClient.cancelSubscription(crossinline block: CancelSubscriptionRequest.Builder.() -> Unit): CancelSubscriptionResponse = cancelSubscription(CancelSubscriptionRequest.Builder().apply(block).build())

/**
 * Starts or continues a non-streaming Amazon Q Business conversation.
 */
public suspend inline fun QBusinessClient.chatSync(crossinline block: ChatSyncRequest.Builder.() -> Unit): ChatSyncResponse = chatSync(ChatSyncRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Q Business application.
 *
 * There are new tiers for Amazon Q Business. Not all features in Amazon Q Business Pro are also available in Amazon Q Business Lite. For information on what's included in Amazon Q Business Lite and what's included in Amazon Q Business Pro, see [Amazon Q Business tiers](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/tiers.html#user-sub-tiers). You must use the Amazon Q Business console to assign subscription tiers to users.
 *
 * An Amazon Q Apps service linked role will be created if it's absent in the Amazon Web Services account when `QAppsConfiguration` is enabled in the request. For more information, see [ Using service-linked roles for Q Apps](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/using-service-linked-roles-qapps.html).
 *
 * When you create an application, Amazon Q Business may securely transmit data for processing from your selected Amazon Web Services region, but within your geography. For more information, see [Cross region inference in Amazon Q Business](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/cross-region-inference.html).
 */
public suspend inline fun QBusinessClient.createApplication(crossinline block: CreateApplicationRequest.Builder.() -> Unit): CreateApplicationResponse = createApplication(CreateApplicationRequest.Builder().apply(block).build())

/**
 * Creates a new data accessor for an ISV to access data from a Amazon Q Business application. The data accessor is an entity that represents the ISV's access to the Amazon Q Business application's data. It includes the IAM role ARN for the ISV, a friendly name, and a set of action configurations that define the specific actions the ISV is allowed to perform and any associated data filters. When the data accessor is created, an IAM Identity Center application is also created to manage the ISV's identity and authentication for accessing the Amazon Q Business application.
 */
public suspend inline fun QBusinessClient.createDataAccessor(crossinline block: CreateDataAccessorRequest.Builder.() -> Unit): CreateDataAccessorResponse = createDataAccessor(CreateDataAccessorRequest.Builder().apply(block).build())

/**
 * Creates a data source connector for an Amazon Q Business application.
 *
 * `CreateDataSource` is a synchronous operation. The operation returns 200 if the data source was successfully created. Otherwise, an exception is raised.
 */
public suspend inline fun QBusinessClient.createDataSource(crossinline block: CreateDataSourceRequest.Builder.() -> Unit): CreateDataSourceResponse = createDataSource(CreateDataSourceRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Q Business index.
 *
 * To determine if index creation has completed, check the `Status` field returned from a call to `DescribeIndex`. The `Status` field is set to `ACTIVE` when the index is ready to use.
 *
 * Once the index is active, you can index your documents using the `BatchPutDocument`[](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_BatchPutDocument.html) API or the `CreateDataSource`[](https://docs.aws.amazon.com/amazonq/latest/api-reference/API_CreateDataSource.html) API.
 */
public suspend inline fun QBusinessClient.createIndex(crossinline block: CreateIndexRequest.Builder.() -> Unit): CreateIndexResponse = createIndex(CreateIndexRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Q Business plugin.
 */
public suspend inline fun QBusinessClient.createPlugin(crossinline block: CreatePluginRequest.Builder.() -> Unit): CreatePluginResponse = createPlugin(CreatePluginRequest.Builder().apply(block).build())

/**
 * Adds a retriever to your Amazon Q Business application.
 */
public suspend inline fun QBusinessClient.createRetriever(crossinline block: CreateRetrieverRequest.Builder.() -> Unit): CreateRetrieverResponse = createRetriever(CreateRetrieverRequest.Builder().apply(block).build())

/**
 * Subscribes an IAM Identity Center user or a group to a pricing tier for an Amazon Q Business application.
 *
 * Amazon Q Business offers two subscription tiers: `Q_LITE` and `Q_BUSINESS`. Subscription tier determines feature access for the user. For more information on subscriptions and pricing tiers, see [Amazon Q Business pricing](https://aws.amazon.com/q/business/pricing/).
 */
public suspend inline fun QBusinessClient.createSubscription(crossinline block: CreateSubscriptionRequest.Builder.() -> Unit): CreateSubscriptionResponse = createSubscription(CreateSubscriptionRequest.Builder().apply(block).build())

/**
 * Creates a universally unique identifier (UUID) mapped to a list of local user ids within an application.
 */
public suspend inline fun QBusinessClient.createUser(crossinline block: CreateUserRequest.Builder.() -> Unit): CreateUserResponse = createUser(CreateUserRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Q Business web experience.
 */
public suspend inline fun QBusinessClient.createWebExperience(crossinline block: CreateWebExperienceRequest.Builder.() -> Unit): CreateWebExperienceResponse = createWebExperience(CreateWebExperienceRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Q Business application.
 */
public suspend inline fun QBusinessClient.deleteApplication(crossinline block: DeleteApplicationRequest.Builder.() -> Unit): DeleteApplicationResponse = deleteApplication(DeleteApplicationRequest.Builder().apply(block).build())

/**
 * Deletes chat controls configured for an existing Amazon Q Business application.
 */
public suspend inline fun QBusinessClient.deleteChatControlsConfiguration(crossinline block: DeleteChatControlsConfigurationRequest.Builder.() -> Unit): DeleteChatControlsConfigurationResponse = deleteChatControlsConfiguration(DeleteChatControlsConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Q Business web experience conversation.
 */
public suspend inline fun QBusinessClient.deleteConversation(crossinline block: DeleteConversationRequest.Builder.() -> Unit): DeleteConversationResponse = deleteConversation(DeleteConversationRequest.Builder().apply(block).build())

/**
 * Deletes a specified data accessor. This operation permanently removes the data accessor and its associated IAM Identity Center application. Any access granted to the ISV through this data accessor will be revoked.
 */
public suspend inline fun QBusinessClient.deleteDataAccessor(crossinline block: DeleteDataAccessorRequest.Builder.() -> Unit): DeleteDataAccessorResponse = deleteDataAccessor(DeleteDataAccessorRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Q Business data source connector. While the data source is being deleted, the `Status` field returned by a call to the `DescribeDataSource` API is set to `DELETING`.
 */
public suspend inline fun QBusinessClient.deleteDataSource(crossinline block: DeleteDataSourceRequest.Builder.() -> Unit): DeleteDataSourceResponse = deleteDataSource(DeleteDataSourceRequest.Builder().apply(block).build())

/**
 * Deletes a group so that all users and sub groups that belong to the group can no longer access documents only available to that group. For example, after deleting the group "Summer Interns", all interns who belonged to that group no longer see intern-only documents in their chat results.
 *
 * If you want to delete, update, or replace users or sub groups of a group, you need to use the `PutGroup` operation. For example, if a user in the group "Engineering" leaves the engineering team and another user takes their place, you provide an updated list of users or sub groups that belong to the "Engineering" group when calling `PutGroup`.
 */
public suspend inline fun QBusinessClient.deleteGroup(crossinline block: DeleteGroupRequest.Builder.() -> Unit): DeleteGroupResponse = deleteGroup(DeleteGroupRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Q Business index.
 */
public suspend inline fun QBusinessClient.deleteIndex(crossinline block: DeleteIndexRequest.Builder.() -> Unit): DeleteIndexResponse = deleteIndex(DeleteIndexRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Q Business plugin.
 */
public suspend inline fun QBusinessClient.deletePlugin(crossinline block: DeletePluginRequest.Builder.() -> Unit): DeletePluginResponse = deletePlugin(DeletePluginRequest.Builder().apply(block).build())

/**
 * Deletes the retriever used by an Amazon Q Business application.
 */
public suspend inline fun QBusinessClient.deleteRetriever(crossinline block: DeleteRetrieverRequest.Builder.() -> Unit): DeleteRetrieverResponse = deleteRetriever(DeleteRetrieverRequest.Builder().apply(block).build())

/**
 * Deletes a user by email id.
 */
public suspend inline fun QBusinessClient.deleteUser(crossinline block: DeleteUserRequest.Builder.() -> Unit): DeleteUserResponse = deleteUser(DeleteUserRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Q Business web experience.
 */
public suspend inline fun QBusinessClient.deleteWebExperience(crossinline block: DeleteWebExperienceRequest.Builder.() -> Unit): DeleteWebExperienceResponse = deleteWebExperience(DeleteWebExperienceRequest.Builder().apply(block).build())

/**
 * Removes a permission policy from a Amazon Q Business application, revoking the cross-account access that was previously granted to an ISV. This operation deletes the specified policy statement from the application's permission policy.
 */
public suspend inline fun QBusinessClient.disassociatePermission(crossinline block: DisassociatePermissionRequest.Builder.() -> Unit): DisassociatePermissionResponse = disassociatePermission(DisassociatePermissionRequest.Builder().apply(block).build())

/**
 * Gets information about an existing Amazon Q Business application.
 */
public suspend inline fun QBusinessClient.getApplication(crossinline block: GetApplicationRequest.Builder.() -> Unit): GetApplicationResponse = getApplication(GetApplicationRequest.Builder().apply(block).build())

/**
 * Gets information about an chat controls configured for an existing Amazon Q Business application.
 */
public suspend inline fun QBusinessClient.getChatControlsConfiguration(crossinline block: GetChatControlsConfigurationRequest.Builder.() -> Unit): GetChatControlsConfigurationResponse = getChatControlsConfiguration(GetChatControlsConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves information about a specified data accessor. This operation returns details about the data accessor, including its display name, unique identifier, Amazon Resource Name (ARN), the associated Amazon Q Business application and IAM Identity Center application, the IAM role for the ISV, the action configurations, and the timestamps for when the data accessor was created and last updated.
 */
public suspend inline fun QBusinessClient.getDataAccessor(crossinline block: GetDataAccessorRequest.Builder.() -> Unit): GetDataAccessorResponse = getDataAccessor(GetDataAccessorRequest.Builder().apply(block).build())

/**
 * Gets information about an existing Amazon Q Business data source connector.
 */
public suspend inline fun QBusinessClient.getDataSource(crossinline block: GetDataSourceRequest.Builder.() -> Unit): GetDataSourceResponse = getDataSource(GetDataSourceRequest.Builder().apply(block).build())

/**
 * Describes a group by group name.
 */
public suspend inline fun QBusinessClient.getGroup(crossinline block: GetGroupRequest.Builder.() -> Unit): GetGroupResponse = getGroup(GetGroupRequest.Builder().apply(block).build())

/**
 * Gets information about an existing Amazon Q Business index.
 */
public suspend inline fun QBusinessClient.getIndex(crossinline block: GetIndexRequest.Builder.() -> Unit): GetIndexResponse = getIndex(GetIndexRequest.Builder().apply(block).build())

/**
 * Returns the image bytes corresponding to a media object. If you have implemented your own application with the Chat and ChatSync APIs, and have enabled content extraction from visual data in Amazon Q Business, you use the GetMedia API operation to download the images so you can show them in your UI with responses.
 *
 * For more information, see [Extracting semantic meaning from images and visuals](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/extracting-meaning-from-images.html).
 */
public suspend inline fun QBusinessClient.getMedia(crossinline block: GetMediaRequest.Builder.() -> Unit): GetMediaResponse = getMedia(GetMediaRequest.Builder().apply(block).build())

/**
 * Gets information about an existing Amazon Q Business plugin.
 */
public suspend inline fun QBusinessClient.getPlugin(crossinline block: GetPluginRequest.Builder.() -> Unit): GetPluginResponse = getPlugin(GetPluginRequest.Builder().apply(block).build())

/**
 * Retrieves the current permission policy for a Amazon Q Business application. The policy is returned as a JSON-formatted string and defines the IAM actions that are allowed or denied for the application's resources.
 */
public suspend inline fun QBusinessClient.getPolicy(crossinline block: GetPolicyRequest.Builder.() -> Unit): GetPolicyResponse = getPolicy(GetPolicyRequest.Builder().apply(block).build())

/**
 * Gets information about an existing retriever used by an Amazon Q Business application.
 */
public suspend inline fun QBusinessClient.getRetriever(crossinline block: GetRetrieverRequest.Builder.() -> Unit): GetRetrieverResponse = getRetriever(GetRetrieverRequest.Builder().apply(block).build())

/**
 * Describes the universally unique identifier (UUID) associated with a local user in a data source.
 */
public suspend inline fun QBusinessClient.getUser(crossinline block: GetUserRequest.Builder.() -> Unit): GetUserResponse = getUser(GetUserRequest.Builder().apply(block).build())

/**
 * Gets information about an existing Amazon Q Business web experience.
 */
public suspend inline fun QBusinessClient.getWebExperience(crossinline block: GetWebExperienceRequest.Builder.() -> Unit): GetWebExperienceResponse = getWebExperience(GetWebExperienceRequest.Builder().apply(block).build())

/**
 * Lists Amazon Q Business applications.
 *
 * Amazon Q Business applications may securely transmit data for processing across Amazon Web Services Regions within your geography. For more information, see [Cross region inference in Amazon Q Business](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/cross-region-inference.html).
 */
public suspend inline fun QBusinessClient.listApplications(crossinline block: ListApplicationsRequest.Builder.() -> Unit): ListApplicationsResponse = listApplications(ListApplicationsRequest.Builder().apply(block).build())

/**
 * Gets a list of attachments associated with an Amazon Q Business web experience or a list of attachements associated with a specific Amazon Q Business conversation.
 */
public suspend inline fun QBusinessClient.listAttachments(crossinline block: ListAttachmentsRequest.Builder.() -> Unit): ListAttachmentsResponse = listAttachments(ListAttachmentsRequest.Builder().apply(block).build())

/**
 * Lists one or more Amazon Q Business conversations.
 */
public suspend inline fun QBusinessClient.listConversations(crossinline block: ListConversationsRequest.Builder.() -> Unit): ListConversationsResponse = listConversations(ListConversationsRequest.Builder().apply(block).build())

/**
 * Lists the data accessors for a Amazon Q Business application. This operation returns a paginated list of data accessor summaries, including the friendly name, unique identifier, ARN, associated IAM role, and creation/update timestamps for each data accessor.
 */
public suspend inline fun QBusinessClient.listDataAccessors(crossinline block: ListDataAccessorsRequest.Builder.() -> Unit): ListDataAccessorsResponse = listDataAccessors(ListDataAccessorsRequest.Builder().apply(block).build())

/**
 * Get information about an Amazon Q Business data source connector synchronization.
 */
public suspend inline fun QBusinessClient.listDataSourceSyncJobs(crossinline block: ListDataSourceSyncJobsRequest.Builder.() -> Unit): ListDataSourceSyncJobsResponse = listDataSourceSyncJobs(ListDataSourceSyncJobsRequest.Builder().apply(block).build())

/**
 * Lists the Amazon Q Business data source connectors that you have created.
 */
public suspend inline fun QBusinessClient.listDataSources(crossinline block: ListDataSourcesRequest.Builder.() -> Unit): ListDataSourcesResponse = listDataSources(ListDataSourcesRequest.Builder().apply(block).build())

/**
 * A list of documents attached to an index.
 */
public suspend inline fun QBusinessClient.listDocuments(crossinline block: ListDocumentsRequest.Builder.() -> Unit): ListDocumentsResponse = listDocuments(ListDocumentsRequest.Builder().apply(block).build())

/**
 * Provides a list of groups that are mapped to users.
 */
public suspend inline fun QBusinessClient.listGroups(crossinline block: ListGroupsRequest.Builder.() -> Unit): ListGroupsResponse = listGroups(ListGroupsRequest.Builder().apply(block).build())

/**
 * Lists the Amazon Q Business indices you have created.
 */
public suspend inline fun QBusinessClient.listIndices(crossinline block: ListIndicesRequest.Builder.() -> Unit): ListIndicesResponse = listIndices(ListIndicesRequest.Builder().apply(block).build())

/**
 * Gets a list of messages associated with an Amazon Q Business web experience.
 */
public suspend inline fun QBusinessClient.listMessages(crossinline block: ListMessagesRequest.Builder.() -> Unit): ListMessagesResponse = listMessages(ListMessagesRequest.Builder().apply(block).build())

/**
 * Lists configured Amazon Q Business actions for a specific plugin in an Amazon Q Business application.
 */
public suspend inline fun QBusinessClient.listPluginActions(crossinline block: ListPluginActionsRequest.Builder.() -> Unit): ListPluginActionsResponse = listPluginActions(ListPluginActionsRequest.Builder().apply(block).build())

/**
 * Lists configured Amazon Q Business actions for any plugin type—both built-in and custom.
 */
public suspend inline fun QBusinessClient.listPluginTypeActions(crossinline block: ListPluginTypeActionsRequest.Builder.() -> Unit): ListPluginTypeActionsResponse = listPluginTypeActions(ListPluginTypeActionsRequest.Builder().apply(block).build())

/**
 * Lists metadata for all Amazon Q Business plugin types.
 */
public suspend inline fun QBusinessClient.listPluginTypeMetadata(crossinline block: ListPluginTypeMetadataRequest.Builder.() -> Unit): ListPluginTypeMetadataResponse = listPluginTypeMetadata(ListPluginTypeMetadataRequest.Builder().apply(block).build())

/**
 * Lists configured Amazon Q Business plugins.
 */
public suspend inline fun QBusinessClient.listPlugins(crossinline block: ListPluginsRequest.Builder.() -> Unit): ListPluginsResponse = listPlugins(ListPluginsRequest.Builder().apply(block).build())

/**
 * Lists the retriever used by an Amazon Q Business application.
 */
public suspend inline fun QBusinessClient.listRetrievers(crossinline block: ListRetrieversRequest.Builder.() -> Unit): ListRetrieversResponse = listRetrievers(ListRetrieversRequest.Builder().apply(block).build())

/**
 * Lists all subscriptions created in an Amazon Q Business application.
 */
public suspend inline fun QBusinessClient.listSubscriptions(crossinline block: ListSubscriptionsRequest.Builder.() -> Unit): ListSubscriptionsResponse = listSubscriptions(ListSubscriptionsRequest.Builder().apply(block).build())

/**
 * Gets a list of tags associated with a specified resource. Amazon Q Business applications and data sources can have tags associated with them.
 */
public suspend inline fun QBusinessClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists one or more Amazon Q Business Web Experiences.
 */
public suspend inline fun QBusinessClient.listWebExperiences(crossinline block: ListWebExperiencesRequest.Builder.() -> Unit): ListWebExperiencesResponse = listWebExperiences(ListWebExperiencesRequest.Builder().apply(block).build())

/**
 * Enables your end user to provide feedback on their Amazon Q Business generated chat responses.
 */
public suspend inline fun QBusinessClient.putFeedback(crossinline block: PutFeedbackRequest.Builder.() -> Unit): PutFeedbackResponse = putFeedback(PutFeedbackRequest.Builder().apply(block).build())

/**
 * Create, or updates, a mapping of users—who have access to a document—to groups.
 *
 * You can also map sub groups to groups. For example, the group "Company Intellectual Property Teams" includes sub groups "Research" and "Engineering". These sub groups include their own list of users or people who work in these teams. Only users who work in research and engineering, and therefore belong in the intellectual property group, can see top-secret company documents in their Amazon Q Business chat results.
 *
 * There are two options for creating groups, either passing group members inline or using an S3 file via the S3PathForGroupMembers field. For inline groups, there is a limit of 1000 members per group and for provided S3 files there is a limit of 100 thousand members. When creating a group using an S3 file, you provide both an S3 file and a `RoleArn` for Amazon Q Buisness to access the file.
 */
public suspend inline fun QBusinessClient.putGroup(crossinline block: PutGroupRequest.Builder.() -> Unit): PutGroupResponse = putGroup(PutGroupRequest.Builder().apply(block).build())

/**
 * Searches for relevant content in a Amazon Q Business application based on a query. This operation takes a search query text, the Amazon Q Business application identifier, and optional filters (such as content source and maximum results) as input. It returns a list of relevant content items, where each item includes the content text, the unique document identifier, the document title, the document URI, any relevant document attributes, and score attributes indicating the confidence level of the relevance.
 */
public suspend inline fun QBusinessClient.searchRelevantContent(crossinline block: SearchRelevantContentRequest.Builder.() -> Unit): SearchRelevantContentResponse = searchRelevantContent(SearchRelevantContentRequest.Builder().apply(block).build())

/**
 * Starts a data source connector synchronization job. If a synchronization job is already in progress, Amazon Q Business returns a `ConflictException`.
 */
public suspend inline fun QBusinessClient.startDataSourceSyncJob(crossinline block: StartDataSourceSyncJobRequest.Builder.() -> Unit): StartDataSourceSyncJobResponse = startDataSourceSyncJob(StartDataSourceSyncJobRequest.Builder().apply(block).build())

/**
 * Stops an Amazon Q Business data source connector synchronization job already in progress.
 */
public suspend inline fun QBusinessClient.stopDataSourceSyncJob(crossinline block: StopDataSourceSyncJobRequest.Builder.() -> Unit): StopDataSourceSyncJobResponse = stopDataSourceSyncJob(StopDataSourceSyncJobRequest.Builder().apply(block).build())

/**
 * Adds the specified tag to the specified Amazon Q Business application or data source resource. If the tag already exists, the existing value is replaced with the new value.
 */
public suspend inline fun QBusinessClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a tag from an Amazon Q Business application or a data source.
 */
public suspend inline fun QBusinessClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an existing Amazon Q Business application.
 *
 * Amazon Q Business applications may securely transmit data for processing across Amazon Web Services Regions within your geography. For more information, see [Cross region inference in Amazon Q Business](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/cross-region-inference.html).
 *
 * An Amazon Q Apps service-linked role will be created if it's absent in the Amazon Web Services account when `QAppsConfiguration` is enabled in the request. For more information, see [Using service-linked roles for Q Apps](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/using-service-linked-roles-qapps.html).
 */
public suspend inline fun QBusinessClient.updateApplication(crossinline block: UpdateApplicationRequest.Builder.() -> Unit): UpdateApplicationResponse = updateApplication(UpdateApplicationRequest.Builder().apply(block).build())

/**
 * Updates an set of chat controls configured for an existing Amazon Q Business application.
 */
public suspend inline fun QBusinessClient.updateChatControlsConfiguration(crossinline block: UpdateChatControlsConfigurationRequest.Builder.() -> Unit): UpdateChatControlsConfigurationResponse = updateChatControlsConfiguration(UpdateChatControlsConfigurationRequest.Builder().apply(block).build())

/**
 * Updates an existing data accessor. This operation allows modifying the action configurations (the allowed actions and associated filters) and the display name of the data accessor. It does not allow changing the IAM role associated with the data accessor or other core properties of the data accessor.
 */
public suspend inline fun QBusinessClient.updateDataAccessor(crossinline block: UpdateDataAccessorRequest.Builder.() -> Unit): UpdateDataAccessorResponse = updateDataAccessor(UpdateDataAccessorRequest.Builder().apply(block).build())

/**
 * Updates an existing Amazon Q Business data source connector.
 */
public suspend inline fun QBusinessClient.updateDataSource(crossinline block: UpdateDataSourceRequest.Builder.() -> Unit): UpdateDataSourceResponse = updateDataSource(UpdateDataSourceRequest.Builder().apply(block).build())

/**
 * Updates an Amazon Q Business index.
 */
public suspend inline fun QBusinessClient.updateIndex(crossinline block: UpdateIndexRequest.Builder.() -> Unit): UpdateIndexResponse = updateIndex(UpdateIndexRequest.Builder().apply(block).build())

/**
 * Updates an Amazon Q Business plugin.
 */
public suspend inline fun QBusinessClient.updatePlugin(crossinline block: UpdatePluginRequest.Builder.() -> Unit): UpdatePluginResponse = updatePlugin(UpdatePluginRequest.Builder().apply(block).build())

/**
 * Updates the retriever used for your Amazon Q Business application.
 */
public suspend inline fun QBusinessClient.updateRetriever(crossinline block: UpdateRetrieverRequest.Builder.() -> Unit): UpdateRetrieverResponse = updateRetriever(UpdateRetrieverRequest.Builder().apply(block).build())

/**
 * Updates the pricing tier for an Amazon Q Business subscription. Upgrades are instant. Downgrades apply at the start of the next month. Subscription tier determines feature access for the user. For more information on subscriptions and pricing tiers, see [Amazon Q Business pricing](https://aws.amazon.com/q/business/pricing/).
 */
public suspend inline fun QBusinessClient.updateSubscription(crossinline block: UpdateSubscriptionRequest.Builder.() -> Unit): UpdateSubscriptionResponse = updateSubscription(UpdateSubscriptionRequest.Builder().apply(block).build())

/**
 * Updates a information associated with a user id.
 */
public suspend inline fun QBusinessClient.updateUser(crossinline block: UpdateUserRequest.Builder.() -> Unit): UpdateUserResponse = updateUser(UpdateUserRequest.Builder().apply(block).build())

/**
 * Updates an Amazon Q Business web experience.
 */
public suspend inline fun QBusinessClient.updateWebExperience(crossinline block: UpdateWebExperienceRequest.Builder.() -> Unit): UpdateWebExperienceResponse = updateWebExperience(UpdateWebExperienceRequest.Builder().apply(block).build())
