// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.serde

import aws.sdk.kotlin.services.qbusiness.model.AttachmentsConfiguration
import aws.sdk.kotlin.services.qbusiness.model.AutoSubscriptionConfiguration
import aws.sdk.kotlin.services.qbusiness.model.PersonalizationConfiguration
import aws.sdk.kotlin.services.qbusiness.model.QAppsConfiguration
import aws.sdk.kotlin.services.qbusiness.model.UpdateApplicationRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateApplicationOperationSerializer: HttpSerializer.NonStreaming<UpdateApplicationRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateApplicationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.applicationId) { "applicationId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("applications"))
                add(PercentEncoding.SmithyLabel.encode(input.applicationId))
            }
        }

        val payload = serializeUpdateApplicationOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateApplicationOperationBody(context: ExecutionContext, input: UpdateApplicationRequest): ByteArray {
    val serializer = JsonSerializer()
    val ATTACHMENTSCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("attachmentsConfiguration"))
    val AUTOSUBSCRIPTIONCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("autoSubscriptionConfiguration"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val DISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("displayName"))
    val IDENTITYCENTERINSTANCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("identityCenterInstanceArn"))
    val PERSONALIZATIONCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("personalizationConfiguration"))
    val QAPPSCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("qAppsConfiguration"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTACHMENTSCONFIGURATION_DESCRIPTOR)
        field(AUTOSUBSCRIPTIONCONFIGURATION_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DISPLAYNAME_DESCRIPTOR)
        field(IDENTITYCENTERINSTANCEARN_DESCRIPTOR)
        field(PERSONALIZATIONCONFIGURATION_DESCRIPTOR)
        field(QAPPSCONFIGURATION_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.attachmentsConfiguration?.let { field(ATTACHMENTSCONFIGURATION_DESCRIPTOR, it, ::serializeAttachmentsConfigurationDocument) }
        input.autoSubscriptionConfiguration?.let { field(AUTOSUBSCRIPTIONCONFIGURATION_DESCRIPTOR, it, ::serializeAutoSubscriptionConfigurationDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.displayName?.let { field(DISPLAYNAME_DESCRIPTOR, it) }
        input.identityCenterInstanceArn?.let { field(IDENTITYCENTERINSTANCEARN_DESCRIPTOR, it) }
        input.personalizationConfiguration?.let { field(PERSONALIZATIONCONFIGURATION_DESCRIPTOR, it, ::serializePersonalizationConfigurationDocument) }
        input.qAppsConfiguration?.let { field(QAPPSCONFIGURATION_DESCRIPTOR, it, ::serializeQAppsConfigurationDocument) }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
