// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.serde

import aws.sdk.kotlin.services.qbusiness.model.ErrorDetail
import aws.sdk.kotlin.services.qbusiness.model.GetWebExperienceResponse
import aws.sdk.kotlin.services.qbusiness.model.IdentityProviderConfiguration
import aws.sdk.kotlin.services.qbusiness.model.QBusinessException
import aws.sdk.kotlin.services.qbusiness.model.WebExperienceAuthConfiguration
import aws.sdk.kotlin.services.qbusiness.model.WebExperienceSamplePromptsControlMode
import aws.sdk.kotlin.services.qbusiness.model.WebExperienceStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetWebExperienceOperationDeserializer: HttpDeserializer.NonStreaming<GetWebExperienceResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetWebExperienceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetWebExperienceError(context, call, payload)
        }
        val builder = GetWebExperienceResponse.Builder()

        if (payload != null) {
            deserializeGetWebExperienceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetWebExperienceError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw QBusinessException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> QBusinessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetWebExperienceOperationBody(builder: GetWebExperienceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPLICATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("applicationId"))
    val AUTHENTICATIONCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("authenticationConfiguration"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val DEFAULTENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("defaultEndpoint"))
    val ERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("error"))
    val IDENTITYPROVIDERCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("identityProviderConfiguration"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val SAMPLEPROMPTSCONTROLMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("samplePromptsControlMode"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val SUBTITLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("subtitle"))
    val TITLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("title"))
    val UPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updatedAt"))
    val WEBEXPERIENCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("webExperienceArn"))
    val WEBEXPERIENCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("webExperienceId"))
    val WELCOMEMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("welcomeMessage"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLICATIONID_DESCRIPTOR)
        field(AUTHENTICATIONCONFIGURATION_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DEFAULTENDPOINT_DESCRIPTOR)
        field(ERROR_DESCRIPTOR)
        field(IDENTITYPROVIDERCONFIGURATION_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(SAMPLEPROMPTSCONTROLMODE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(SUBTITLE_DESCRIPTOR)
        field(TITLE_DESCRIPTOR)
        field(UPDATEDAT_DESCRIPTOR)
        field(WEBEXPERIENCEARN_DESCRIPTOR)
        field(WEBEXPERIENCEID_DESCRIPTOR)
        field(WELCOMEMESSAGE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLICATIONID_DESCRIPTOR.index -> builder.applicationId = deserializeString()
                AUTHENTICATIONCONFIGURATION_DESCRIPTOR.index -> builder.authenticationConfiguration = deserializeWebExperienceAuthConfigurationDocument(deserializer)
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DEFAULTENDPOINT_DESCRIPTOR.index -> builder.defaultEndpoint = deserializeString()
                ERROR_DESCRIPTOR.index -> builder.error = deserializeErrorDetailDocument(deserializer)
                IDENTITYPROVIDERCONFIGURATION_DESCRIPTOR.index -> builder.identityProviderConfiguration = deserializeIdentityProviderConfigurationDocument(deserializer)
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                SAMPLEPROMPTSCONTROLMODE_DESCRIPTOR.index -> builder.samplePromptsControlMode = deserializeString().let { WebExperienceSamplePromptsControlMode.fromValue(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { WebExperienceStatus.fromValue(it) }
                SUBTITLE_DESCRIPTOR.index -> builder.subtitle = deserializeString()
                TITLE_DESCRIPTOR.index -> builder.title = deserializeString()
                UPDATEDAT_DESCRIPTOR.index -> builder.updatedAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                WEBEXPERIENCEARN_DESCRIPTOR.index -> builder.webExperienceArn = deserializeString()
                WEBEXPERIENCEID_DESCRIPTOR.index -> builder.webExperienceId = deserializeString()
                WELCOMEMESSAGE_DESCRIPTOR.index -> builder.welcomeMessage = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
