// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.serde

import aws.sdk.kotlin.services.qbusiness.model.AppliedCreatorModeConfiguration
import aws.sdk.kotlin.services.qbusiness.model.BlockedPhrasesConfiguration
import aws.sdk.kotlin.services.qbusiness.model.GetChatControlsConfigurationResponse
import aws.sdk.kotlin.services.qbusiness.model.QBusinessException
import aws.sdk.kotlin.services.qbusiness.model.ResponseScope
import aws.sdk.kotlin.services.qbusiness.model.TopicConfiguration
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetChatControlsConfigurationOperationDeserializer: HttpDeserializer.NonStreaming<GetChatControlsConfigurationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetChatControlsConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetChatControlsConfigurationError(context, call, payload)
        }
        val builder = GetChatControlsConfigurationResponse.Builder()

        if (payload != null) {
            deserializeGetChatControlsConfigurationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetChatControlsConfigurationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw QBusinessException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> QBusinessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetChatControlsConfigurationOperationBody(builder: GetChatControlsConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BLOCKEDPHRASES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("blockedPhrases"))
    val CREATORMODECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("creatorModeConfiguration"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val RESPONSESCOPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("responseScope"))
    val TOPICCONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("topicConfigurations"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BLOCKEDPHRASES_DESCRIPTOR)
        field(CREATORMODECONFIGURATION_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(RESPONSESCOPE_DESCRIPTOR)
        field(TOPICCONFIGURATIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BLOCKEDPHRASES_DESCRIPTOR.index -> builder.blockedPhrases = deserializeBlockedPhrasesConfigurationDocument(deserializer)
                CREATORMODECONFIGURATION_DESCRIPTOR.index -> builder.creatorModeConfiguration = deserializeAppliedCreatorModeConfigurationDocument(deserializer)
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                RESPONSESCOPE_DESCRIPTOR.index -> builder.responseScope = deserializeString().let { ResponseScope.fromValue(it) }
                TOPICCONFIGURATIONS_DESCRIPTOR.index -> builder.topicConfigurations =
                    deserializer.deserializeList(TOPICCONFIGURATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<TopicConfiguration>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTopicConfigurationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
