// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qbusiness.serde

import aws.sdk.kotlin.services.qbusiness.model.CreatePluginRequest
import aws.sdk.kotlin.services.qbusiness.model.CustomPluginConfiguration
import aws.sdk.kotlin.services.qbusiness.model.PluginAuthConfiguration
import aws.sdk.kotlin.services.qbusiness.model.PluginType
import aws.sdk.kotlin.services.qbusiness.model.Tag
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreatePluginOperationSerializer: HttpSerializer.NonStreaming<CreatePluginRequest> {
    override fun serialize(context: ExecutionContext, input: CreatePluginRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.applicationId) { "applicationId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("applications"))
                add(PercentEncoding.SmithyLabel.encode(input.applicationId))
                add(PercentEncoding.Path.encode("plugins"))
            }
        }

        val payload = serializeCreatePluginOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreatePluginOperationBody(context: ExecutionContext, input: CreatePluginRequest): ByteArray {
    val serializer = JsonSerializer()
    val AUTHCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("authConfiguration"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val CUSTOMPLUGINCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("customPluginConfiguration"))
    val DISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("displayName"))
    val SERVERURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("serverUrl"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tags"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHCONFIGURATION_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(CUSTOMPLUGINCONFIGURATION_DESCRIPTOR)
        field(DISPLAYNAME_DESCRIPTOR)
        field(SERVERURL_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.authConfiguration?.let { field(AUTHCONFIGURATION_DESCRIPTOR, it, ::serializePluginAuthConfigurationDocument) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.customPluginConfiguration?.let { field(CUSTOMPLUGINCONFIGURATION_DESCRIPTOR, it, ::serializeCustomPluginConfigurationDocument) }
        input.displayName?.let { field(DISPLAYNAME_DESCRIPTOR, it) }
        input.serverUrl?.let { field(SERVERURL_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.type?.let { field(TYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
